/* IsDir.c -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: isfile.c,v 1.1 92/02/15 03:41:14 lee Exp $ */

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ASCIITRACE
# include <stdio.h>
extern int AsciiTrace;
#endif

/* IsFile(Path) - return 1 if the given Pathname represents a regular file,
 * and 0 otherwise.
 *
 * It's tempting (and wrong) to writ IsFile as
 *	return !IsDir(Path);
 * but this fails for special devices (tape drives, &c.).
 *
 * There is tracing in here so that you can see which files are being
 * investigated by the calling program... On systems that have the `trace'
 * utility, investigate using that instead.
 */

int
IsFile(Path)
    char *Path;
{
    struct stat statbuf;
    register int Result = 1;

#ifdef ASCIITRACE
    if (AsciiTrace > 20) {
	fprintf(stderr, "IsFile(%s)...", Path);
    }
#endif
    if (stat(Path, &statbuf) < 0) return 0;
    if ((statbuf.st_mode & S_IFMT) != S_IFREG) {
	Result = 0;
    }
#ifdef ASCIITRACE
    if (AsciiTrace > 20) {
	fprintf(stderr, " %s\n", Result ? "true" : "false");
    }
#endif
    return Result;
}
