/* smalldb.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: smalldb.h,v 1.4 92/02/15 05:21:38 lee Exp $
 */

/* You must include fcntl.h before this file. */

#ifdef ndbm
# include <ndbm.h>
# define FoundDbmOK
# define NDBM
#endif

#ifdef sdbm
# include "sdbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible */
#endif

#ifdef bsdhash
# include "ndbm.h"
# define FoundDbmOK
# define NDBM /* it's compatible as well... */
#endif

#ifdef gdbm

 * Please ensure that you are not placing lq-text under any copyright (or
 * copyleft) restrictions by using gdbm.  If you are satisfied of that,
 * comment out (do not delete) these three lines.

# include "Liamdbm.h"
#endif

#ifndef FoundDbmOK
you have to define one of the dbm files;
#endif

#ifndef O_RDWR
# include <fcntl.h>
#endif

#define CACHE 2 /* size of DBM cache in startdb() -- I only use two! */
/* If you rip out the dbm cache stuff for use elsewhere, increse the 2
 * to something like 5 or so!!!  Each entry uses two file pointers.
 * Lee
 */

#ifndef CACHE
# define startdb(FilePrefix) dbm_open(FilePrefix, O_RDWR|O_CREAT, 0640)
# define enddb(db) { if (db) dbm_close(db); }
#endif

#ifndef startdb
DBM *startdb();
#endif

#ifndef enddb
# ifdef CACHE
#  define enddb(db) /* nothing to do, because of the cache */
# else
   void enddb();
# endif /* CACHE */
#endif /* !enddb */
