/* putbyte.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: putbyte.h,v 1.1 92/08/24 00:38:51 lee Exp $
 *
 */


/* PutByte gets called literally millions of times, so it is a macro.
 * The idea is that if we reach the end of the block, PutByte calls _PutByte
 * which fetches a new block and sets offset pointers, blocklength, etc.,
 * and resets the char * pointers to point into the right buffer.
 */
#define PutByte(Byte,WID,sp,Blockp,BlockLength,LastStart,NextBlock,NextSize) \
    ( (*(sp) - (unsigned char *) *(Blockp) >= *(BlockLength)) ? \
       _PutByte(Byte,WID,sp,Blockp,BlockLength,LastStart,NextBlock,NextSize) : \
      ((*((*(sp))++) = (Byte)), 0))

#define PutLong(L,WID,sp,Blockp,BlockLength,LastStart,NextBlock,NextSize) \
    (((L) < 128) ? \
	PutByte((L),WID,sp,Blockp,BlockLength,LastStart,NextBlock,NextSize) \
		: \
	_PutLong(L,WID,sp,Blockp,BlockLength,LastStart,NextBlock,NextSize) \
    )

#define GetByte(WID, sp, Blockp, BlockLength, NextBlock) \
    ( \
	(*(sp) - (unsigned char *) *(Blockp) >= *(BlockLength)) \
    ? \
       _GetByte(WID, sp, Blockp, BlockLength, NextBlock) \
    : \
	*((*(sp))++) \
    )

#if 1
#define GetLong(WID, sp, Blockp, BlockLength, NextBlock) \
    ( \
	(*(sp) - (unsigned char *) *(Blockp) >= *(BlockLength) || \
	 ((**(sp)) & 0200) ) /* i.e. the long needs more than one byte */ \
    ? \
	_GetLong(WID, sp, Blockp, BlockLength, NextBlock) \
    : \
	*((*(sp))++) \
    )
#else
# define GetLong _GetLong
#endif
