/* addfile.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* $Id: addfile.h,v 1.4 92/07/21 19:01:25 lee Exp $
 *
 * This file defines the parameter to DumpCache.
 *
 */

#define DUMP_CACHE	00	/* normal usage */
#define DUMP_SYNC	01	/* write all cached entries to disk */
#define DUMP_NOFREE	02	/* don't bother calling free() */
#define DUMP_FAST	04	/* only do a fast dump */

#ifndef DUMP_FAST_THRESH
# define DUMP_FAST_THRESH	1000
#endif

#ifndef DUMP_CACHE_LOW_WATER
# define DUMP_CACHE_BELOW_LOW_WATER(InCacheCount,MaxInCache) \
		((InCacheCount) * 5 <= (MaxInCache) * 4)
#endif
