#include "lexdefs.h"

/*********************  main control ************************/

main(argc,argv)
int argc; char *argv[];
{
  init_params(argv);
  read_inputs();
#ifdef hp
  if (displaying)
    display_init();
#endif
  if (continuing) iterate_snapshots();
  else init_weights();
  training();
#ifdef hp
  if (displaying) gclose(fildes);
#endif
  exit(0);
}


iterate_snapshots()
/* go through the saved snapshots, displaying them on the screen */
{
  register int i;
  int oldt, oldtesting, readfun(), randfun();

  fp=fopen(simufile,"r");
  read_params(fp);
  oldtesting=testing;
  testing=1;				/* we don't want to change weights */
  oldt=0;
  iterate_weights(randfun); /* just to update rand */
  while (fscanf(fp,"%d",&t)!=EOF) /* read the t */
    {
      /* update the shuffling and parameters */
      startt=t+1;
/*      for(i=0; i<startt-oldt; i++) shuffle();*/
      oldt=startt;
      
      /* read the current weights */
      iterate_weights(readfun);
      if (displaying)
	{
	  for(noise=lownoise; noise<highnoise; noise += noisestep)
	    present_inputs();
	  while (getchar()!='\n');
	}
    }
  fclose(fp);
  for (nextsnapshot=0; t >= snapshots[nextsnapshot]; nextsnapshot++){}
  testing=oldtesting;
  noise=0.0;
}

      
training()
{
  for(t=startt; t<=tend; t++)
    {
      present_inputs();
      if (t >= snapshots[nextsnapshot]) save_current();
/*      shuffle();*/
    }
}

present_inputs()
{
  register int i;
  float alpha();
  int lnc,snc;
  while (t>lt_[lphase]) lphase++;
  while (t>st_[sphase]) sphase++;
  while (t>at_[aphase]) aphase++;
  if (stats || displaying) init_stats();  /* clear the books */
  for(i=0; i<ninppairs; i++)
    {
      lnc=nc(t, lphase, lt_, lnc_);
      snc=nc(t, sphase, st_, snc_);
      compute_responses(shuffletable[i], lnc, snc);
      if (!testing)
	modify_weights(lnc, alpha(t, lphase, lt_, lalpha_),
		       snc, alpha(t, sphase, st_, salpha_),
		       alpha(t, aphase, at_, aalpha_),
		       shuffletable[i]);
    }
  if (stats) print_stats();
  if (displaying)
#ifdef hp
/*    display_all_assocs();*/
/*    display_best();*/
    display_selected_assocs();
#else
    print_bestinputs();
#endif  
}


/*********************  feature map responses ************************/

compute_responses(inpv,lnc,snc)
int inpv,lnc,snc;
{
  int lsbesti,lsbestj,slbesti,slbestj;
  /* lexical map */
  if(t>=lt_[-1] && inppairs[inpv].l > (-1))
    find_max_resp(ldim,lnets,lerr,inppairs[inpv].l,lnvectors,lunits,lvectors,
		  &lbesti,&lbestj, &ldeltasum,&lnerr,&lncorr,&lntokcorr,
		  lfirsttok,lntoks);

  /* semantic map */
  if(t>=st_[-1] && inppairs[inpv].s > (-1))
    find_max_resp(sdim,snets,serr,inppairs[inpv].s,snvectors,sunits,svectors,
		  &sbesti,&sbestj, &sdeltasum,&snerr,&sncorr,&sntokcorr,
		  sfirsttok,sntoks);

  /* check associative connections */
  if(t>=lt_[-1] && inppairs[inpv].l>(-1) &&
     t>=st_[-1] && inppairs[inpv].s>(-1) &&
     t>=at_[-1])
    {
      /* we need activity values instead of similarity values
         but we only need them if we are either developing assoc
	 or we are collecting stats or displaying */
      compute_actual_values(lnets,lbesti,lbestj,lunits,lnc);
      compute_actual_values(snets,sbesti,sbestj,sunits,snc);
      if(stats || displaying)
	{
	  find_max_assoc(lnets,snets,lbesti,lbestj,lunits,lsassoc,sunits,lnc,
			inppairs[inpv].l,lvectors,snvectors,&lsbesti,&lsbestj);
	  find_max_assoc(snets,lnets,sbesti,sbestj,sunits,slassoc,lunits,snc,
			inppairs[inpv].s,svectors,lnvectors,&slbesti,&slbestj);
	}
      if(stats)
	{
	  collect_stats(sdim,snvectors,serr,lsbesti,lsbestj,inppairs[inpv].s,
			sunits,svectors,&lsncorr,&lsnerr,&lsdeltasum,
			&lsntokcorr,sfirsttok,sntoks);
	  collect_stats(ldim,lnvectors,lerr,slbesti,slbestj,inppairs[inpv].l,
			lunits,lvectors, &slncorr,&slnerr,&sldeltasum,
			&slntokcorr,lfirsttok,lntoks);
	}
    }
}	



find_max_resp(dim,nets,err,index,nvectors, units,vectors, besti,bestj,
	      deltasum,nerr,ncorr,ntokcorr,firsttok,ntoks)
/* find the maximally responding unit */
struct unitdata units[maxnets][maxnets];
struct inputvectors vectors[maxvectors];
int dim,nets,index,nvectors,*besti,*bestj,*nerr,*ncorr,*ntokcorr,
  firsttok,ntoks;
float err,*deltasum;
{
  int i,j;
  float inpvector[maxdim], best=999999999.9, second=(-1.0);
  float distance(),f01rnd();

  /* form the input vector */
  for(i=0; i<dim; i++)
    inpvector[i]=(1.0-noise)*vectors[index].comp[i]+
      noise*f01rnd();
  /* present it and find the image unit */
  for(i=0; i<nets; i++)
    for(j=0; j<nets; j++)
      {
	units[i][j].value = distance(inpvector,units[i][j].comp,dim);
	/* check if this unit's response is best so far encountered */
	if (units[i][j].value == best) second=best;
	if (units[i][j].value < best)
	  {
	    *besti=i; *bestj=j; best=units[i][j].value;
	  }
	if (displaying)
	  if (units[i][j].value < units[i][j].bestvalue)
	    {
	      units[i][j].bestvalue = units[i][j].value;
	      units[i][j].labels[0] = index;
	    }
      }
  if (second == best)
    printf("Warning at %d: image for %s is not unique\n",
	   t, vectors[index].label);

  if(stats) collect_stats(dim,nvectors,err,*besti,*bestj,index,units,vectors,
			  ncorr,nerr,deltasum,ntokcorr,firsttok,ntoks);
  if(displaying) collect_labels(*besti,*bestj,index,units,0);
}


compute_actual_values(nets,besti,bestj,units,nc)
/* convert the similarity value to activity value in the neighborhood */
int nets,besti,bestj,nc;
struct unitdata units[maxnets][maxnets];
{
  float best, highest;
  register int i,j;

  /* find the most and least active units in the neighborhood */
  best=units[besti][bestj].value;
  highest=(-1.0);
  for(i=besti-nc; i<=besti+nc; i++)
    for(j=bestj-nc; j<=bestj+nc; j++)
      if (i>=0 && i<nets && j>=0 && j<nets)
	if(units[i][j].value>highest)
	  highest=units[i][j].value;
  
  /* adjust the activities */
  if(highest>best)
    for(i=besti-nc; i<=besti+nc; i++)
      for(j=bestj-nc; j<=bestj+nc; j++)
	{
	  if (i>=0 && i<nets && j>=0 && j<nets)
	    units[i][j].value = 1.0 - (units[i][j].value-best)/(highest-best);
	}
  else
    for(i=besti-nc; i<=besti+nc; i++)
      for(j=bestj-nc; j<=bestj+nc; j++)
	if (i>=0 && i<nets && j>=0 && j<nets)
	  units[i][j].value = 1.0;
}
  

find_max_assoc(nets,anets,besti,bestj,units,assoc,aunits,nc,
	       index,vectors,anvectors,abesti,abestj)
/* propagate through the associative connections and find max assoc unit */
int nets,anets,besti,bestj,*abesti,*abestj,index,anvectors,nc;
struct inputvectors vectors[maxvectors];
struct unitdata units[maxnets][maxnets], aunits[maxnets][maxnets];
float assoc[maxnets][maxnets][maxnets][maxnets];
{
  float abest,asecond;
  int i,j,ii,jj;
  struct unitdata assocunits[maxnets][maxnets];

  for(i=0; i<anets; i++)
    for(j=0; j<anets; j++)
      assocunits[i][j].value=0.0;
  
  /* propagate through the active units to the output map; 
     (the sigmoid has been dropped from the assocunit because
     we are only interested in finding the max unit, not its actual value */
  for(i=besti-nc; i<=besti+nc; i++)
    for(j=bestj-nc; j<=bestj+nc; j++)
      if (i>=0 && i<nets && j>=0 && j<nets)
	for(ii=0; ii<anets; ii++)
	  for(jj=0; jj<anets; jj++)
	    assocunits[ii][jj].value += units[i][j].value *assoc[i][j][ii][jj];
  
  /* find the image unit in the output map */
  abest=asecond=(-1.0);
  for(ii=0; ii<anets; ii++)
    for(jj=0; jj<anets; jj++)
      {
	if(assocunits[ii][jj].value == abest) asecond = abest;
	if(assocunits[ii][jj].value>abest)
	  {
	    *abesti=ii; *abestj=jj; abest=assocunits[ii][jj].value;
	  }
      }
  
  if (asecond == abest)
    printf("Warning at %d: association for %s is not unique\n",
	   t, vectors[index].label);
  
  if(displaying) collect_labels(*abesti,*abestj,index,aunits,anvectors);
}
  

/*********************	weight adaptation ************************/

modify_weights(lnc, lalpha, snc, salpha, aalpha, inpv)
/* adapt both maps and the associative connections between them */
int lnc, snc, inpv;
float lalpha, salpha, aalpha;
{
  /* modify weighs toward the input in a neighborhood of the maximally 
     responding unit */

  if(t>=lt_[-1] && t<=lt_[lnphase-1] && inppairs[inpv].l > (-1))
    modify_input_weights(lbesti,lbestj,lnc,lnets,ldim,
			 lunits,lalpha,lvectors,inppairs[inpv].l);
  if(t>=st_[-1] && t<=st_[snphase-1] && inppairs[inpv].s > (-1))
    modify_input_weights(sbesti,sbestj,snc,snets,sdim,
			 sunits,salpha,svectors,inppairs[inpv].s);

  if(t>=lt_[-1] && t>=st_[-1] && t>=at_[-1] && t<=at_[anphase-1]
     && inppairs[inpv].l > (-1) && inppairs[inpv].s > (-1))
    {
      modify_assoc_weights(lnc,snc,lbesti,lbestj,sbesti,sbestj,
			   lnets,snets,lunits,sunits,lsassoc,aalpha);
      modify_assoc_weights(snc,lnc,sbesti,sbestj,lbesti,lbestj,
			   snets,lnets,sunits,lunits,slassoc,aalpha);
    }
}

modify_input_weights(besti,bestj,nc,nets,dim,units,alpha,vectors,index)
/* adapt the input weights of units in the neighborhood of image unit */
int besti,bestj,nc,nets,dim,index;
float alpha;
struct unitdata units[maxnets][maxnets];
struct inputvectors vectors[maxvectors];
{
  int i,j,k;
  for(i=besti-nc; i<=besti+nc; i++)
    for(j=bestj-nc; j<=bestj+nc; j++)
      if (i>=0 && i<nets && j>=0 && j<nets)
	for(k=0; k<dim; k++)
	  /* modify weighs toward the input; equation 6.6 */
	  units[i][j].comp[k] += alpha*
	    (vectors[index].comp[k] - units[i][j].comp[k]);
}


modify_assoc_weights(nc,anc,besti,bestj,abesti,abestj,nets,anets,
		     units,aunits,assoc,aalpha)
/* adapt the associative connections */
int nc,anc,besti,bestj,abesti,abestj,nets,anets;
float aalpha,assoc[maxnets][maxnets][maxnets][maxnets];
struct unitdata units[maxnets][maxnets],aunits[maxnets][maxnets];
{
  int i,j,ii,jj;
  float sum;
  /* zero neighborhoods -> only one strong assoc connection.
     if that is what you want, comment out the following line */
  if (nc==0) nc=1;  if (anc==0) anc=1;
  for(i=besti-nc; i<=besti+nc; i++)
    for(j=bestj-nc; j<=bestj+nc; j++)
      if (i>=0 && i<nets && j>=0 && j<nets)
	{
	  for(ii=abesti-anc; ii<=abesti+anc; ii++)
	    for(jj=abestj-anc; jj<=abestj+anc; jj++)
	      if (ii>=0 && ii<anets && jj>=0 && jj<anets)
		/* modify the associative connections through 
		   Hebbian learning  */
		assoc[i][j][ii][jj] += aalpha*
		  units[i][j].value * aunits[ii][jj].value;
	  /* normalize the associative output connections of a unit */
	  sum =0.0;
	  for(ii=0; ii<anets; ii++)
	    for(jj=0; jj<anets; jj++)
	      sum += assoc[i][j][ii][jj]*assoc[i][j][ii][jj];
	  sum = sqrt(sum);
	  for(ii=0; ii<anets; ii++)
	    for(jj=0; jj<anets; jj++)
	      assoc[i][j][ii][jj] /= sum;
	}	  
}


/*********************  statistics ************************/

collect_stats(dim,nvectors,err,besti,bestj,index,units,vectors,
              ncorr,nerr,deltasum,ntokcorr,firsttok,ntoks)
int dim,nvectors,besti,bestj,index,*ncorr,*nerr,*ntokcorr,
  firsttok, ntoks;
float err,*deltasum;
struct unitdata units[maxnets][maxnets];
struct inputvectors vectors[maxvectors];
{
  register int i;
  for(i=0; i<dim; i++)
    {
      /* cumulate average error */
      *deltasum += fabs(units[besti][bestj].comp[i] - vectors[index].comp[i]);
      /* cumulate number of units within err */
      if(fabs(units[besti][bestj].comp[i]-vectors[index].comp[i])<err)
	(*nerr)++;
    }
  /* cumulate correct word and correct instance count */
  if(determine_nearest(units[besti][bestj].comp,vectors,nvectors,dim) == index)
    {
      (*ncorr)++;
      if(index>=firsttok && index<firsttok+ntoks) (*ntokcorr)++;
    }
}

      
int determine_nearest(rep, vectors, nvectors,dim)
struct inputvectors vectors[maxvectors];
float rep[];
int nvectors,dim;
{
  register int i;
  int bestindex;
  float lbest, dist, distance();
  lbest=999999999.9;
  for(i=0; i<nvectors; i++)
    {
      dist=distance(vectors[i].comp, rep, dim);
      if(dist<lbest)
	{
	  bestindex=i;
	  lbest=dist;
	}
    }
  return(bestindex);
}


collect_labels(besti,bestj,index,units,shiftindex)
int besti,bestj,index;
struct unitdata units[maxnets][maxnets];
{
  /* shift means assoclabel */
  if(newlabel(units[besti][bestj].labels,
	      units[besti][bestj].labelcount,
	      index+shiftindex))
    {
      units[besti][bestj].labelcount++;
      units[besti][bestj].labels[ units[besti][bestj].labelcount ]=
	index+shiftindex;
    }
}


newlabel(labels, count, num)
int labels[], count, num;
{
  register int i;
  for(i=1; i<=count; i++)
    if(labels[i]==num)
      return(0);
  return(1);
}

print_stats()
{
  if(lntokinp==0) lntokinp=1;
  if(sntokinp==0) sntokinp=1;
  printf("Epoch %d, noise %.2f: l: %5.1f %5.1f %5.1f %6.4f  s: %5.1f %5.1f %5.1f %6.4f\n",
         t, noise,
         100.0*lncorr/lninp, 100.0*lntokcorr/lntokinp,
         100.0*lnerr/(ldim*lninp), ldeltasum/(ldim*lninp),
         100.0*sncorr/sninp, 100.0*sntokcorr/sntokinp,
         100.0*snerr/(sdim*sninp), sdeltasum/(sdim*sninp));
  printf("                      sl: %5.1f %5.1f %5.1f %6.4f ls: %5.1f %5.1f %5.1f %6.4f\n",
         100.0*slncorr/aninp, 100.0*slntokcorr/lntokinp,
         100.0*slnerr/(ldim*aninp), sldeltasum/(ldim*aninp),
         100.0*lsncorr/aninp, 100.0*lsntokcorr/sntokinp,
         100.0*lsnerr/(sdim*aninp), lsdeltasum/(sdim*aninp));
}


/*********************  initializations ******************************/

init_params(argv)
char *argv[1];
{
  int c;

  /* we want to use index -1 to refer to initial values */
  lt_=lt_array+1; st_=st_array+1; at_=at_array+1;
  lnc_=lnc_array+1; snc_=snc_array+1;
  lalpha_=lalpha_array+1; salpha_=salpha_array+1; aalpha_=aalpha_array+1;
   
  sprintf(simufile, "%s", argv[1]);
  fp=fopen(simufile,"r");
  read_params(fp);
  if((c=getc(fp))==EOF)
    continuing=0;
  else
    continuing=1;
  fclose(fp);

  startt=lphase=sphase=aphase=0;
  srand48(seed);			/* start random number sequence */
}

read_params(fp)
FILE *fp;
{
  char s[100];
  register int i, phase;
  /* simulation parameters */
  fscanf(fp,"%s", lvectorfile); fgets(s,99,fp);
  fscanf(fp,"%s", svectorfile); fgets(s,99,fp);
  fscanf(fp,"%s", inpfile); fgets(s,99,fp);
  fscanf(fp,"%s", cmapfile); fgets(s,99,fp);
  fscanf(fp,"%s", sb_outdev); fgets(s,99,fp);
  fscanf(fp,"%s", sb_outdriver); fgets(s,99,fp);
  fscanf(fp,"%f %f %f %f", &lleft,&llow,&lright,&lhigh); fgets(s,99,fp);
  fscanf(fp,"%f %f %f %f", &sleft,&slow,&sright,&shigh); fgets(s,99,fp);
  fscanf(fp,"%d %d %d %d %d", &displaying,&stats,&testing,&seed,&tend);
  fgets(s,99,fp);

  fscanf(fp,"%d %d %d %d %f", &lnets,&lnphase,&lt_[-1],&lnc_[-1],&lalpha_[-1]);
  fgets(s,99,fp);
  for(phase=0; phase<lnphase; phase++)
    {
      fscanf(fp,"%d %d %f", &lt_[phase], &lnc_[phase],&lalpha_[phase]);
      fgets(s,99,fp);
    }
  
  fscanf(fp,"%d %d %d %d %f", &snets,&snphase,&st_[-1],&snc_[-1],&salpha_[-1]);
  fgets(s,99,fp);
  for(phase=0; phase<snphase; phase++)
    {
      fscanf(fp,"%d %d %f", &st_[phase], &snc_[phase],&salpha_[phase]);
      fgets(s,99,fp);
    }

  fscanf(fp,"%d %d %f", &anphase,&at_[-1],&aalpha_[-1]);
  fgets(s,99,fp);
  for(phase=0; phase<anphase; phase++)
    {
      fscanf(fp,"%d %f", &at_[phase], &aalpha_[phase]);
      fgets(s,99,fp);
    }

  /* saving info */
  fscanf(fp,"%d", &snapshots[0]);
  for(i=0; i<maxsnaps && snapshots[i]<snapshotend; i++)
    fscanf(fp,"%d", &snapshots[i+1]);
  fgets(s,99,fp);
  nextsnapshot=0;
}


read_inputs()
{
  register int i,j;
  char s[100];
  float f01rnd();

  fp=fopen(lvectorfile,"r");
  /* read llabelfilename and lvector dimension */
  fscanf(fp,"%s", llabelfile); fgets(s,99,fp);
  fscanf(fp,"%d", &ldim); fgets(s,99,fp);

  /* read the labels */
  fp2=fopen(llabelfile,"r");
  for(i=0; i<maxvectors && fscanf(fp2,"%s", lvectors[i].label)!=EOF; i++){}
  lnvectors=i;
  fclose(fp2);

  /* read the vectors */
  for(i=0; i<lnvectors; i++)
    for(j=0; j<ldim; j++)
      fscanf(fp,"%f",&lvectors[i].comp[j]);
  fclose(fp);

  
  fp=fopen(svectorfile,"r");
  /* read slabelfilename and svector dimension */
  fscanf(fp,"%s", slabelfile); fgets(s,99,fp);
  fscanf(fp,"%d", &sdim); fgets(s,99,fp);

  /* read the labels */
  fp2=fopen(slabelfile,"r");
  for(i=0; i<maxvectors && fscanf(fp2,"%s", svectors[i].label)!=EOF; i++){}
  snvectors=i;
  fclose(fp2);

  /* read the vectors */
  for(i=0; i<snvectors; i++)
    for(j=0; j<sdim; j++)
      fscanf(fp,"%f",&svectors[i].comp[j]);
  fclose(fp);
  
  /* read the inputpairs */
  lninp=sninp=aninp=0;
  fp=fopen(inpfile,"r");
  for(i=0; i<maxinps && fscanf(fp,"%d", &inppairs[i].l)!=EOF; i++)
    {
      fscanf(fp,"%d", &inppairs[i].s);
      if(inppairs[i].l>(-1)) lninp++;
      if(inppairs[i].l>=lfirsttok && inppairs[i].l<lfirsttok+lntoks)lntokinp++;
      if(inppairs[i].s>(-1)) sninp++;
      if(inppairs[i].s>=sfirsttok && inppairs[i].s<sfirsttok+sntoks)sntokinp++;
      if(inppairs[i].l>(-1) && inppairs[i].s>(-1)) aninp++;
    }
  ninppairs=i;
  fclose(fp);
  
  for(i=0; i<ninppairs; i++)
    shuffletable[i]=i;
/*  shuffle();*/
}


init_weights()
{
  register int i,j,ii,jj;
  int randfun();
  float lsvalue, slvalue;
  iterate_weights(randfun);
  lsvalue = 1.0/sqrt((float) (snets*snets));
  slvalue = 1.0/sqrt((float) (lnets*lnets));
  for(i=0; i<lnets; i++)
    for(j=0; j<lnets; j++)
      for(ii=0; ii<snets; ii++)
	for(jj=0; jj<snets; jj++)
	  {
	    lsassoc[i][j][ii][jj] = lsvalue;
	    slassoc[ii][jj][i][j] = slvalue;
	  }
  if (snapshots[0]==(-1))
    save_current();			/* save the initial state */
}


iterate_weights(dofun)
int (*dofun)();
{
  register int i,j,k,ii,jj;

  for(i=0; i<lnets; i++)
    for(j=0; j<lnets; j++)
      for(k=0; k<ldim; k++)
	(*dofun)(&lunits[i][j].comp[k]);

  for(i=0; i<snets; i++)
    for(j=0; j<snets; j++)
      for(k=0; k<sdim; k++)
	(*dofun)(&sunits[i][j].comp[k]);

  for(i=0; i<lnets; i++)
    for(j=0; j<lnets; j++)
      for(ii=0; ii<snets; ii++)
	for(jj=0; jj<snets; jj++)
	  {
	    (*dofun)(&lsassoc[i][j][ii][jj]);
	    (*dofun)(&slassoc[ii][jj][i][j]);
	  }
}  

init_stats()
{
  register int i,j;
  ldeltasum=sdeltasum=sldeltasum=lsdeltasum=0.0;
  lnerr=snerr=lsnerr=slnerr=
    lncorr=sncorr=slncorr=lsncorr=
    lntokcorr=sntokcorr=slntokcorr=lsntokcorr=0;
  for(i=0; i<lnets; i++)
    for(j=0; j<lnets; j++) 
      {
	lunits[i][j].bestvalue = 999999999.9;
	lunits[i][j].labelcount= 0;
      }
  for(i=0; i<snets; i++)
    for(j=0; j<snets; j++) 
      {
	sunits[i][j].bestvalue = 999999999.9;
	sunits[i][j].labelcount= 0;
      }
}


/*********************** I/O etc functions *****************/ 

save_current()
{
  int writefun();
  fp=fopen(simufile,"a");
  fprintf(fp,"%d \n", t);
  iterate_weights(writefun);
  fclose(fp);
  nextsnapshot++;
}

shuffle()
{
  register int i;
  int temp1,temp2,temp3;
  for(i=0; i<ninppairs; i++)
    {
      temp1=lrand48()%ninppairs;
      temp2=lrand48()%ninppairs;
      temp3=shuffletable[temp1];
      shuffletable[temp1]=shuffletable[temp2];
      shuffletable[temp2]=temp3;
    }
}

readfun(place)
float *place;
{
  fscanf(fp,"%f", place);
} 

writefun(place)
float *place;
{
  fprintf(fp,"%f\n", *place);
} 

randfun(place)
float *place;
{
  float f01rnd();
  *place = f01rnd();
} 

/***********************  math stuff **************************/

float distance(v1, v2, ncomp)
int ncomp;
float v1[],v2[];
{
  float sum=0.0;
  register int i;
  /* unit response is equal to the euclidian distance of input and weight */
  for(i=0; i<ncomp; i++)
    sum=sum+(v1[i]-v2[i])*(v1[i]-v2[i]);
  return(sqrt(sum));
}

float alpha(t, phase, t_, alpha_)
int t, phase, t_[];
float alpha_[];
{
  /* decrease gain linearly within the phase */
  return(alpha_[phase-1] +
	 (alpha_[phase]-alpha_[phase-1])*
	 (t-t_[phase-1])/(t_[phase]-t_[phase-1])
	 );
}

nc(t, phase, t_, nc_)
int t, phase, t_[], nc_[];
{
  /* decrease neighborhood size linearly within the phase */
  return(floor( nc_[phase-1] + 0.999999 +
	       ((float) nc_[phase]-nc_[phase-1]) *
	       (t-t_[phase-1])/(t_[phase]-t_[phase-1])
	       )
	 );
}
 
float f01rnd()
{
  /* random float between [0,1] */
  return (drand48());
}
