(setq voc
  '(
    ATE    
    BROKE  
    HIT    
    MOVED  
    BALL   
    BAT    
    BOY    
    PAPERWT
    CHEESE 
    CHICKEN
    CURTAIN
    DESK   
    DOLL   
    FORK   
    GIRL   
    HATCHET
    HAMMER 
    MAN    
    WOMAN  
    PLATE  
    ROCK   
    PASTA  
    SPOON  
    CARROT 
    VASE   
    WINDOW 
    DOG    
    WOLF   
    SHEEP  
    LION   
))

(setq letters
  '(
    (ATE      . (A T E _ _ _ _))
    (BROKE    . (B R O K E _ _))
    (HIT      . (H I T _ _ _ _))
    (MOVED    . (M O V E D _ _))
    (BALL     . (B A L L _ _ _))
    (BAT      . (B A T _ _ _ _))
    (BOY      . (B O Y _ _ _ _))
    (PAPERWT  . (P A P E R W T))
    (CHEESE   . (C H E E S E _))
    (CHICKEN  . (C H I C K E N))
    (CURTAIN  . (C U R T A I N))
    (DESK     . (D E S K _ _ _))
    (DOLL     . (D O L L _ _ _))
    (FORK     . (F O R K _ _ _))
    (GIRL     . (G I R L _ _ _))
    (HATCHET  . (H A T C H E T))
    (HAMMER   . (H A M M E R _))
    (MAN      . (M A N _ _ _ _))
    (WOMAN    . (W O M A N _ _))
    (PLATE    . (P L A T E _ _))
    (ROCK     . (R O C K _ _ _))
    (PASTA    . (P A S T A _ _))
    (SPOON    . (S P O O N _ _))
    (CARROT   . (C A R R O T _))
    (VASE     . (V A S E _ _ _))
    (WINDOW   . (W I N D O W _))
    (DOG      . (D O G _ _ _ _))
    (WOLF     . (W O L F _ _ _))
    (SHEEP    . (S H E E P _ _))
    (LION     . (L I O N _ _ _))
))

(setq values
  '((_     . 5)
    (A     . 18)
    (B     . 27)
    (C     . 17)
    (D     . 24)
    (E     . 24)
    (F     . 17)
    (G     . 25)
    (H     . 23)
    (I     . 9)
    (J     . 13)
    (K     . 18)
    (L     . 13)
    (M     . 32)
    (N     . 23)
    (O     . 22)
    (P     . 21)
    (Q     . 23)
    (R     . 24)
    (S     . 19)
    (T     . 14)
    (U     . 19)
    (V     . 15)
    (W     . 27)
    (X     . 17)
    (Y     . 12)
    (Z     . 19)
))

(setq minval 5)
(setq maxval 32)
(setq step (/ 1 (- maxval minval)))

(defun explode (word)
  (cdr (assoc word letters)))

(defun convert (word)
  (mapcar 'getvalue (explode word)))

(defun getvalue (letter)
  (scale (cdr (assoc letter values))))

(defun scale (num)
  (* step (- num minval)))

(defun gener ()
  (mapcar 'convert voc))

(defun spit-out (allwords)
  (dolist (word allwords)
    (dolist (letter word)
      (format t "~&~F" letter))))
