/********************* definitions *******************************/
   
#include <stdio.h>
#include <math.h>

#ifdef hp
#include <starbase.c.h>
#endif

#define snapshotend 999999999

/* table dimensions */
#define maxnets 20              /* maximum network size is n*n units */
#define maxsnaps 50             /* maximum number of snapshots */
#define maxlphase 10            /* maximum number of lex phases */
#define maxsphase 10            /* maximum number of sem phases */
#define maxaphase 10            /* maximum number of assoc phases */
#define maxvectors 200          /* maximum number of input vectors */
#define maxinps 200             /* maximum number of inputs */
#define maxlabell 30            /* maximum length of lables */
#define maxdim 50               /* maximum dimension of input vectors */

/* constants and simulation parameters */
#define lntoks 0                /* # of lex. instance words (separate stats) */
#define sntoks 0                /* # of sem. instance words (separate stats) */
#define lfirsttok 0             /* index of first lexical instance word */
#define sfirsttok 0             /* index of first semantic instance word */
#define lownoise 0.0            /* lowest noise level tested */
#define highnoise 0.01          /* upper limit for the noise level */
#define noisestep 0.05          /* noise increment */
#define lerr 0.15               /* statistics collected within this error */
#define serr 0.15               /* statistics collected within this error */
#define maxthrough 4            /* propagate through 4 strongest units */
#define snapshotend 999999999
  
/* graphics parameters */
#define frame_color 1            /* 1 = green in color, black in bw */
#define bestvector_color 63      /* 63= white in color, black in bw */
#define bestunit_color 1       
#define assocunit_color 13
#define clear_color 0            /* 0 = black in color, white in bw */
#define llabelsize (lhght/3.0)
#define slabelsize (shght/3.0)
#define expansion 0.5

int lphase, lnphase,             /* training phase and # of phases for lex */
  sphase, snphase,               /* training phase and # of phases for sem */
  aphase, anphase,               /* training phase and # of phases for assoc */
  lnets,                         /* lex netsize */
  lt_array[maxlphase+1], *lt_,   /* lex phaseends, [-1] = initial */
  lnc_array[maxlphase+1], *lnc_, /* lex neighborhoods, [-1] = initial  */
  lbesti, lbestj, lnvectors,ldim,/* lex image indices, #ofwords, dimension */
  snets,                         /* sem netsize */
  st_array[maxsphase+1], *st_,   /* sem phaseends, [-1] = initial  */
  snc_array[maxsphase+1], *snc_, /* sem neighborhoods, [-1] = initial  */
  sbesti, sbestj, snvectors,sdim,/* sem image indices, #ofwords, dimension */
  at_array[maxaphase+1], *at_,   /* assoc phaseends */
  seed, t, startt, tend, ninppairs,/* simulation parameters */
  displaying, continuing, testing, stats,
  nextsnapshot, snapshots[maxsnaps];
int shuffletable[maxinps];      /* table of indices in this epoch */
float noise;                    /* noise level */

/* learning rates; [-1] = initial */
float lalpha_array[maxlphase+1], *lalpha_,
  salpha_array[maxsphase+1], *salpha_,
  aalpha_array[maxaphase+1], *aalpha_;

/* statistics variables */
int lnerr, snerr, lsnerr, slnerr,
  lncorr, sncorr, lsncorr, slncorr,
  lntokcorr, sntokcorr, lsntokcorr, slntokcorr, 
  lninp, sninp, aninp,             
  lntokinp, sntokinp;
float ldeltasum, sdeltasum, lsdeltasum, sldeltasum;

/* file names */
char simufile[100], inpfile[100], lvectorfile[100], llabelfile[100],
  svectorfile[100], slabelfile[100],
  cmapfile[100], sb_outdev[100], sb_outdriver[100];
FILE *fp, *fp2;

/* lexical item index and its corresponding meaning index */
struct pair {
  int l,s;
}inppairs[maxinps];

/* lexical and semantic input vectors */
struct inputvectors {
  char label[maxlabell+1];
  float comp[maxdim];
};
struct inputvectors lvectors[maxvectors], svectors[maxvectors];

/* units on the feature maps */
struct unitdata {
  int   labelcount;
  int   labels[maxvectors+1];
  float bestvalue;
  float value;
  float comp[maxdim];
};
struct unitdata lunits[maxnets][maxnets], sunits[maxnets][maxnets];

/* associative connections */
float lsassoc[maxnets][maxnets][maxnets][maxnets],
  slassoc[maxnets][maxnets][maxnets][maxnets];

/* graphics */
int fildes, cmapsize;
float colors[256][3];
float  lhght, lwdth, llow, lleft, lhigh, lright,
  shght, swdth, slow, sleft, shigh, sright;

/* random number functions */
double drand48();
void srand48();
long lrand48();
