#include "lexdefs.h"

/***************   display routines   *******************************/
 
#ifdef hp
display_init()
{
  char s[40];
  register int i;

  fildes=gopen(sb_outdev,OUTDEV,sb_outdriver,0);
/*  fildes=gopen(sb_outdev,OUTDEV,sb_outdriver,INIT);

  fp=fopen(cmapfile, "r");
  for(i=0;
      fscanf(fp,"%f%f%f",&colors[i][0],&colors[i][1],&colors[i][2])!=EOF;
      i++);
  fclose(fp);
  cmapsize=i;
  define_color_table(fildes,0,cmapsize,colors);*/

  mapping_mode(fildes,DISTORT);
  background_color_index(fildes,clear_color);
/*  clear_view_surface(fildes);*/
  perimeter_color_index(fildes,frame_color);
  interior_style(fildes, INT_HOLLOW, TRUE);

  text_alignment(fildes, TA_CENTER, TA_NORMAL_VERTICAL, 0.0, 0.0);
  text_path(fildes, PATH_RIGHT);

  lwdth=lhght=1.0/lnets;
  swdth=shght=1.0/snets;
  character_expansion_factor(fildes, expansion);
}

display_best()
{
  char s[100];
  register int i,j,k;

  if(t>=lt0)
    {
      set_p1_p2(fildes, FRACTIONAL, lleft, llow, 0.0, lright, lhigh, 0.0);
      character_height(fildes, llabelsize);
      for(i=0; i<lnets; i++)
	for(j=0; j<lnets; j++)
	  {
	    interior_style(fildes, INT_SOLID, TRUE);
	    fill_color_index(fildes,clear_color);
	    rectangle(fildes, i*lwdth, j*lhght, (i+1)*lwdth, (j+1)*lhght);
	    text_color_index(fildes, bestvector_color);
	    text2d(fildes, (i+0.5)*lwdth, (j+1)*lhght-(0.75*llabelsize),
		   lvectors[lunits[i][j].labels[0]].label, VDC_TEXT, FALSE);
	    for(k=1; k<lunits[i][j].labelcount+1; k++)
	      if (lunits[i][j].labels[k] <lnvectors)
		{
		  text_color_index(fildes, bestunit_color);
		  text2d(fildes,(i+0.5)*lwdth,
			 (j+1)*lhght-(k+1)*(0.75*llabelsize),
			 lvectors[lunits[i][j].labels[k]].label,
			 VDC_TEXT, FALSE);
		}
	      else
		{
		  text_color_index(fildes, assocunit_color);
		  text2d(fildes,(i+0.5)*lwdth,
			 (j+1)*lhght-(k+1)*(0.75*llabelsize),
			 svectors[lunits[i][j].labels[k]-lnvectors].label,
			 VDC_TEXT, FALSE);
		}
	  }
      character_height(fildes, 2*slabelsize);
      text_color_index(fildes, bestunit_color);
      sprintf(s,"%d",t);
      text2d(fildes, 0.5, 0.5, s, VDC_TEXT, FALSE);
      make_picture_current(fildes);
    }
  
  if(t>=st0)
    {
      set_p1_p2(fildes, FRACTIONAL, sleft, slow, 0.0, sright, shigh, 0.0);
      character_height(fildes, slabelsize);
      for(i=0; i<snets; i++)
	for(j=0; j<snets; j++)
	  {
	    interior_style(fildes, INT_SOLID, TRUE);
	    fill_color_index(fildes,clear_color);
	    rectangle(fildes, i*swdth, j*shght, (i+1)*swdth, (j+1)*shght);
	    text_color_index(fildes, bestvector_color);
	    text2d(fildes, (i+0.5)*swdth, (j+1)*shght-(0.75*slabelsize),
		   svectors[sunits[i][j].labels[0]].label, VDC_TEXT, FALSE);
	    for(k=1; k<sunits[i][j].labelcount+1; k++)
	      if (sunits[i][j].labels[k] <snvectors)
		{
		  text_color_index(fildes, bestunit_color);
		  text2d(fildes,(i+0.5)*swdth,
			 (j+1)*shght-(k+1)*(0.75*slabelsize),
			 svectors[sunits[i][j].labels[k]].label,
			 VDC_TEXT, FALSE);
		}
	      else
		{
		  text_color_index(fildes, assocunit_color);
		  text2d(fildes,(i+0.5)*swdth,
			 (j+1)*shght-(k+1)*(0.75*slabelsize),
			 lvectors[sunits[i][j].labels[k]-snvectors].label,
			 VDC_TEXT, FALSE);
		}
	  }
      character_height(fildes, 2*slabelsize);
      text_color_index(fildes, bestunit_color);
      sprintf(s,"%d",t);
      text2d(fildes, 0.5, 0.5, s, VDC_TEXT, FALSE);
      make_picture_current(fildes);
    }
}

display_all_assocs()
{
  float radius;
  int i,j,ii,jj;
  for(ii=0; ii<snets; ii++)
    for(jj=0; jj<snets; jj++)
      {
	display_best();
	set_p1_p2(fildes, FRACTIONAL, sleft, slow, 0.0, sright, shigh, 0.0);
	fill_color_index(fildes,frame_color);
	interior_style(fildes, INT_HOLLOW, TRUE);
	rectangle(fildes,
		  (ii+0.4)*swdth,(jj+0.4)*shght,(ii+0.6)*swdth,(jj+0.6)*shght);
	set_p1_p2(fildes, FRACTIONAL, lleft, llow, 0.0, lright, lhigh, 0.0);
	for(i=0; i<lnets; i++)
	  for(j=0; j<lnets; j++)
	    {
	      radius = slassoc[ii][jj][i][j]/snets/2.0;
	      rectangle(fildes,
			(i+0.5)*lwdth-radius, (j+0.5)*lhght-radius,
			(i+0.5)*lwdth+radius, (j+0.5)*lhght+radius);
	    }
	make_picture_current(fildes);
	while (getchar()!='\n');
      }
  for(i=0; i<lnets; i++)
    for(j=0; j<lnets; j++)
      {
	display_best();
	set_p1_p2(fildes, FRACTIONAL, lleft, llow, 0.0, lright, lhigh, 0.0);
	fill_color_index(fildes,frame_color);
	interior_style(fildes, INT_HOLLOW, TRUE);
	rectangle(fildes,
		  (i+0.4)*lwdth, (j+0.4)*lhght, (i+0.6)*lwdth, (j+0.6)*lhght);
	set_p1_p2(fildes, FRACTIONAL, sleft, slow, 0.0, sright, shigh, 0.0);
	for(ii=0; ii<snets; ii++)
	  for(jj=0; jj<snets; jj++)
	    {
	      radius = lsassoc[i][j][ii][jj]/lnets/2.0;
	      rectangle(fildes,
			(ii+0.5)*swdth-radius, (jj+0.5)*shght-radius,
			(ii+0.5)*swdth+radius, (jj+0.5)*shght+radius);
	    }
	make_picture_current(fildes);
	while (getchar()!='\n');
      }
}
      
display_selected_assocs()
{
  int k,i,j,ii,jj,x,y;
  float radius;
  char s[100];
  display_best();
  for(k=0; scanf("%s", s)!=EOF; k++)
    {
      if (s[0]=='p')
	{
	  scanf("%d %d", &x, &y);
	  display_best();
	  set_p1_p2(fildes,FRACTIONAL, lleft, llow, 0.0, lright, lhigh, 0.0);
	  fill_color_index(fildes,frame_color);
	  interior_style(fildes, INT_HOLLOW, TRUE);
	  rectangle(fildes,
		    (x+0.4)*lwdth,(y+0.4)*lhght,(x+0.6)*lwdth,(y+0.6)*lhght);
	  set_p1_p2(fildes,FRACTIONAL, sleft, slow, 0.0, sright, shigh, 0.0);
	  for(ii=0; ii<snets; ii++)
	    for(jj=0; jj<snets; jj++)
	      {
		radius = lsassoc[x][y][ii][jj]/snets/2.0;
		rectangle(fildes,
			  (ii+0.5)*swdth-radius, (jj+0.5)*shght-radius,
			  (ii+0.5)*swdth+radius, (jj+0.5)*shght+radius);
	      }
	  make_picture_current(fildes);
/*	  printf("p: %d, %d -> s\n", x, y);
	  for(jj=snets-1; jj>=0; jj--)
	    {
	      for(ii=0; ii<snets; ii++)
		printf(" %.3f", lsassoc[x][y][ii][jj]);
	      printf("\n");
	    }*/
	}
      else if (s[0]=='s')
	{
	  scanf("%d %d", &x, &y);
	  display_best();
	  set_p1_p2(fildes,FRACTIONAL, sleft, slow, 0.0, sright, shigh, 0.0);
	  fill_color_index(fildes,frame_color);
	  interior_style(fildes, INT_HOLLOW, TRUE);
	  rectangle(fildes,
		    (x+0.4)*swdth,(y+0.4)*shght,(x+0.6)*swdth,(y+0.6)*shght);
	  set_p1_p2(fildes,FRACTIONAL, lleft, llow, 0.0, lright, lhigh, 0.0);
	  for(i=0; i<lnets; i++)
	    for(j=0; j<lnets; j++)
	      {
		radius = slassoc[x][y][i][j]/lnets/2.0;
		rectangle(fildes,
			  (i+0.5)*lwdth-radius, (j+0.5)*lhght-radius,
			  (i+0.5)*lwdth+radius, (j+0.5)*lhght+radius);
	      }
	  make_picture_current(fildes);
/*	  printf("s: %d, %d -> p\n", x, y);
	  for(j=lnets-1; j>=0; j--)
	    {
	      for(i=0; i<lnets; i++)
		printf(" %.3f", slassoc[x][y][i][j]);
	      printf("\n");
	    }*/
	}
    }
}
  
#else
print_bestinputs()
{
  int i,j,more,k;
  printf("\nLexical Map\n");
  for(i=0; i<lnets; i++)
    {
      more=1;
      for(k=1; more==1; k++)
	{		    
	  more=0;
	  for(j=0; j<lnets; j++)
	    {
	      printf("%7s ",
		     (lunits[i][j].labelcount>=k)?
		     ((lunits[i][j].labels[k]<lnvectors)?
		      lvectors[lunits[i][j].labels[k]].label:
		      svectors[lunits[i][j].labels[k]-lnvectors].label):
		     ((k==1)?"_______":""));
	      if(lunits[i][j].labelcount>k) more=1;
	    }
	  printf("\n");
	}
    }
  printf("\nSemantic Map\n");
  for(i=0; i<snets; i++)
    {
      more=1;
      for(k=1; more==1; k++)
	{		    
	  more=0;
	  for(j=0; j<snets; j++)
	    {
		printf("%7s ",
		     (sunits[i][j].labelcount>=k)?
		     ((sunits[i][j].labels[k]<snvectors)?
		      svectors[sunits[i][j].labels[k]].label:
		      lvectors[sunits[i][j].labels[k]-snvectors].label):
		     ((k==1)?"_______":""));
	      if(sunits[i][j].labelcount>k) more=1;
	    }
	  printf("\n");
	}
    }
}		    
		      

#endif

