#include "sofmdefs.h"
/***************   display routines   *******************************/
 
#ifdef hp
display_init()
{
  char s[40];
  register int i;

  fildes=gopen(sb_outdev,OUTDEV,sb_outdriver,0);
/*  fildes=gopen(sb_outdev,OUTDEV,sb_outdriver,INIT);

  fp=fopen(cmapfile, "r");
  for(i=0; fscanf(fp,"%f%f%f",&colors[i][0],&colors[i][1],&colors[i][2])!=EOF; i++);
  fclose(fp);
  cmapsize=i;
  define_color_table(fildes,0,cmapsize,colors);*/

  mapping_mode(fildes,DISTORT);
  background_color_index(fildes,clear_color);
/*  clear_view_surface(fildes);*/
  perimeter_color_index(fildes,frame_color);
  interior_style(fildes, INT_HOLLOW, TRUE);

  text_alignment(fildes, TA_CENTER, TA_NORMAL_VERTICAL, 0.0, 0.0);
  text_path(fildes, PATH_RIGHT);

  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0, right, high, 0.0);
  wdth=1.0/nx;
  hght=1.0/ny;
  character_height(fildes, labelsize);
  character_expansion_factor(fildes, expansion);
  rectangle(fildes, 0.0, 0.0, 1.0, 1.0);
  make_picture_current(fildes);
}

display_best()
{
  char s[100];
  register int i,j,k;
  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++)
      {
	interior_style(fildes, INT_SOLID, TRUE);
	fill_color_index(fildes,clear_color);
	rectangle(fildes, i*wdth, j*hght, (i+1)*wdth, (j+1)*hght);
	text_color_index(fildes, bestvector_color);
	for(k=0; k<units[i][j].labelcount+1; k++)
	  {
	    text2d(fildes, (i+0.5)*wdth, (j+1)*hght-(k+1)*(0.75*labelsize),
		   vectors[units[i][j].labels[k]].label, VDC_TEXT, FALSE);
	    text_color_index(fildes, bestunit_color);
	  }
      }
  sprintf(s,"%d",t);
  text2d(fildes, 0.5, 0.5, s, VDC_TEXT, FALSE);
  make_picture_current(fildes);
}
#else
/* alphanumeric output routines */
display_best()
{
  register int i,j,k;
  int more;
  printf("\nIteration %d\n",t);
  for(i=0; i<nx; i++)
    {
      more=1;
      for(k=1; more==1; k++)
	{		    
	  more=0;
	  for(j=0; j<ny; j++)
	    {
	      printf("%7s ",
		     (units[i][j].labelcount >= k &&
		      units[i][j].labels[k]<nvectors)?
		     vectors[units[i][j].labels[k]].label:
		     ((k==1)?"_______":""));
	      if(units[i][j].labelcount>k) more=1;
	    }
	  printf("\n");
	}
    }
}
#endif
