/************************* definitions ********************************/

#include <stdio.h>
#include <math.h>

#ifdef hp
#include <starbase.c.h>
#endif

#define snapshotend 999999999
#define maxdistance 1.414213562

#define maxnx 100            /* maximum network size is nx*ny units */
#define maxny 100
#define maxsnaps 100         /* maximum number of snapshots */
#define maxphase 100
#define maxdim 2             /* maximum dimension of input vectors */

#define iboxs 0.001            /* size of input dots */
#define ciboxs 0.001            /* size of current input dot */
#define vcenter low+(high-low)/2.0
#define hcenter left+(right-left)/2.0
#define frame_color 0          /* 0 = red in color, black in bw */
#define net_color 1            /* 1 = green in color, black in bw */
#define data_color 1           /* 1 = green in color, black in bw */
#define clear_color cmapsize-1 /*   = black in color, white in bw */
#define old_input_color 2+2*cmapsize/3  /* = is red in color, grey in bw */
#define current_input_color 2  /* 2 = white in color, black in bw */

/* in t_, nc_, and alpha_: [-1] = initial value */
int nx, ny, t, t_array[maxphase+1], *t_, tend, seed,
  nc_array[maxphase+1], *nc_,
  fildes, besti, bestj, nextsnapshot, snapshots[maxsnaps],
  displaying, continuing, cmapsize, startt, phase, dim;
float alpha_array[maxphase+1], *alpha_, low, left, high, right; 
float colors[256][3];
char simufile[100], cmapfile[100], sb_outdev[100], sb_outdriver[100];
FILE *fp,*fp2;
  
struct inputvectors {
  float comp[maxdim];
} vectors,oldvectors;

struct unitdata {
  float value;
  float comp[maxdim];
} units[maxnx][maxny];

/* random number functions */
double drand48();
void srand48();
