#include "sofmdefs.h"

/***************   display routines   *******************************/
 
#ifdef hp
display_init(argc,argv)
int argc; char *argv[];
{
  char s[40];
  register int i;

  fildes=gopen(sb_outdev,OUTDEV,sb_outdriver,INIT);

  fp=fopen(cmapfile, "r");
  for(i=0; fscanf(fp,"%f%f%f",&colors[i][0],&colors[i][1],&colors[i][2])!=EOF; i++);
  fclose(fp);
  cmapsize=i;
  define_color_table(fildes,0,cmapsize,colors);

  background_color_index(fildes,clear_color);
  clear_view_surface(fildes);
  perimeter_color_index(fildes,frame_color);
  line_color_index(fildes, net_color);

  character_height(fildes, 0.07);
  text_color_index(fildes, data_color);
  text_alignment(fildes, TA_NORMAL_HORIZONTAL, TA_NORMAL_VERTICAL, 0.0, 0.0);
  text_path(fildes, PATH_RIGHT);

  /* input quadrant */
  viewport_justification(fildes,1.0,0.0);
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0, hcenter, vcenter, 0.0);
  interior_style(fildes, INT_HOLLOW, TRUE);
  rectangle(fildes, 0.0, 0.0, 1.0, 1.0);

  /* text quadrant */
  viewport_justification(fildes,1.0,0.0);
  set_p1_p2(fildes, FRACTIONAL, left, vcenter, 0.0, hcenter, high, 0.0);
  rectangle(fildes, 0.0, 0.0, 1.0, 1.0);
  text2d(fildes, 0.15, 0.87, "Phase:",VDC_TEXT, FALSE);
  text2d(fildes, 0.15, 0.81, "Iteration t:",VDC_TEXT, FALSE);
  text2d(fildes, 0.15, 0.75, "Gain a:",VDC_TEXT, FALSE);
  text2d(fildes, 0.15, 0.69, "Radius Nc:",VDC_TEXT, FALSE);
  sprintf(s,"%s%d","Seed:     ",seed);
  text2d(fildes, 0.15, 0.50, s, VDC_TEXT, FALSE);
  sprintf(s,"%s%dx%d","Netsize:  ",nx, ny);
  text2d(fildes, 0.15, 0.44, s, VDC_TEXT, FALSE);
}

display_current(phase,t,nc,alpha)
int phase,t,nc; float alpha;
{
  char s[9];
  /* text quadrant */
  viewport_justification(fildes,1.0,0.0);
  set_p1_p2(fildes, FRACTIONAL, left, vcenter, 0.0, hcenter, high, 0.0);
  interior_style(fildes, INT_SOLID, FALSE);
  fill_color_index(fildes, clear_color);
  rectangle(fildes, 0.65, 0.69, 0.99, 0.93);
  sprintf(s,"%d",phase);
  text2d(fildes, 0.65, 0.87, s, VDC_TEXT, FALSE);
  sprintf(s,"%d",t);
  text2d(fildes, 0.65, 0.81, s, VDC_TEXT, FALSE);
  sprintf(s,"%f",alpha);
  text2d(fildes, 0.65, 0.75, s, VDC_TEXT, FALSE);
  sprintf(s,"%d",nc);
  text2d(fildes, 0.65, 0.69, s, VDC_TEXT, FALSE);
  make_picture_current(fildes);
}

display_weights()
{
  register int i,j;
  viewport_justification(fildes,0.0,0.0);
  set_p1_p2(fildes, FRACTIONAL, hcenter, vcenter, 0.0, right, high, 0.0);
  interior_style(fildes, INT_SOLID, TRUE);
  fill_color_index(fildes, clear_color);
  rectangle(fildes, 0.0, 0.0, 1.0, 1.0);  /* clear the quadrant */
  /* draw the horizontal lines */
  for(i=0; i<nx; i++)
    {
      move2d(fildes,units[i][0].comp[0],units[i][0].comp[1]);
      for(j=1; j<ny; j++)
	draw2d(fildes,units[i][j].comp[0],units[i][j].comp[1]);
    }
  /* draw the vertical lines */
  for(j=0; j<ny; j++)
    {
      move2d(fildes,units[0][j].comp[0],units[0][j].comp[1]);
      for(i=1; i<nx; i++)
	draw2d(fildes,units[i][j].comp[0],units[i][j].comp[1]);
    }
  make_picture_current(fildes);
}

display_input()
{
  viewport_justification(fildes,1.0,0.0);
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0, hcenter, vcenter, 0.0);
  interior_style(fildes, INT_SOLID, FALSE);
  /* clear the big current input dot */
  fill_color_index(fildes, clear_color);
  rectangle(fildes, oldvectors.comp[0]-ciboxs, oldvectors.comp[1]-ciboxs,
	    oldvectors.comp[0]+ciboxs, oldvectors.comp[1]+ciboxs);
  /* and replace it with small old input dot */
  fill_color_index(fildes, old_input_color);
  rectangle(fildes, oldvectors.comp[0]-iboxs, oldvectors.comp[1]-iboxs,
	    oldvectors.comp[0]+iboxs, oldvectors.comp[1]+iboxs);
  /* draw the new current input dot */
  fill_color_index(fildes, current_input_color);
  rectangle(fildes, vectors.comp[0]-ciboxs, vectors.comp[1]-ciboxs,
	    vectors.comp[0]+ciboxs, vectors.comp[1]+ciboxs);
  make_picture_current(fildes);
}

display_responses()
{
  register int i,j;
  int ldim;
  viewport_justification(fildes,0.0,0.0);
  set_p1_p2(fildes, FRACTIONAL, hcenter, low, 0.0, right, vcenter, 0.0);
  ldim=(nx>ny)?nx:ny;
  /* go through all the nodes and draw boxes according to activity */
  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++)
      {
	fill_color_index(fildes,translate_to_color(units[i][j].value));
	rectangle(fildes,(0.0+i)/ldim,(0.0+j)/ldim,(i+1.0)/ldim,(j+1.0)/ldim);
      }
  make_picture_current(fildes);
}

translate_to_color(num)
float num;
{
  /* map the response of the unit to corresponding color */
  return(2+(cmapsize-3)*num/maxdistance);
}
#endif
