/* Generate inputs for fgrep
     
     Risto Miikkulainen 8/6/1989 
     revision 8/20/89

*/
  
#include <stdio.h>
#include <math.h>
  
#define maxwords 750           /* maximum size of vocabulary */
#define maxwordl 30
#define maxclone 36            /* max number of synonyms for each word */
  
#define maxate (1*maxclone)
#define maxbroke (1*maxclone)
#define maxhit (1*maxclone)
#define maxmoved (1*maxclone)
#define maxthing (15*maxclone)
#define maxobject (11*maxclone)
#define maxhitter (4*maxclone)
#define maxbreaker (3*maxclone)
#define maxpossession (5*maxclone)
#define maxanimal (5*maxclone)
#define maxprey (2*maxclone)
#define maxfood (2*maxclone)
#define maxfragile (2*maxclone)
#define maxhuman (1*maxclone)
#define maxutensil (1*maxclone)
#define maxpredator (1*maxclone)

char blank[maxwordl]=" ";
char words[maxwords][maxwordl];
char datafile[100], wordfile[100];
FILE *fp;

int ate[maxate], broke[maxbroke], hit[maxhit], moved[maxmoved],
  thing[maxthing], object[maxobject], hitter[maxhitter],
  breaker[maxbreaker], possession[maxpossession], animal[maxanimal],
  prey[maxprey], food[maxfood], fragile[maxfragile], human[maxhuman],
  utensil[maxutensil], predator[maxpredator];

int nate, nbroke, nhit, nmoved, nthing, nobject, nhitter, nbreaker,
  npossession, nanimal, nprey, nfood, nfragile, nhuman, nutensil, npredator;
      
int verb, subj, obj, with, tverb, agent, patient, instr, mod;


main(argc,argv)
int argc; char *argv[];
{
  sprintf(datafile, "%s", argv[1]);
  read_data();
  read_words();
  printf("4 5 				;;; ninpas, noutas\n");
  generate_sentences();
  exit(0);
}


generate_sentences()
{
  register int h, i, j, k;
  int tend,iseed;
  
  /* generator 1. */
  all_blanks();
  for(h=0; h<nate; h++)
    {
      verb=ate[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  print_sentence(1);
	}
    }
  
  /* generator 2. */
  all_blanks();
  for(h=0; h<nate; h++)
    {
      verb=ate[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nfood; j++)
	    {
	      obj=food[j];
	      patient=obj;
	      print_sentence(2);
	    }
	}
    }
  
  /* generator 3. */
  all_blanks();
  for(h=0; h<nate; h++)
    {
      verb=ate[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nfood; j++)
	    {
	      obj=food[j];
	      patient=obj;
	      for(k=0; k<nfood; k++)
		{
		  with=food[k];
		  mod=with;
		  print_sentence(3);
		}
	    }
	}
    }
  
  /* generator 4. */
  all_blanks();
  for(h=0; h<nate; h++)
    {
      verb=ate[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nfood; j++)
	    {
	      obj=food[j];
	      patient=obj;
	      for(k=0; k<nutensil; k++)
		{
		  with=utensil[k];
		  instr=with;
		  print_sentence(4);
		}
	    }
	}
    }
  
  /* generator 5. */
  all_blanks();
  for(h=0; h<nate; h++)
    {
      verb=ate[h];
      for(i=0; i<nanimal; i++)
	{
	  subj=animal[i];
	  agent=subj;
	  print_sentence(5);
	}
    }
  
  /* generator 6. */
  all_blanks();
  for(h=0; h<nate; h++)
    {
      verb=ate[h];
      for(i=0; i<npredator; i++)
	{
	  subj=predator[i];
	  agent=subj;
	  for(j=0; j<nprey; j++)
	    {
	      obj=prey[j];
	      patient=obj;
	      print_sentence(6);
	    }
	}
    }
  
  /* generator 7. */
  all_blanks();
  for(h=0; h<nbroke; h++)
    {
      verb=broke[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nfragile; j++)
	    {
	      obj=fragile[j];
	      patient=obj;
	      print_sentence(7);
	    }
	}
    }
  
  /* generator 8. */
  all_blanks();
  for(h=0; h<nbroke; h++)
    {
      verb=broke[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nfragile; j++)
	    {
	      obj=fragile[j];
	      patient=obj;
	      for(k=0; k<nbreaker; k++)
		{
		  with=breaker[k];
		  instr=with;
		  print_sentence(8);
		}
	    }
	}
    }
  
  /* generator 9. */
  all_blanks();
  for(h=0; h<nbroke; h++)
    {
      verb=broke[h];
      for(i=0; i<nbreaker; i++)
	{
	  subj=breaker[i];
	  agent=(-1);
	  instr=subj;
	  for(j=0; j<nfragile; j++)
	    {
	      obj=fragile[j];
	      patient=obj;
	      print_sentence(9);
	    }
	}
    }
  
  /* generator 10. */
  all_blanks();
  for(h=0; h<nbroke; h++)
    {
      verb=broke[h];
      for(i=0; i<nanimal; i++)
	{
	  subj=animal[i];
	  agent=subj;
	  for(j=0; j<nfragile; j++)
	    {
	      obj=fragile[j];
	      patient=obj;
	      print_sentence(10);
	    }
	}
    }
  
  /* generator 11. */
  all_blanks();
  for(h=0; h<nbroke; h++)
    {
      verb=broke[h];
      for(i=0; i<nfragile; i++)
	{
	  subj=fragile[i];
	  agent=(-1);
	  patient=subj;
	  print_sentence(11);
	}
    }
  
  /* generator 12. */
  all_blanks();
  for(h=0; h<nhit; h++)
    {
      verb=hit[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nthing; j++)
	    {
	      obj=thing[j];
	      patient=obj;
	      print_sentence(12);
	    }
	}
    }
  
  /* generator 13. */
  all_blanks();
  for(h=0; h<nhit; h++)
    {
      verb=hit[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nhuman; j++)
	    {
	      obj=human[j];
	      patient=obj;
	      for(k=0; k<npossession; k++)
		{
		  with=possession[k];
		  mod=with;
		  print_sentence(13);
		}
	    }
	}
    }
  
  /* generator 14. */
  all_blanks();
  for(h=0; h<nhit; h++)
    {
      verb=hit[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nthing; j++)
	    {
	      obj=thing[j];
	      patient=obj;
	      for(k=0; k<nhitter; k++)
		{
		  with=hitter[k];
		  instr=with;
		  print_sentence(14);
		}
	    }
	}
    }
  
  /* generator 15. */
  all_blanks();
  for(h=0; h<nhit; h++)
    {
      verb=hit[h];
      for(i=0; i<nhitter; i++)
	{
	  subj=hitter[i];
	  agent=(-1);
	  instr=subj;
	  for(j=0; j<nthing; j++)
	    {
	      obj=thing[j];
	      patient=obj;
	      print_sentence(15);
	    }
	}
    }
  
  /* generator 16. */
  all_blanks();
  for(h=0; h<nmoved; h++)
    {
      verb=moved[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  patient=subj;
	  print_sentence(16);
	}
    }
  
  /* generator 17. */
  all_blanks();
  for(h=0; h<nmoved; h++)
    {
      verb=moved[h];
      for(i=0; i<nhuman; i++)
	{
	  subj=human[i];
	  agent=subj;
	  for(j=0; j<nobject; j++)
	    {
	      obj=object[j];
	      patient=obj;
	      print_sentence(17);
	    }
	}
    }
  
  /* generator 18. */
  all_blanks();
  for(h=0; h<nmoved; h++)
    {
      verb=moved[h];
      for(i=0; i<nanimal; i++)
	{
	  subj=animal[i];
	  agent=subj;
	  patient=subj;
	  print_sentence(18);
	}
    }
  
  /* generator 19. */
  all_blanks();
  for(h=0; h<nmoved; h++)
    {
      verb=moved[h];
      for(i=0; i<nobject; i++)
	{
	  subj=object[i];
	  agent=(-1);
	  patient=subj;
	  print_sentence(19);
	}
    }
}


read_data()
{
  char s[100];
  register int i;

  fp=fopen(datafile,"r");

  /* wordfilename */
  fscanf(fp,"%s", wordfile); fgets(s,99,fp);

  /* category data */
  read_items(fp, &nate, ate);
  read_items(fp, &nbroke, broke);
  read_items(fp, &nhit, hit);
  read_items(fp, &nmoved, moved);
  read_items(fp, &nthing, thing);
  read_items(fp, &nobject, object);
  read_items(fp, &nhitter, hitter);
  read_items(fp, &nbreaker, breaker);
  read_items(fp, &npossession, possession);
  read_items(fp, &nanimal, animal);
  read_items(fp, &nprey, prey);
  read_items(fp, &nfood, food);
  read_items(fp, &nfragile, fragile);
  read_items(fp, &nhuman, human);
  read_items(fp, &nutensil, utensil);
  read_items(fp, &npredator, predator);

  fclose(fp);
}


read_items(fp, nitems, items)
int *nitems, items[];
FILE *fp;
{
  register int i;
  char s[100];
  fscanf(fp,"%d", nitems); fgets(s,99,fp);
  for(i=0; i<*nitems; i++)
    fscanf(fp,"%d", &items[i]); fgets(s,99,fp);
}


read_words()
{
  register int i;
  fp=fopen(wordfile,"r");
  for(i=0; i<maxwords && fscanf(fp, "%s", words[i])!=EOF; i++);
  fclose(fp);
}


print_sentence(genno)
int genno;
{
  printf("%d %d %d %d %d %d %d %d %d  (%d.) %s %s %s %s\n",
	 subj,verb,obj,with,agent,verb,patient,instr,mod, genno,
	 words[subj], words[verb], words[obj], words[with]);
}  


all_blanks()
{
  /* the verb and the subject are always specified */
  obj=(-1); with=(-1);
  agent=(-1); patient=(-1); instr=(-1); mod=(-1);
}


