#include "net3.h"



SetPtr FindSet (char *setname)
 {
  int i;
  SetPtr set;
  char setname2[20];
  for (i=0; i<currentset; i++)
    {
    sprintf (setname2, "%s", SetArray[i]->Name);
    if (!(strcmp (setname, setname2)))
	{
    	set=SetArray[i];
	return set;
        }
    }
  return NULL;
  }

void SetMessage (char *s)
 {
  char Mess [30];
  sprintf (Mess, "%s", s);
  if (MessageWind && (strlen (Mess) > 0))
      Messages->AddString (Mess);
 }


			/**********  Windows stuff **********/

class TCS : public TApplication
{
 public:
  TCS (LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};


                        


/*********     Main window ********/

_CLASSDEF(TcsWindow)
class TcsWindow : public TWindow
{
public:
  TcsWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
    Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
    Attr.H=49;
    Attr.W=689;    
    new TButton (this, ID_CYCLESBUTTON, 	"Cycles", 	-1,  -1, 60,  25, TRUE);
    new TButton (this, ID_RUNBUTTON, 		"Run", 		57,  -1, 60,  25, TRUE);
    new TButton (this, ID_SETSBUTTON, 		"Sets", 	115, -1, 60,  25, TRUE);
    new TButton (this, ID_FILESBUTTON, 		"Files", 	173, -1, 60,  25, TRUE);
    new TButton (this, ID_PLOTSBUTTON, 		"Plots", 	231, -1, 60,  25, TRUE);
    new TButton (this, ID_COMMANDSBUTTON, 	"Commands", 	289, -1, 100, 25, TRUE);
    new TButton (this, ID_PARAMETERSBUTTON,	"Parameters",	387, -1, 100, 25, TRUE);
    new TButton (this, ID_MESSAGESBUTTON, 	"Messages", 	485, -1, 100, 25, TRUE);
    new TButton (this, ID_SPECIALBUTTON, 	"Special", 	583, -1, 100, 25, TRUE);
    };
  ~TcsWindow();
  virtual void HandleCyclesButton(RTMessage Msg) =
	[ID_FIRST + ID_CYCLESBUTTON];
  virtual void HandleRunButton(RTMessage Msg)
    = [ID_FIRST + ID_RUNBUTTON];
  virtual void HandleSetsButton(RTMessage Msg)
    = [ID_FIRST + ID_SETSBUTTON];
  virtual void HandleParametersButton(RTMessage Msg)
    = [ID_FIRST + ID_PARAMETERSBUTTON];
  virtual void HandleMessagesButton(RTMessage Msg)
    = [ID_FIRST + ID_MESSAGESBUTTON];
  virtual void HandleCommandsButton(RTMessage Msg)
    = [ID_FIRST + ID_COMMANDSBUTTON];
  virtual void HandleFilesButton(RTMessage Msg)
    = [ID_FIRST + ID_FILESBUTTON];      
  virtual void HandlePlotsButton(RTMessage Msg)
    = [ID_FIRST + ID_PLOTSBUTTON];
  virtual void HandleSpecialButton(RTMessage Msg)
    = [ID_FIRST + ID_SPECIALBUTTON];

};


/*********     Cycles window ********/

_CLASSDEF(CyclesWindow)
class CyclesWindow : public TWindow
{
public:
  CyclesWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
	Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
	Attr.W=200;
	Attr.H=105;
	new TStatic(this, -1, "# Cycles:", 	5, 	5, 	70, 24, 0);
	new TStatic(this, -1, "# All Cycles:",  5, 	30, 	80, 24, 0);
	AStaticCycles = new TStatic (this, CYC_ID, 	"0", 	95, 	5, 	80, 24, 10);
	AStaticAllCycles = new TStatic (this, ALLCYC_ID, "0", 	95, 	30, 	80, 24, 10);
	new TButton (this, ID_RESETCYCLESBUTTON,     "Reset",  5, 	55, 	50, 25, TRUE);
    };
  virtual void ResetCycles() =
	[ID_FIRST + ID_RESETCYCLESBUTTON];
};


/*********     Status window    ********/

_CLASSDEF(StatusWindow)
class StatusWindow : public TWindow
{
public:
  StatusWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
	Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
	Attr.W=200;
	Attr.H=100;
	new TStatic(this, -1, "# Links:",  8, 	5, 	70, 24, 0);
	new TStatic(this, -1, "# Units:",  8, 	30, 	80, 24, 0);
	new TStatic(this, -1, "# Bytes:",  8, 	55, 	80, 24, 0);
	AStaticNrLinks = new TStatic(this, NRLINKS_ID, "0", 	75, 	5, 	80, 24, 10);
	AStaticNrUnits = new TStatic(this, NRUNITS_ID, "0",     75, 	30, 	80, 24, 10);
	AStaticNrBytes = new TStatic(this, NRBYTES_ID, "0", 	75, 	55, 	80, 24, 10);
    };
};


/*********     Message window ********/

_CLASSDEF(MessageWindow)
class MessageWindow : public TWindow
{
public:
  MessageWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {

	Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
	Attr.W=300;
	Attr.H=200;
	Messages=new TListBox (this, ID_MESSAGESBOX, 7, 7, 280, 150);
        Messages->Attr.Style &= ~LBS_SORT;
    };
  ~MessageWindow();
  virtual void SetupWindow();
};


/********    Run window   ***********/

_CLASSDEF(RunWindow)
class RunWindow : public TWindow
{
public:
  RunWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     Attr.W=180;
     Attr.H=90;
     new TStatic(this, -1, 		     "# Cycles:", 	5, 	8, 	70, 24, 10);
     EditRun = new TEdit (this, ID_EDITRUN,  "1",  		80,	5,	90, 24, 15, FALSE);
     new TButton (this, ID_RUNRUNBUTTON,     "Run", 		5, 	38, 	50, 25, TRUE);
     new TButton (this, ID_RUNRUNBUTTONC,    "Run one", 	57, 	38, 	80, 25, TRUE);
    };
  virtual void DoRun(RTMessage Msg) =
	[ID_FIRST + ID_RUNRUNBUTTON];
  virtual void DoRunOne(RTMessage Msg) =
	[ID_FIRST + ID_RUNRUNBUTTONC];
};


/******** Parameters window ***********/

_CLASSDEF(ParametersWindow)
class ParametersWindow : public TWindow
{
public:
  ParametersWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     ParameterChangeButton=new TButton (this, ID_CHANGEBUTTON,     "Update", 	5, 	5, 	80, 25, TRUE);
      };

  virtual void SetupWindow();
  virtual void DoChange(RTMessage Msg) =
	[ID_FIRST + ID_CHANGEBUTTON];   
};


/******** Sets window ***********/

_CLASSDEF(SetsWindow)
class SetsWindow : public TWindow
{
public:
  SetsWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.W=170;
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     SetsListBox=new TListBox (this, ID_SETSLISTBOX, 7, 7, 155, 50);
     SetsListBox->Attr.Style &= ~LBS_SORT;
      };
  virtual void SetupWindow();
  virtual void OpenSetWindow (RTMessage Msg) =
	[ID_FIRST + ID_SETSLISTBOX];
};


/******** Set control window ***********/

_CLASSDEF(SetControlWindow)
class SetControlWindow : public TWindow
{
public:
  SetControlWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.W=235;
     Attr.H=155;
     int par_y=5;
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     new TStatic(this, -1, "Set:", 	  5, 	par_y, 	30, 24, 10);
     SetNameEdit=new TEdit (this, -1,  "",  40,	par_y,     80, 24, 20, FALSE);
     SetNameEdit->Attr.Style &= ~WS_BORDER;
     par_y += 20;
     new TStatic(this, -1, "Features:",   5, 	par_y, 	70, 24, 10);
     par_y += 20;
     ComboSetFeatureNames = new TComboBox (this, ID_COMBOSETFEATURENAMES,
						5,	par_y,	90, 115, CBS_DROPDOWNLIST, 40);
     new TButton
	 (this, ID_SETFILEBINDBUTTON, "File",   100, 	par_y,     50, 25, TRUE);
     par_y += 28;
     new TButton
	 (this, ID_PATTERNTOFILEBUTTON, "Pattern to file",   5, 	par_y,     100, 25, TRUE);
//     PatternToFileEdit=new TEdit (this, -1,  "",  122,	par_y,     100, 24, 40, FALSE);
     par_y += 28;
     new TButton
	 (this, ID_PATTERNFROMFILEBUTTON, "Pattern from file",   5, 	par_y,     120, 25, TRUE);
//     PatternFromFileEdit=new TEdit (this, -1,  "",  122,	par_y,     100, 24, 40, FALSE);
     par_y += 28;
//     new TButton
//	 (this, ID_SCFILESCLOSEBUTTON, "Close",   5, 	par_y,     60, 25, TRUE);
     ComboSetFeatureNames->Attr.Style &= ~CBS_SORT;
      };
  ~SetControlWindow();
  virtual void SetupWindow();
  virtual void BindFeatureToFile () =
	[ID_FIRST + ID_SETFILEBINDBUTTON];
  virtual void PrintPatternToFile () =
	[ID_FIRST + ID_PATTERNTOFILEBUTTON];
  virtual void ReadPatternFromFile () =
	[ID_FIRST + ID_PATTERNFROMFILEBUTTON];
//  virtual void CloseFile(RTMessage Msg) =
//	[ID_FIRST + ID_SCFILESCLOSEBUTTON];
};


/******** Unit windows ***********/

_CLASSDEF(UnitWindow)
class UnitWindow : public TWindow
{
public:
  UnitWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.W=230;
     Attr.H=207;
     int par_y=5;
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     new TStatic(this, -1, "Set/index:", 	  5, 	par_y, 	70, 24, 10);
     NameEdit=new TEdit (this, -1,  "",  80,	par_y,     145, 24, 35, FALSE);
     NameEdit->Attr.Style &= ~WS_BORDER;
     par_y += 20;
     TStaticName=new TStatic(this, -1, "Name:",  5, 	par_y, 	220, 24, 10);
     par_y += 20;
     new TStatic(this, -1, "Features:",   5, 	par_y, 	70, 24, 10);
     new TStatic(this, -1, "Value:", 	  110,  par_y,   70, 24, 10);
     par_y += 20;
     ComboFeatureNames = new TComboBox (this, ID_COMBOFEATURENAMES,
						5,	par_y,	90, 115, CBS_DROPDOWNLIST, 40);
     EditFeatureValues=new TEdit (this, -1,  "0",  110,	par_y,     90, 24, 15, FALSE);
     par_y += 28;
     new TButton
	 (this, ID_FILEBINDBUTTON, "File",   90, par_y,     50, 25, TRUE);
     new TButton
	 (this, ID_PLOTBINDBUTTONX, "X",   145, par_y,     20, 25, TRUE);
     new TButton
	 (this, ID_PLOTBINDBUTTONY, "Y",   167, par_y,     20, 25, TRUE);
     new TButton
	 (this, ID_PLOTBINDBUTTONZ, "Z",   189, par_y,     20, 25, TRUE);
     new TButton
	 (this, ID_UNITCHANGEBUTTON, "Update", 		5, 	par_y,  	80, 25, TRUE);
     par_y += 36;
     new TButton
	 (this, ID_LINKSTOSETBUTTON, "Links to set", 	5, 	par_y,  	100, 25, TRUE);
     ComboLinksToSet = new TComboBox (this, ID_COMBOLINKSTOSET,
					110,	par_y,	110, 72, CBS_DROPDOWNLIST, 40);
     par_y += 26;
     new TButton
	 (this, ID_LINKSFROMSETBUTTON, "Links from set",5, 	par_y,  	100, 25, TRUE);
     ComboLinksFromSet = new TComboBox (this, ID_COMBOLINKSFROMSET,
					110,	par_y,	110, 72, CBS_DROPDOWNLIST, 40);
     ComboFeatureNames->Attr.Style &= ~CBS_SORT;
     ComboLinksToSet->Attr.Style &= ~CBS_SORT;
     ComboLinksFromSet->Attr.Style &= ~CBS_SORT;
      };
  ~UnitWindow();
  virtual void SetupWindow();
  virtual void OpenLinksWindow(int toSet, HWND HWindow);
  virtual void DoChangeUnit (RTMessage Msg) =
	[ID_FIRST + ID_UNITCHANGEBUTTON];
  virtual void ChangeFeatureName (RTMessage Msg) =
	[ID_FIRST + ID_COMBOFEATURENAMES];
  virtual void OpenLinksToSetWindow (RTMessage Msg) =
	[ID_FIRST + ID_LINKSTOSETBUTTON];
  virtual void OpenLinksFromSetWindow (RTMessage Msg) =
	[ID_FIRST + ID_LINKSFROMSETBUTTON];
  virtual void BindFeatureToFile () =
	[ID_FIRST + ID_FILEBINDBUTTON];
  virtual void BindFeatureToPlotX (RTMessage Msg) =
	[ID_FIRST + ID_PLOTBINDBUTTONX];
  virtual void BindFeatureToPlotY (RTMessage Msg) =
	[ID_FIRST + ID_PLOTBINDBUTTONY];
  virtual void BindFeatureToPlotZ (RTMessage Msg) =
	[ID_FIRST + ID_PLOTBINDBUTTONZ];
};


_CLASSDEF(UnitWindow2)
class UnitWindow2 : public TWindow
{
public:
  UnitWindow2(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.W=140;
     Attr.H=120;
     int par_y=5;
     Attr.Style |= WS_POPUP | WS_BORDER;
     new TStatic(this, -1, "Output:", 	  	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Netinp:",     	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Free1:", 	  	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Free2:", 	  	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Free3:", 	  	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Name:", 	  	  5, 	par_y, 100, 24, 10);
     par_y +=15;
     new TStatic(this, -1, "Index:", 	  	  5, 	par_y, 100, 30, 10);
     par_y = 5;
     OutputTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
     par_y += 15;
     NetinputTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
     par_y += 15;
     Free1TStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
     par_y += 15;
     Free2TStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
     par_y += 15;
     Free3TStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
     par_y += 15;
     NameTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
     par_y += 15;
     IndexTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 15, 10);
      };
  virtual void SetupWindow();
};

                 
/******** Link windows ***********/

_CLASSDEF(LinkWindow)
class LinkWindow : public TWindow
{
 public:
  LinkWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.W=220;
     Attr.H=145;
     int par_y=5;
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     new TStatic(this, -1, "From:", 	  5, 	par_y, 	60, 24, 10);
     FromEdit=new TEdit (this, -1,  "",  70,	par_y,     145, 24, 35, FALSE);
     FromEdit->Attr.Style &= ~WS_BORDER;
     par_y += 20;
     new TStatic(this, -1, "To:",  5, 	par_y, 	60, 24, 10);
     ToEdit=new TEdit (this, -1,  "",  70,	par_y,     145, 24, 35, FALSE);
     ToEdit->Attr.Style &= ~WS_BORDER;
     par_y += 20;
     new TStatic(this, -1, "Features:",   5, 	par_y, 	70, 24, 10);
     new TStatic(this, -1, "Value:", 	  110,  par_y,  70, 24, 10);
     par_y += 20;
     ComboLinkFeatureNames = new TComboBox (this, ID_COMBOLINKFEATURENAMES,
						5,	par_y,	90, 90, CBS_DROPDOWNLIST, 40);
     EditLinkFeatureValues=new TEdit (this, -1,  "0",  110,	par_y,     90, 24, 15, FALSE);
     par_y += 28;
     new TButton
	 (this, ID_LINKFILEBINDBUTTON, "File",   90, par_y,     50, 25, TRUE);
     new TButton
	 (this, ID_LINKPLOTBINDBUTTONX, "X",   145, par_y,     20, 25, TRUE);
     new TButton
	 (this, ID_LINKPLOTBINDBUTTONY, "Y",   167, par_y,     20, 25, TRUE);
     new TButton
	 (this, ID_LINKPLOTBINDBUTTONZ, "Z",   189, par_y,     20, 25, TRUE);
     new TButton
	 (this, ID_LINKCHANGEBUTTON, "Update", 		5, 	par_y,  	80, 25, TRUE);
     ComboLinkFeatureNames->Attr.Style &= ~CBS_SORT;
      };
  ~LinkWindow();
  virtual void SetupWindow();
  virtual void DoChangeLink (RTMessage Msg) =
	[ID_FIRST + ID_LINKCHANGEBUTTON];
  virtual void ChangeFeatureName (RTMessage Msg) =
	[ID_FIRST + ID_COMBOLINKFEATURENAMES];
  virtual void BindFeatureToFile () =
	[ID_FIRST + ID_LINKFILEBINDBUTTON];
  virtual void BindFeatureToPlotX (RTMessage Msg) =
	[ID_FIRST + ID_LINKPLOTBINDBUTTONX];
  virtual void BindFeatureToPlotY (RTMessage Msg) =
	[ID_FIRST + ID_LINKPLOTBINDBUTTONY];
  virtual void BindFeatureToPlotZ (RTMessage Msg) =
	[ID_FIRST + ID_LINKPLOTBINDBUTTONZ];
};


_CLASSDEF(LinkWindow2)
class LinkWindow2 : public TWindow
{
public:
  LinkWindow2(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.W=145;
     Attr.H=110;
     int par_y=5;
     Attr.Style |= WS_POPUP | WS_BORDER;
     new TStatic(this, -1, "Weight:", 	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Free1:", 	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Free2:", 	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "Free3:", 	  5, 	par_y, 100, 30, 10);
     par_y += 15;
     new TStatic(this, -1, "From:", 	  5, 	par_y, 100, 24, 10);
     par_y +=15;
     new TStatic(this, -1, "To:", 	  5, 	par_y, 100, 30, 10);
     par_y = 5;
     WeightTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 30, 10);
     par_y += 15;
     LinkFree1TStatic=new TStatic(this, -1, "",   70, 	par_y, 100, 30, 10);
     par_y += 15;
     LinkFree2TStatic=new TStatic(this, -1, "",   70, 	par_y, 100, 30, 10);
     par_y += 15;
     LinkFree3TStatic=new TStatic(this, -1, "",   70, 	par_y, 100, 30, 10);
     par_y += 15;
     FromTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 30, 10);
     par_y += 15;
     ToTStatic=new TStatic(this, -1, "", 	  70, 	par_y, 100, 30, 10);
      };
  virtual void SetupWindow();
};


/******** Commands window ***********/

_CLASSDEF(CommandsWindow)
class CommandsWindow : public TWindow
{
public:
  CommandsWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     Attr.W=213;
     Attr.H=115;
     new TStatic(this, -1, "Parameters:",5, 	8, 	80, 24, 10);
     new TStatic(this, -1, "Command:",5, 	38, 	80, 24, 10);
     EditCommand = new TEdit (this, ID_EDITCOMMAND,  "",
					85,	5,	120, 24, 100, FALSE);
     ComboCommands = new TComboBox (this, ID_COMBOCOMMANDS,
					85,	38,	120, 24, CBS_DROPDOWN, 40);
     new TButton (this, ID_COMMANDDOBUTTON,     "Do",   5, 	66, 	70, 25, TRUE);
    };
  virtual void SetupWindow();
  virtual void DoCommand() =
	[ID_FIRST + ID_COMMANDDOBUTTON];

};
/******** Files window ***********/

_CLASSDEF(FilesWindow)
class FilesWindow : public TWindow
{
public:
  FilesWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     Attr.W=240;
     Attr.H=176;
     new TStatic(this, -1, "File name:",5, 	8, 	70, 24, 10);
     new TStatic(this, -1, "Parameter:",5, 	38, 	70, 24, 10);
     EditFiles = new TEdit (this, ID_EDITFILES,  "",
                        80,	5,	100, 24, 200, FALSE);
     ComboParameters = new TComboBox (this, ID_COMBOPARAMETERS,
					80,	38,	100, 24, CBS_DROPDOWNLIST, 40);
     ComboParameters->Attr.Style &= ~CBS_SORT;
     new TButton (this, ID_FILESREADBUTTON,     "Open for reading",
                                   5, 	74, 	120, 25, TRUE);
     new TButton (this, ID_FILESWRITEBUTTON,     "Open for writing",
				   5, 	100, 	120, 25, TRUE);
     new TButton (this, ID_FILESAPPENDBUTTON,     "Open for appending",
				   5, 	126, 	140, 25, TRUE);
     new TButton (this, ID_FILESBINDBUTTON,     "File",
				   183, 	38, 	50, 25, TRUE);
     new TButton (this, ID_FILESCLOSEBUTTON,     "Close", 127, 	74, 	60, 25, TRUE);
    };    
  ~FilesWindow();
  virtual void SetupWindow();
  virtual void OpenFileForReading(RTMessage Msg) =
	[ID_FIRST + ID_FILESREADBUTTON];
  virtual void OpenFileForWriting(RTMessage Msg) =
	[ID_FIRST + ID_FILESWRITEBUTTON];
  virtual void OpenFileForAppending(RTMessage Msg) =
	[ID_FIRST + ID_FILESAPPENDBUTTON];
  virtual void CloseFile(RTMessage Msg) =
	[ID_FIRST + ID_FILESCLOSEBUTTON];
  virtual void BindFile(RTMessage Msg) =
	[ID_FIRST + ID_FILESBINDBUTTON];
};


/******** Plots window ***********/

_CLASSDEF(PlotsWindow)
class PlotsWindow : public TWindow
{
public:
  PlotsWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     par_y=5;
     Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
     Attr.W=227;
     Attr.H=237;
     new TStatic(this, -1, 		     "Plot name:", 	5, 	par_y, 	70, 24, 10);
     EditPlots = new TEdit (this, ID_EDITPLOTS,  "",
					80,	par_y,	90, 24, 100, FALSE);
     par_y+=30;
     new TStatic(this, -1, 		     "Parameter:", 	5, 	par_y, 	70, 24, 10);
     ComboParametersPlots = new TComboBox (this, ID_COMBOPLOTSPARAMETERS,
					80,	par_y,	90, 24, CBS_DROPDOWNLIST, 40);
     new TButton (this, ID_PLOTBUTTONX, "X",  175, 	par_y, 	17, 25, TRUE);
     new TButton (this, ID_PLOTBUTTONY, "Y",  190, 	par_y, 	17, 25, TRUE);
     new TButton (this, ID_PLOTBUTTONZ, "Z",  205, 	par_y, 	17, 25, TRUE);
     ComboParametersPlots->Attr.Style &= ~CBS_SORT;
     par_y+=30;
     new TStatic(this, -1, "X:",   5, 	par_y+3,  20, 24, 10);
     EditPlotsRangeMinX = new TEdit (this, ID_EDITPLOTSRANGEMINX,  "-1.0",
				   28,	par_y,	45, 24, 30, FALSE);
     new TStatic(this, -1, "<=>",   74, par_y+3,  25, 24, 10);
     EditPlotsRangeMaxX = new TEdit (this, ID_EDITPLOTSRANGEMAXX,  "1.0",
				   100,	par_y,	45, 24, 30, FALSE);
     par_y+=30;
     new TStatic(this, -1, "Y:",   5, 	par_y+3,  20, 24, 10);
     EditPlotsRangeMinY = new TEdit (this, ID_EDITPLOTSRANGEMINY,  "-1.0",
				   28,	par_y,	45, 24, 30, FALSE);
     new TStatic(this, -1, "<=>",   74, par_y+3,  25, 24, 10);
     EditPlotsRangeMaxY = new TEdit (this, ID_EDITPLOTSRANGEMAXY,  "1.0",
				   100,	par_y,	45, 24, 30, FALSE);
     par_y+=30;
     new TStatic(this, -1, "Z:",   5, 	par_y+3,  20, 24, 10);
     EditPlotsRangeMinZ = new TEdit (this, ID_EDITPLOTSRANGEMAXZ,  "-1.0",
				   28,	par_y,	45, 24, 30, FALSE);
     new TStatic(this, -1, "<=>",   74, par_y+3,  25, 24, 10);
     EditPlotsRangeMaxZ = new TEdit (this, ID_EDITPLOTSRANGEMINZ,  "1.0",
				   100,	par_y,	45, 24, 30, FALSE);
     par_y+=30;
     PlotPoints=new TCheckBox (this, ID_CHECKBOXPTS,     "Points",
				   5, 	par_y, 	70, 25, NULL);
     PlotLines=new TCheckBox (this, ID_CHECKBOXLNS,     "Lines",
				   80, 	par_y, 	70, 25, NULL);
     par_y+=30;
     new TButton (this, ID_PLOTOPENBUTTON, "Open",  5, 	par_y, 	120, 25, TRUE);
    };
  ~PlotsWindow();
  virtual void SetupWindow();
  virtual void PlotX() =
	[ID_FIRST + ID_PLOTBUTTONX];
  virtual void ReCheckPts(RTMessage Msg) =
	[ID_FIRST + ID_CHECKBOXPTS];
  virtual void ReCheckLns(RTMessage Msg) =
	[ID_FIRST + ID_CHECKBOXLNS];
  virtual void PlotY() =
	[ID_FIRST + ID_PLOTBUTTONY];
  virtual void PlotZ() =
	[ID_FIRST + ID_PLOTBUTTONZ];
  virtual void OpenPlot() =
	[ID_FIRST + ID_PLOTOPENBUTTON];
};



/******** Set window ***********/

_CLASSDEF(SetWindow)
class SetWindow : public TWindow
{
public:
  SetWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |=
       CS_DBLCLKS
     | WS_POPUPWINDOW   
     | WS_OVERLAPPEDWINDOW
     | WS_BORDER
     | WS_CAPTION
     | WS_VSCROLL
     | WS_HSCROLL
     | CS_HREDRAW
     | CS_VREDRAW;
     };
  virtual void WMDestroy (RTMessage Msg)=
    [WM_FIRST + WM_DESTROY];
  virtual void SetupWindow();
  virtual void WMLButtonDown (RTMessage Msg)=
    [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMRButtonDown (RTMessage Msg)=
    [WM_FIRST + WM_RBUTTONDOWN];
  virtual void WMMouseMoveNC (RTMessage Msg)=
    [WM_FIRST + WM_NCMOUSEMOVE];
  virtual void WMMouseMove (RTMessage Msg)=
    [WM_FIRST + WM_MOUSEMOVE];
    
  virtual void Paint (HDC PaintDC, PAINTSTRUCT& PaintInfo );
};


/******** Plot window ***********/

_CLASSDEF(PlotWindow)
class PlotWindow : public TWindow
{
public:
  PlotWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |=
       CS_DBLCLKS
     | WS_POPUPWINDOW   
     | WS_OVERLAPPEDWINDOW
     | WS_BORDER
     | WS_CAPTION
     | WS_VSCROLL
     | WS_HSCROLL
     | CS_HREDRAW
     | CS_VREDRAW;
     };
  virtual void Paint (HDC PaintDC, PAINTSTRUCT& PaintInfo );
};


/******** Links windows ***********/

_CLASSDEF(LinksToSetWindow)
class LinksToSetWindow : public TWindow
{
public:
  LinksToSetWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |=
     WS_POPUPWINDOW | WS_OVERLAPPEDWINDOW | WS_BORDER |  WS_CAPTION | WS_VSCROLL |
     WS_HSCROLL | CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
     };
  virtual void WMDestroy (RTMessage Msg)=
    [WM_FIRST + WM_DESTROY];
  virtual void SetupWindow();
  virtual void Paint (HDC PaintDC, PAINTSTRUCT& PaintInfo );
  virtual void WMLButtonDown (RTMessage Msg)=
    [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMMouseMoveNC (RTMessage Msg)=
    [WM_FIRST + WM_NCMOUSEMOVE];
  virtual void WMMouseMove (RTMessage Msg)=
    [WM_FIRST + WM_MOUSEMOVE];
};

_CLASSDEF(LinksFromSetWindow)
class LinksFromSetWindow : public TWindow
{
public:
  LinksFromSetWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle)
    {
     Attr.Style |=
     WS_POPUPWINDOW | WS_OVERLAPPEDWINDOW | WS_BORDER |  WS_CAPTION | WS_VSCROLL |
     WS_HSCROLL | CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
     };
  virtual void WMDestroy (RTMessage Msg)=
    [WM_FIRST + WM_DESTROY];
  virtual void SetupWindow();
  virtual void Paint (HDC PaintDC, PAINTSTRUCT& PaintInfo );
  virtual void WMLButtonDown (RTMessage Msg)=
    [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMMouseMoveNC (RTMessage Msg)=
    [WM_FIRST + WM_NCMOUSEMOVE];
  virtual void WMMouseMove (RTMessage Msg)=
    [WM_FIRST + WM_MOUSEMOVE];    
};



		/*******  Functions **********/



/****************** Main window handle functions *************************/


TcsWindow::~TcsWindow()
  {
   DeleteObject (hBrush1);
   DeleteObject (hBrush2);
   DeleteObject (hBrush3);
   DeleteObject (hBrush4);
   DeleteObject (hPen1);
   }

void TcsWindow::HandleCyclesButton(RTMessage)
{
 char cycl[30];
 CyclesWind = new CyclesWindow (this,"Cycles");

 GetApplication()->MakeWindow (CyclesWind);
 sprintf (cycl, "%ld", cycle-1);
 AStaticCycles->SetText (cycl);
 sprintf (cycl, "%ld", AllCycles-1);
 AStaticAllCycles->SetText (cycl);
}

void TcsWindow::HandleFilesButton(RTMessage)
{
 if (!filewindow_open)
 {
 FilesWind = new FilesWindow (this,"Files");
 filewindow_open=1;
 ComboParameters->Attr.H=(up_index+1)*17+25;
 GetApplication()->MakeWindow (FilesWind);
 }
}

void TcsWindow::HandlePlotsButton(RTMessage)
{
 PTWindow PWind;
 plotwindow_open=1;
 PWind=new PlotsWindow (this,"Plots");
 ComboParametersPlots->Attr.H=(up_index+1)*17+25;
 GetApplication()->MakeWindow (PWind);
}

void TcsWindow::HandleMessagesButton(RTMessage)
{
 MessageWind = new MessageWindow (this,"Messages");

 GetApplication()->MakeWindow (MessageWind);
}

void TcsWindow::HandleRunButton(RTMessage)
{
 RunWind = new RunWindow (this,"Run");

 GetApplication()->MakeWindow (RunWind);
}

void TcsWindow::HandleParametersButton(RTMessage)
{
 int i=0;
 par_y=5;

 ParWind = new ParametersWindow (this,"Parameters");
 while (up_installed[i])
         {
	   new TStatic(ParWind, -1, up_names[i], 	  5, 	par_y + 3, 75, 24, 10);
	   parameters [i]= new TEdit (ParWind, -1,  "0",  82,	par_y,     90, 24, 15, FALSE);

	   par_y += 28;

           i++;
	  }
 ParWind->Attr.W=180;
 ParWind->Attr.H=par_y+60;
 ParameterChangeButton->Attr.Y= par_y+10;
 GetApplication()->MakeWindow (ParWind);
}

void TcsWindow::HandleSetsButton(RTMessage)
{
 int step;
 step=(currentset+1)*17;
 SetsWind = new SetsWindow (this,"Sets");
 if (step>170) step=170;
 SetsListBox->Attr.H=step;
 SetsWind->Attr.H=step + 30;
 GetApplication()->MakeWindow (SetsWind);
}


void TcsWindow::HandleCommandsButton(RTMessage)
{
 CommandsWind = new CommandsWindow (this,"Commands");
 ComboCommands->Attr.H=(uc_index+1)*17+25;
 GetApplication()->MakeWindow (CommandsWind);
}


void TcsWindow::HandleSpecialButton(RTMessage)
  {
  char str[70];

  StatusWind = new StatusWindow (this,"Status");
  GetApplication()->MakeWindow (StatusWind);

  sprintf (str, "%ld", nr_all_units);
  AStaticNrUnits->SetText (str);

  sprintf (str, "%ld", nr_all_links);
  AStaticNrLinks->SetText (str);

  sprintf (str, "%ld", sizeof (Unit)*nr_all_units +
		sizeof(Link)*nr_all_links);
  AStaticNrBytes->SetText (str);

  }


/*************************  Setup window messages ***************************/


void CommandsWindow::SetupWindow()
{
 int i;
 char strin[20];
 TWindow::SetupWindow();
 for (i=0; i<uc_index; i++)
     {
     sprintf (strin, "%s", uc_names[i]);
     ComboCommands->AddString (strin);
     }
}

void SetsWindow::SetupWindow()
{
 SetPtr set;
 int i;
 TWindow::SetupWindow();
 for (i=0; i<currentset; i++)
     {
     set=SetArray [i];
     SetsListBox->AddString (set->Name);
     }
 SetsListBox->AddString ("All");
}


void FilesWindow::SetupWindow()
{
 int i=0;
 char strin[20];
 TWindow::SetupWindow();
 while (up_installed[i])
     {
     sprintf (strin, "%s", up_names[i]);
     ComboParameters->AddString (strin);
     i++;
     }
}

void PlotsWindow::SetupWindow()
{
 int i=0;
 char strin[20];
 TWindow::SetupWindow();
 while (up_installed[i])
     {
     sprintf (strin, "%s", up_names[i]);
     ComboParametersPlots->AddString (strin);
     i++;
     }
 ComboParametersPlots->AddString ("time");
 sprintf (strin, "%s%d", "Plot", currentplot);
 EditPlots->SetText (strin);
 PlotLines->Check();
}


void UnitWindow2::SetupWindow()
{
 TWindow::SetupWindow();
}


void SetControlWindow::SetupWindow()
{
 int i, height;
 TWindow::SetupWindow();
 ComboSetFeatureNames->Attr.H=5*24;
 ComboSetFeatureNames->AddString ("Output");
 ComboSetFeatureNames->AddString ("Netinput");
 ComboSetFeatureNames->AddString ("Free1");
 ComboSetFeatureNames->AddString ("Free2");
 ComboSetFeatureNames->AddString ("Free3");
}



void UnitWindow::SetupWindow()
{
 int i, height;
 TWindow::SetupWindow();
 height=currentset*24;
 if (height>124)
    height=124;
 ComboLinksToSet->Attr.H=height;
 ComboLinksFromSet->Attr.H=height;
 ComboFeatureNames->Attr.H=5*24;
 ComboFeatureNames->AddString ("Output");
 ComboFeatureNames->AddString ("Netinput");
 ComboFeatureNames->AddString ("Free1");
 ComboFeatureNames->AddString ("Free2");
 ComboFeatureNames->AddString ("Free3");
 for (i=0; i<currentset; i++)
     ComboLinksToSet->AddString (SetArray[i]->Name);
 for (i=0; i<currentset; i++)
     ComboLinksFromSet->AddString (SetArray[i]->Name);
}


void LinkWindow2::SetupWindow()
{
 TWindow::SetupWindow();
}


void LinkWindow::SetupWindow()
{
 TWindow::SetupWindow();
 ComboLinkFeatureNames->Attr.H=4*24;
 ComboLinkFeatureNames->AddString ("Weight");
 ComboLinkFeatureNames->AddString ("Free1");
 ComboLinkFeatureNames->AddString ("Free2");
 ComboLinkFeatureNames->AddString ("Free3");
}


void MessageWindow::SetupWindow()
{
 TWindow::SetupWindow();
}

void ParametersWindow::SetupWindow()
{
 int i=0;
 char strin[15];
 TWindow::SetupWindow();
 while (up_installed[i])
 {
  sprintf (strin, "%10.3f", *up[i]);
  parameters [i]->SetText (strin);
  i++;
 }
}

void SetWindow::SetupWindow()
{
 TWindow::SetupWindow();
}


void LinksToSetWindow::SetupWindow()
{
 TWindow::SetupWindow();
}

void LinksFromSetWindow::SetupWindow()
{
 TWindow::SetupWindow();
}

/*****************  Cycles window stuff ***********/



void CyclesWindow::ResetCycles()
 {
 AllCycles=1;
 cycle=1;
 AStaticCycles->SetText ("0");
 AStaticAllCycles->SetText ("0");
 }


/*********************** Command stuff **************************/


void CommandsWindow::DoCommand ()
{
 int i;
 char command_name [20];
 ComboCommands->GetText (command_name, 19);
 for (i=0; i<uc_index; i++)
     if (!strcmp (uc_names[i], command_name))
	 (*uc[i])();
}

char *Parameter (int n)
 {
  char strin[50];
  EditCommand->GetText (strin, 49);
  return (getword (strin, n));
  }


/*****************  Message window stuff ***********/


MessageWindow::~MessageWindow()
 {
 MessageWind=NULL;
 }

/******************  Plot Window stuff *************/

PlotsWindow::~PlotsWindow()
 {
 plotwindow_open=0;
 }
/*
PlotWindow::~PlotWindow()
 {
 plotwindow_open=0;
 }
*/

void PlotsWindow::ReCheckPts (RTMessage Msg)
 {
  if (Msg.LP.Hi==BN_CLICKED)
     {
     if (PlotPoints->GetCheck()==BF_CHECKED)
         PlotLines->Uncheck();
     else if (PlotPoints->GetCheck()==BF_UNCHECKED)
	 PlotLines->Check();
     }
  }


void PlotsWindow::ReCheckLns (RTMessage Msg)
 {
  if (Msg.LP.Hi==BN_CLICKED)
     {
     if (PlotLines->GetCheck()==BF_CHECKED)
         PlotPoints->Uncheck();
     else if (PlotLines->GetCheck()==BF_UNCHECKED)
	 PlotPoints->Check();
     }
  }


int FindPlot (char *plotname)
  {
  int i, j, noteq;
  for (i=0; i<10; i++)
    {
    noteq=0;
    for (j=0; j<strlen(plotname); j++)
       {
       if (plot_name_array[j][i]!=plotname[j])
	  {
	   noteq=1;      
	   break;
	  }
       }
    if (!noteq)
       return (i);
    }
  return (i);
  }  

int NoPlotPointer (char *plotname, float *par)
  {
   int i, f;
   f=FindPlot (plotname);
   for (i=0; i<10; i++)
     {
     if (plot_parameter_pointers_array_x[i][f]==par)
	return (0);
     else
     if (plot_parameter_pointers_array_y[i][f]==par)
	return (0);
     else
     if (plot_parameter_pointers_array_z[i][f]==par)
	return (0);
	}
   return (1);
  }

int FindFirstEmptySlotPlot (int i, int k)
  {
  int j;
  for (j=0; j<10; j++)
      switch (k)
       {
       case 0:
        if (plot_parameter_pointers_array_x[j][i]==0)
	   return (j);
        break;
       case 1:
        if (plot_parameter_pointers_array_y[j][i]==0)
	   return (j);
        break;
       case 2:
        if (plot_parameter_pointers_array_z[j][i]==0)
	   return (j);
        break;
       }
  return 0;
  }

void SetPlot (int n)
  {
    char plot[55];
    char param[30];
    float *par;
    int i;
    EditPlots->GetText (plot, 50);
    ComboParametersPlots->GetText (param, 28);

    for (i=0; i<up_index; i++)
     if (!strcmp (up_names[i], param))
	par=up[i];
     else
     if (!strcmp ("time", param))
	par= &(plot_counter_array[currentplot]);
	       
    if (0!=strlen (plot))
    {
    if (NoPlotPointer (plot, par))
	  {
          if (n==0)
	     plot_parameter_pointers_array_x
	     [FindFirstEmptySlotPlot(currentplot,0)][currentplot]=
	     par;
	  else
	  if (n==1)
	     plot_parameter_pointers_array_y
	     [FindFirstEmptySlotPlot(currentplot,1)][currentplot]=
	     par;
	  else
	  if (n==2)
	     plot_parameter_pointers_array_z
	     [FindFirstEmptySlotPlot(currentplot,2)][currentplot]=
	     par;
	  }
    }
  }

void PlotsWindow::PlotX()
   {
    SetPlot (0);
   }

void PlotsWindow::PlotY()
   {
    SetPlot (1);
   }
       
void PlotsWindow::PlotZ()
   {
    SetPlot (2);
   }

void PlotsWindow::OpenPlot()
  {
  HDC ContextHandle;
  PTWindow PlotWind;
  float maxx=1, minx=0, maxy=1, miny=0, maxz=1, minz=0, y_zero, x_zero, z_zero;
  int height=200,width=400, i,limit_x,limit_y;
  char plot[11], param[30];
  char str[10];
  unsigned long *colors;

  EditPlots->GetText (plot, 10);

  if (BF_CHECKED==PlotPoints->GetCheck())
      plot_point[currentplot]=1;
  else
      plot_point[currentplot]=0;

  for (i=0; i<strlen(plot); i++)
	  plot_name_array[i][currentplot]=plot[i];
  PlotWind = new PlotWindow (this, plot);
  PlotWind->Attr.W=400;
  PlotWind->Attr.H=200;
  GetApplication()->MakeWindow (PlotWind);
  PlotWinds[currentplot]=PlotWind;

  ContextHandle = GetDC (PlotWind->HWindow);

  SelectObject (ContextHandle, hBrush1);
  SelectObject (ContextHandle, GetStockObject (BLACK_PEN));
  Rectangle (ContextHandle,
    		0,
		0,
		700,
		700);
  EditPlotsRangeMaxX->GetText(str, 8);
  maxx=atof (str);
  EditPlotsRangeMinX->GetText(str, 8);
  minx=atof (str);
  EditPlotsRangeMaxY->GetText(str, 8);
  maxy=atof (str);
  EditPlotsRangeMinY->GetText(str, 8);
  miny=atof (str);
  EditPlotsRangeMaxZ->GetText(str, 8);
  maxz=atof (str);
  EditPlotsRangeMinZ->GetText(str, 8);
  minz=atof (str);

  X_max[currentplot]=maxx;
  X_min[currentplot]=minx;

  Y_max[currentplot]=-maxy;
  Y_min[currentplot]=-miny;

  Z_max[currentplot]=fabs(maxz);
  Z_min[currentplot]=fabs(minz);

  y_zero=-maxy/(miny - maxy);
  x_zero=-minx/(maxx - minx);
  z_zero=fabs(maxz)*17.00/(fabs(maxz) + fabs(minz)); 

  X_zero[currentplot]=x_zero;
  Y_zero[currentplot]=y_zero;
  Z_zero[currentplot]=z_zero;

  MoveTo (ContextHandle, 0, (int)(height*y_zero));
  LineTo (ContextHandle, width, (int)(height*y_zero));
  MoveTo (ContextHandle, (int)(width*x_zero), 0);
  LineTo (ContextHandle, (int)(width*x_zero), height);

  limit_x=FindFirstEmptySlotPlot(currentplot,0);
//  limit_y=FindFirstEmptySlotPlot(currentplot,1);
/*
  TStaticPlotsX->GetText (param, 28);
  if (!strcmp ("time", param))
  for (i=0; i<limit_x; i++)
   {
    old_x[i][currentplot]=0;
    *plot_parameter_pointers_array_x[i][currentplot]= 0.0;
    old_y[i][currentplot]=(int)
	 (height*y_zero -  *plot_parameter_pointers_array_y[i][currentplot]*
		      (float)height/(miny - maxy));
   }
  else
  */
  for (i=0; i<limit_x; i++)
   {
//    printf ("Pointer: %f\n Width: %d\n Height: %d\n Diff1: %f\n Diff2 %f\n XZero %f\n", *plot_parameter_pointers_array_x[i][currentplot],
//		      width, height,
//		      (maxx - minx), (miny - maxy),
//		      x_zero);
    old_x[i][currentplot]=(int)
	(*plot_parameter_pointers_array_x[i][currentplot]*
		      (float)width/(maxx - minx) + width*x_zero);
    old_y[i][currentplot]=(int)
	(height*y_zero -  *plot_parameter_pointers_array_y[i][currentplot]*
		      (float)height/(miny - maxy));

   }
  plot_counter_array[currentplot]=0.0;

  currentplot++;
  ReleaseDC (PlotWind->HWindow, ContextHandle);
 }


void DrawIntoPlots()
  {
  char c[10];
  HDC ContextHandle;
  PTWindow PlotWind;
  int i=0, j=0, k=0;
  unsigned long *colors;
  int param, plot_type, plot_width, repaint=0;
  int from_x, from_y, to_x, to_y, to_z,
      height, width, point, x_zero, y_zero, z_zero;

  for (i=0; i<currentplot; i++)
       {
       point=plot_point[i];


       ContextHandle=GetDC (PlotWinds[i]->HWindow);
       DeleteObject (SelectObject (ContextHandle, hBrush1));
       SelectObject (ContextHandle, hPen1);

       height=PlotWinds[i]->Attr.H;
       width=PlotWinds[i]->Attr.W;
       x_zero=width*X_zero[i];
       y_zero=height*Y_zero[i];
//       z_zero=Z_zero[i];
       j=0;
       while (plot_parameter_pointers_array_x[j][i]!=0)
	{
	from_x=old_x[j][i];
	to_x=(int)
	  (*plot_parameter_pointers_array_x[j][i]*
		       (float)width/(X_max[i] - X_min[i]) + (float)x_zero);
	if (to_x>=width)
	 {
	  repaint=1;
	  old_x[j][i]=0;
	 }
	else
	 old_x[j][i]=to_x;
	if (repaint)
         {
		DeleteObject (SelectObject (ContextHandle, hBrush1));
		SelectObject (ContextHandle, GetStockObject (BLACK_PEN));

  		Rectangle (ContextHandle,
    				0,
				0,
				700,
				700);

		MoveTo (ContextHandle, 0, y_zero);
		LineTo (ContextHandle, width,  y_zero);
		MoveTo (ContextHandle, x_zero, 0);
		LineTo (ContextHandle, x_zero, height);

		MoveTo (ContextHandle, 0, to_y);
		plot_counter_array[i]=0;
		repaint=0;
	 }
	else
	{
	k=0;
	while (plot_parameter_pointers_array_y[k][i]!=0)
		{
		 from_y=old_y[k][i];
		 to_y=(int)
		     ((float)y_zero - *plot_parameter_pointers_array_y[k][i]*
		       (float)height/(Y_min[i] - Y_max[i]));

		 if (point)                    
		   {
		    MoveTo (ContextHandle, to_x-1, to_y-1);
		    LineTo (ContextHandle, to_x, to_y);
		    }
		 else
                   {
		    MoveTo (ContextHandle, from_x, from_y);
		    LineTo (ContextHandle, to_x, to_y);
                    }
		 old_y[k][i]=to_y;
		 k++;
		 }
	  }
	j++;
       }
      plot_counter_array[i]++;
      ReleaseDC (PlotWinds[i]->HWindow, ContextHandle);
      }
  }



void PlotWindow::Paint (HDC PaintDC, PAINTSTRUCT&)
  {
  HDC ContextHandle;
  int height, width, i, x_zero, y_zero, z_zero;

  ContextHandle=PaintDC;
  for (i=0; i<currentplot; i++)
       if (HWindow==PlotWinds[i]->HWindow)
	   {
	       height=PlotWinds[i]->Attr.H;
	       width=PlotWinds[i]->Attr.W;
	       x_zero=width*X_zero[i];
	       y_zero=height*Y_zero[i];
//	       z_zero=Z_zero[i];
	       break;
           }
  SelectObject (ContextHandle, hBrush1);
  SelectObject (ContextHandle, GetStockObject (BLACK_PEN));

  Rectangle (ContextHandle,
    		0,
		0,
		700,
		700);

  MoveTo (ContextHandle, 0, (int)y_zero);
  LineTo (ContextHandle, width, (int)y_zero);
  MoveTo (ContextHandle, (int)x_zero, 0);
  LineTo (ContextHandle, (int)x_zero, height);
  }



/*****************  File window stuff ***********/




FilesWindow::~FilesWindow()
 {
 filewindow_open=0;
 }

// FindFile returns the index of a filename in file_name_array,
// if the file is in that array. If it isn't, then FindFile returns 10

int FindFile (char *filename)
  {
  int i, j, eq;
  for (i=0; i<10; i++)
    {
    eq=1;
    for (j=0; j<strlen(filename); j++)
       {
       if (file_name_array[j][i]!=filename[j])
	  {
	   eq=0;      
	   break;
	  }
       }
    if (eq)
       return (i);
    }
  return (10);
  }  

int FFirstEmptySlotFileName ()
  {
  int i;
  for (i=0; i<10; i++)
    if (file_name_array[0][i]== '\0')
       return (i);
  return (10);
  }  

int FindSetInFileSetArray (SetPtr set)
  {
  int i, j, noteq;
  for (i=0; i<10; i++)
    {
    noteq=0;
    for (j=0; j<10; j++)
        {
	if (set==file_set_array[j])
	{
	noteq=1;
	break;
	}
	}
    if (!noteq)
       return (i);
    }
  return (i);
  }  
/*
int FindFirstEmptySlotSet (char *filename)
  {
  int i, j;
  i=FindFile(filename);
  for (j=0; j<5; j++)
      {
      if (file_set_array[j][i]==0)
	 return (j);
      }
  return (5);
  }
*/
int FindFirstEmptySlot (char *filename)
  {
  int i, j;
  i=FindFile(filename);
  for (j=0; j<10; j++)
      {
      if (file_parameter_pointers_array[j][i]==0)
	 return (j);
      }
  return (10);
  }

int FindFirstEmptySlotWriteFile (char *filename)
  {
  int i, j;
  i=FindFile(filename);
  for (j=0; j<10; j++)
      {
      if (write_file_array[j][i]==0)
	 return (j);
      }
  return (10);
  }

void store_parameters_for_file_output ()
   {
    char file[55];
    char param[30];
    float *par;
    int i;

    EditFiles->GetText (file, 50);
    ComboParameters->GetText (param, 28);

    for (i=0; i<up_index; i++)
     if (!strcmp (up_names[i], param))
	par=up[i];       

    if (0!=strlen (file));
        file_parameter_pointers_array[FindFirstEmptySlot(file)]
				     [FindFile(file)]=par;
   }

void FileOpenMessage (HWND HWindow, int i)
  {
  if (read_file[i]==1)
      MessageBox (HWindow, "File was already open for reading!",
			   "Warning", MB_OK);
  else
  if (read_file[i]==0)
      MessageBox (HWindow, "File was already open for writing!",
			   "Warning", MB_OK);
  }


void FilesWindow::OpenFileForReading(RTMessage)
{
FILE *f;
char strin[55];
int i, file_ind;

EditFiles->GetText (strin, 50);
if (strlen (strin)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return;
    }
else
{
if (FindFile (strin)< 10)
    FileOpenMessage (HWindow, FindFile (strin));
else
if (FindFile (strin)== 10)
	{
	f=fopen (strin, "r");
	file_ind=FFirstEmptySlotFileName();
	if (f==NULL)
	    {
	    MessageBox (HWindow, "File does not exist yet!",
				 "Error", MB_OK);
	    return;
	    }
	file_array[file_ind]=f;
	read_file[file_ind]=1;
	for (i=0; i<strlen(strin); i++)
	  file_name_array[i][file_ind]=strin[i];
	current_file_index++;
	}
}
}

FILE *FileWrite (char *strin, HWND HWindow, int write)
{
FILE *f;
if (strlen (strin)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return 0;
    }
if (write)
{
if (fopen (strin, "r"))
   {
   if
    (MessageBox (HWindow, "    File exists already. \nDo you want to overwrite it?",
			      "Warning", MB_YESNO | MB_ICONQUESTION)== IDYES)
    {f=fopen (strin, "w"); return f;}
   else return 0;
   }
else
   f=fopen (strin, "w");
}
else
   f=fopen (strin, "a");
if (!f)
    {
     MessageBox (HWindow, "Path of file is wrong!","Error", MB_OK);
     return 0;
    }
else return f;
}

void FilesWindow::OpenFileForWriting(RTMessage)
{
FILE *f;
char strin[55];
int i, file_ind;

EditFiles->GetText (strin, 50);
f=FileWrite (strin, HWindow, 1);
if (f && FindFile (strin)== 10)
   {
   file_ind=FFirstEmptySlotFileName();
   file_array[file_ind]=f;
   read_file[file_ind]=0;
   for (i=0; i<strlen(strin); i++)
	file_name_array[i][file_ind]=strin[i];
   current_file_index++;
   }
}

void FilesWindow::OpenFileForAppending(RTMessage)
{
FILE *f;
char strin[55];
int i, file_ind;

EditFiles->GetText (strin, 50);
f=FileWrite (strin, HWindow, 0);
if (f && FindFile (strin)== 10)
   {
   file_ind=FFirstEmptySlotFileName();
   file_array[file_ind]=f;
   read_file[file_ind]=0;
   for (i=0; i<strlen(strin); i++)
	file_name_array[i][file_ind]=strin[i];
   current_file_index++;
   }
else
 FileOpenMessage (HWindow, FindFile (strin));
}

void FilesWindow::CloseFile(RTMessage)
{
 char strin[55];
 int f,j,i;

 EditFiles->GetText (strin, 50);

 f=FindFile(strin);

 if (f!=10)
 {
 fclose (file_array[f]);

 file_array[f]=NULL;

 if (read_file[f]==1)
    {
     read_file_param[f]=0;
     file_set_array[f]=NULL;
     }
 else
   for (j=0; j<10; j++)
     file_parameter_pointers_array[j][f]=0;
 for (i=0; i<strlen(strin); i++)
     file_name_array[i][f]='\0';
 }
}
void FilesWindow::BindFile(RTMessage)
{
 store_parameters_for_file_output();
}

void ParametersWindow::DoChange(RTMessage)
{
int i=0;
char strin[20];
while (up_installed[i])
	{
	parameters [i]->GetText (strin, 15);
	*up[i]=atof (strin);
	i++;
	}
}


/*****************  Link window stuff **********************/

LinkPtr GetLinkFromLinkWindow ()
{
char strin[51];
UnitPtr fromunit, tounit;
LinkPtr unitlink, link;
SetPtr toset,fromset;
int toindex, fromindex, i, l;
char tosetname [20], fromsetname [20], setname2 [20];

ToEdit->GetText (strin, 50);
strcpy (tosetname, getword (strin, 1));
toindex = atoi(getword (strin, 2));

FromEdit->GetText (strin, 50);
strcpy (fromsetname, getword (strin, 1));
fromindex = atoi(getword (strin, 2));

toset=FindSet(tosetname);
fromset=FindSet(fromsetname);

fromunit=SetMember (fromset, fromindex);
tounit=SetMember (toset, toindex);

unitlink=tounit->Links;
while (unitlink)
   {
     if (unitlink->From==fromunit)
      {
      return unitlink;
      }
     unitlink=unitlink->Next;
   }
return NULL;
}


void LinkWindow::ChangeFeatureName (RTMessage Msg)
{
char strin[14];
LinkPtr link;

if (Msg.LP.Hi==CBN_SELCHANGE)
{
link=GetLinkFromLinkWindow ();

sprintf (strin, "%10.4f", GetLinkParam (link, ComboLinkFeatureNames->GetSelIndex()+1));
EditLinkFeatureValues->SetText (strin);
}
}


void LinkWindow::DoChangeLink(RTMessage)
{
char strin[16], strin2[16];
LinkPtr link;
int link_feature;
link=GetLinkFromLinkWindow ();

link_feature=ComboLinkFeatureNames->GetSelIndex ()+1;
EditLinkFeatureValues->GetText (strin, 15);
PutLinkParam (link, link_feature, atof (strin));
}


void LinkWindow::BindFeatureToFile ()
{
char filename[55];
float *p;
LinkPtr link;
int index, i, n;

if (filewindow_open)
{
EditFiles->GetText (filename, 50);
link=GetLinkFromLinkWindow ();
n=ComboLinkFeatureNames->GetSelIndex()+1;
p = GetLinkParamPointer (link, n);
if (strlen (filename)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return;
    }
else
   {
    if (n==1) p=&(link->Weight);
    else if (n==2) p=&(link->Free1);
    else if (n==3) p=&(link->Free2);
    else if (n==4) p=&(link->Free3);
    file_parameter_pointers_array[FindFirstEmptySlot(filename)]
				 [FindFile(filename)]=p;
    }
}
else
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
}


void BindLinkFeatureToPlot (int achse, HWND HWindow)
{
char plot[55];
float *p;
LinkPtr link;
int index, n;

if (plotwindow_open)
{
link=GetLinkFromLinkWindow ();
n = ComboLinkFeatureNames->GetSelIndex()+1;
p = GetLinkParamPointer (link, n);
if (strlen (plot)==0)
   {
    MessageBox (HWindow, "No plotname specified!","Error", MB_OK);
    return;
    }
else
   {
    if (achse==0)
      {
      plot_parameter_pointers_array_x
	     [FindFirstEmptySlotPlot(currentplot,0)][currentplot]=
	     p;
      }
    else
    if (achse==1)
      {
      plot_parameter_pointers_array_y
	     [FindFirstEmptySlotPlot(currentplot,1)][currentplot]=
	     p;
      }
    else
    if (achse==2)
      {
      plot_parameter_pointers_array_z
	     [FindFirstEmptySlotPlot(currentplot,2)][currentplot]=
	     p;
      }
    }
}
else
    MessageBox (HWindow, "Open 'Plots!' window first","Error", MB_OK);
}	


void LinkWindow::BindFeatureToPlotX (RTMessage)
{
 BindLinkFeatureToPlot (0, HWindow);
}


void LinkWindow::BindFeatureToPlotY (RTMessage)
{
 BindLinkFeatureToPlot (1, HWindow);
}


void LinkWindow::BindFeatureToPlotZ (RTMessage)
{
 BindLinkFeatureToPlot (2, HWindow);
}



/*****************  Unit window stuff **********************/

UnitWindow::~UnitWindow()
 {
 unitcontrolwindow_open=0;
 }

void UnitWindow::ChangeFeatureName (RTMessage Msg)
{
char strin[14];
UnitPtr unit;
SetPtr set;
int index, i, l, Indx;
char setindex[40], setname [20], setname2 [20];
if (Msg.LP.Hi==CBN_SELCHANGE)
{
NameEdit->GetText(setindex, 39);
strcpy (setname, getword (setindex, 1));
index = atoi(getword (setindex, 2));
set=FindSet (setname);
unit = SetMember (set, index);
sprintf (strin, "%10.4f", GetUnitParam (unit, ComboFeatureNames->GetSelIndex()));
EditFeatureValues->SetText (strin);
}
}


void UnitWindow::DoChangeUnit(RTMessage)
{
char strin[16], strin2[16];
UnitPtr unit;
SetPtr set;
int index, i, l, unit_feature;
char setindex[40], setname [20], setname2 [20];
NameEdit->GetText(setindex, 39);
strcpy (setname, getword (setindex, 1));
index = atoi(getword (setindex, 2));
set=FindSet(setname);
unit = SetMember (set, index);
unit_feature=ComboFeatureNames->GetSelIndex ();
EditFeatureValues->GetText (strin, 15);
PutUnitParam (unit, unit_feature, atof (strin));
}


void UnitWindow::BindFeatureToFile ()
{
char filename[55];
float *p;
UnitPtr unit;
SetPtr set;
int index, i, n;
char setindex[50], setname [20], setname2 [20];

if (filewindow_open)
{
EditFiles->GetText (filename, 50);
NameEdit->GetText (setindex, 50);

strcpy (setname, getword (setindex, 1));

index = atoi(getword (setindex, 2));

set = FindSet(setname);
unit = SetMember (set, index);
n = ComboFeatureNames->GetSelIndex();
if (strlen (filename)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return;
    }
else
   {
    if	    (n==0) p=&(unit->Output);
    else if (n==1) p=&(unit->Netinput);
    else if (n==2) p=&(unit->Free1);
    else if (n==3) p=&(unit->Free2);
    else if (n==4) p=&(unit->Free3);
    file_parameter_pointers_array[FindFirstEmptySlot(filename)]
				 [FindFile(filename)]=p;
    }
}
else
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
}


void BindFeatureToPlot (int achse, HWND HWindow)
{
char plot[55];
UnitPtr unit;
SetPtr set;
int index, i, n;
float *p;
char setindex[50], setname [20], setname2 [20];

if (plotwindow_open)
{
EditPlots->GetText (plot, 50);
NameEdit->GetText (setindex, 50);

strcpy (setname, getword (setindex, 1));

index = atoi(getword (setindex, 2));

set=FindSet (setname);

unit = SetMember (set, index);
n = ComboFeatureNames->GetSelIndex();
p = GetUnitParamPointer (unit, n);
if (strlen (plot)==0)
   {
    MessageBox (HWindow, "No plotname specified!","Error", MB_OK);
    return;
    }
else
   {
    if (achse==0)
      {
      plot_parameter_pointers_array_x
	     [FindFirstEmptySlotPlot(currentplot,0)][currentplot]=
	     p;
      }
    else
    if (achse==1)
      {
      plot_parameter_pointers_array_y
	     [FindFirstEmptySlotPlot(currentplot,1)][currentplot]=
	     p;
      }
    else
    if (achse==2)
      {
      plot_parameter_pointers_array_z
	     [FindFirstEmptySlotPlot(currentplot,2)][currentplot]=
	     p;
      }
    }
}
else
    MessageBox (HWindow, "Open 'Plots!' window first","Error", MB_OK);
}	


void UnitWindow::BindFeatureToPlotX (RTMessage)
{
 BindFeatureToPlot (0, HWindow);
}


void UnitWindow::BindFeatureToPlotY (RTMessage)
{
 BindFeatureToPlot (1, HWindow);
}


void UnitWindow::BindFeatureToPlotZ (RTMessage)
{
 BindFeatureToPlot (2, HWindow);
}



float MaxWeightFromSetToUnit (UnitPtr unit, SetPtr fromset)
   {
   LinkPtr curlink;
   float gr;

   curlink=unit->Links;
   gr=-1000000.0;
   while (curlink)
	 {
	 if (curlink->From->Set==fromset)
	    {
	    if (curlink->Weight > gr)
	       gr=curlink->Weight;
	    }
	 curlink=curlink->Next;
	 }
  return (gr);
  }

float MinWeightFromSetToUnit (UnitPtr unit, SetPtr fromset)
   {
   LinkPtr curlink;
   float sm;

   curlink=unit->Links;
   sm=1000000.0;
   while (curlink)
	 {
	 if (curlink->From->Set==fromset)
            {
	    if (curlink->Weight < sm)
	       sm=curlink->Weight;
            }
	 curlink=curlink->Next;
	 }
  return (sm);
  }


float MaxWeightFromUnitToSet (UnitPtr fromunit, SetPtr toset)
   {
   LinkPtr curlink;
   UnitPtr unit;
   float gr;
   int i;

   gr=-1000000.0;
   for (i=0; i<toset->Length; i++)
   {
   unit=SetMember (toset, i);
   curlink=unit->Links;
   while (curlink)
	 {
	 if (curlink->From==fromunit)
            {
	    if (curlink->Weight > gr)
	       gr=curlink->Weight;
            }
	 curlink=curlink->Next;
	 }
  }
  if (gr<-999999.0)
      return 0.0;
  else
  return (gr);
  }

float MinWeightFromUnitToSet (UnitPtr fromunit, SetPtr toset)
   {
   LinkPtr curlink;
   UnitPtr unit;
   float sm;
   int i;

   sm=1000000.0;
   for (i=0; i<toset->Length; i++)
   {
   unit=SetMember (toset, i);
   curlink=unit->Links;
   while (curlink)
	 {
	 if (curlink->From==fromunit)
            {
	    if (curlink->Weight < sm)
	       sm=curlink->Weight;
	    }
	 curlink=curlink->Next;
	 }
  }
  if (sm>999999.0)
      return 0.0;
  else
  return (sm);
  }

int FindFirstEmptyLTS ()
  {
  int i;
  for (i=0; i<20; i++)
    if (LinksToSetWinds[i]==NULL)
       return i;
  return 0;
  }

int FindFirstEmptyLFS ()
  {
  int i;
  for (i=0; i<20; i++)
    if (LinksFromSetWinds[i]==NULL)
       return i;
  return 0;
  }

void UnitWindow::OpenLinksWindow (int toSet, HWND HWindow)
 {
  int nr_col, nr_lin, x, index, i, links_present=0;
  long j,k,q,h,v, edge_x, edge_y, lgth;
  float o, gr, sm;
  char setindex[50], setname [20], fromsetname [20],
       tosetname [20];
  HDC ContextHandle;
  UnitPtr fromunit, tounit;
  LinkPtr curlink=NULL, unitlink;
  SetPtr set, fromset, toset;


  if (toSet)
  {
  ComboLinksToSet->GetText (tosetname, 50);
  if (strlen(tosetname)==0)
    {
    MessageBox (HWindow, "No setname specified!","Error", MB_OK);
    return;
    }
  NameEdit->GetText (setindex, 50);

  strcpy (fromsetname, getword (setindex, 1));

  index = atoi(getword (setindex, 2));

  fromset=FindSet(fromsetname);
  toset=FindSet(tosetname);

  fromunit = SetMember (fromset, index);
  for (i=0;i<toset->Length;i++)
      {
      tounit=SetMember (toset, i);
      unitlink=tounit->Links;
      while (unitlink)
      {
      	if (unitlink->From==fromunit)
      		{
		links_present=1;
      		break;
      		}
      	unitlink=unitlink->Next;
      }
      }
  if (links_present)
  {
  gr =  MaxWeightFromUnitToSet (fromunit, toset);
  sm =  MinWeightFromUnitToSet (fromunit, toset); 
  LinksWind = new LinksToSetWindow (GetApplication()->MainWindow, "Links");
  LinksWind->Attr.W=toset->ScreenMtrx[0]*(toset->SquareSize-1)+38;
  LinksWind->Attr.H=toset->ScreenMtrx[1]*(toset->SquareSize-1)+53;
  GetApplication()->MakeWindow (LinksWind);

  index=FindFirstEmptyLTS ();
  LinksToSetWinds[index]=LinksWind->HWindow;
  LinksToSetWindsSet[index]=toset;
  LinksToSetWindsUnit[index]=fromunit;
  linkstosetwinds_index++;
  set=toset;
  }
  }
  else
  {
  ComboLinksFromSet->GetText (fromsetname, 50);
  if (strlen(fromsetname)==0)
    {
    MessageBox (HWindow, "No setname specified!","Error", MB_OK);
    return;
    }
  NameEdit->GetText (setindex, 50);

  strcpy (tosetname, getword (setindex, 1));

  index = atoi(getword (setindex, 2));

  toset=FindSet (tosetname);
  fromset=FindSet (fromsetname);
  tounit = SetMember (toset, index);

  for (i=0;i<fromset->Length;i++)
      {
      fromunit=SetMember (fromset, i);
      unitlink=tounit->Links;
      while (unitlink)
      {
      	if (unitlink->From==fromunit)
      		{
		links_present=1;
      		break;
      		}
      	unitlink=unitlink->Next;
      }
      }
  if (links_present)
  {
  gr =  MaxWeightFromSetToUnit (tounit, fromset);
  sm =  MinWeightFromSetToUnit (tounit, fromset); 
  LinksWind = new LinksFromSetWindow (GetApplication()->MainWindow, "Links");
  LinksWind->Attr.W=fromset->ScreenMtrx[0]*(fromset->SquareSize-1)+38;
  LinksWind->Attr.H=fromset->ScreenMtrx[1]*(fromset->SquareSize-1)+53;
  GetApplication()->MakeWindow (LinksWind);

  index=FindFirstEmptyLFS ();
  LinksFromSetWinds[index]=LinksWind->HWindow;
  LinksFromSetWindsSet[index]=fromset;
  LinksFromSetWindsUnit[index]=tounit;
  linksfromsetwinds_index++;
  set=fromset;
  }
  }
  if (links_present)
  {
  lgth=set->Length;
  nr_col=set->ScreenMtrx [0];
  nr_lin=set->ScreenMtrx [1];

  edge_x=set->SquareSize;
  edge_y=set->SquareSize;

  v=5; q=0;

  ContextHandle = GetDC (LinksWind->HWindow);

  SelectObject (ContextHandle, hBrush1);
  Rectangle (ContextHandle,
    		0,
		0,
		set->ScreenMtrx[0]*set->SquareSize+300,
		set->ScreenMtrx[1]*set->SquareSize+100);

  for (j=0; j<nr_lin; j++)
	{
	h=5;
	for (k=0; k<nr_col && q<lgth; k++, q++)
	 {

	     SelectObject (ContextHandle, hBrush1);
             SelectObject (ContextHandle, GetStockObject (BLACK_PEN));
	     Rectangle (ContextHandle,
			     h,
			     v,
			     h + edge_x,
			     v + edge_x);
	     SelectObject (ContextHandle, GetStockObject (NULL_PEN));

	     if (toSet)
		tounit=SetMember (set, q);
	     else
		fromunit=SetMember (set, q);
	     unitlink=tounit->Links;
	     while (unitlink)
		   {
		   if (unitlink->From==fromunit)
		      {
		      curlink=unitlink;
		      break;
		      }
		   unitlink=unitlink->Next;
		   }
	     if (curlink)
	     {
	     if (curlink->Weight > 0.0)
                {
		x=floor (1000*(set->SquareSize -
			       set->SquareSize*curlink->Weight/gr)/2)/1000;
	     	SelectObject (ContextHandle, hBrush3);
		}
	     else
	     if (curlink->Weight < 0.0)
                {
		x=floor (1000*(set->SquareSize -
			       set->SquareSize*curlink->Weight/sm)/2)/1000;
		SelectObject (ContextHandle, hBrush2);
		}
	     else
		x=set->SquareSize/2+1;
	     if (x<edge_x/2)
	        {
	         Rectangle (ContextHandle,
			     h+x+1,
			     v+x+1,
			     h+edge_x - x,
			     v+edge_x - x);
	        }
	     }
	     h += edge_x -1;
	     }
	   v += edge_y -1;
	   }
	  ReleaseDC (HWindow, ContextHandle);
   }
}



void UnitWindow::OpenLinksToSetWindow(RTMessage)
{
 UnitWindow::OpenLinksWindow (1, HWindow);
}


void UnitWindow::OpenLinksFromSetWindow(RTMessage)
{
 UnitWindow::OpenLinksWindow (0, HWindow);
}


/******************************  Links window stuff ****************************/

LinkWindow::~LinkWindow()
 {
 linkcontrolwindow_open=0;
 }

void LinksToSetWindow::WMDestroy(RTMessage)
  {
   int i;
   for (i=0; i<20; i++)
    if (LinksToSetWinds[i]==HWindow)
     {
      LinksToSetWinds[i]=NULL;
      break;
     }
   }

void LinksFromSetWindow::WMDestroy(RTMessage)
  {
   int i;
   for (i=0; i<20; i++)
    if (LinksFromSetWinds[i]==HWindow)
     {
      LinksFromSetWinds[i]=NULL;
      break;
     }
   }

void PaintLinksWindow (int toSet, HDC PaintDC, HWND HWindow)
  {
  int nr_col, nr_lin, dist1, dist2, x, index, i, y_val, x_val, setlength;
  long j,k,l,q,h,v, edge_x, edge_y, lgth;
  float o, parvalue, gr, sm;
  UnitPtr fromunit, tounit;
  LinkPtr curlink, unitlink;
  SetPtr set, fromset, toset;

  if (toSet)
  {
  i=0;
  while (LinksToSetWinds[i])
       {
       if (LinksToSetWinds[i]==HWindow)
	   break;
       i++;
       }

  toset=LinksToSetWindsSet[i];
  fromunit=LinksToSetWindsUnit[i];

  lgth=toset->Length;
  nr_col=toset->ScreenMtrx [0];
  nr_lin=toset->ScreenMtrx [1];

  gr =  MaxWeightFromUnitToSet (fromunit, toset);
  sm =  MinWeightFromUnitToSet (fromunit, toset); 

  edge_x=toset->SquareSize;
  edge_y=toset->SquareSize;
  set=toset;

  SelectObject (PaintDC, hBrush1);
  Rectangle (PaintDC,
    		0,
		0,
		toset->ScreenMtrx[0]*toset->SquareSize+300,
		toset->ScreenMtrx[1]*toset->SquareSize+100);
  }
  else
  {
  i=0;
  while (LinksFromSetWinds[i])
       {
       if (LinksFromSetWinds[i]==HWindow)
	   break;
       i++;
       }

  fromset=LinksFromSetWindsSet[i];
  tounit=LinksFromSetWindsUnit[i];

  lgth=fromset->Length;
  nr_col=fromset->ScreenMtrx [0];
  nr_lin=fromset->ScreenMtrx [1];

  gr =  MaxWeightFromSetToUnit (tounit, fromset);
  sm =  MinWeightFromSetToUnit (tounit, fromset); 

  edge_x=fromset->SquareSize;
  edge_y=fromset->SquareSize;
  set=fromset;

  SelectObject (PaintDC, hBrush1);
  Rectangle (PaintDC,
    		0,
		0,
		fromset->ScreenMtrx[0]*fromset->SquareSize+300,
		fromset->ScreenMtrx[1]*fromset->SquareSize+100);
  }
  v=5; q=0;
  dist1=dist2=-1;
  for (j=0; j<nr_lin; j++)
	{
	h=5;
	for (k=0; k<nr_col && q<lgth; k++, q++)
	 {
	     SelectObject (PaintDC, hBrush1);
	     SelectObject (PaintDC, GetStockObject (BLACK_PEN));
	     Rectangle (PaintDC,
			     h,
			     v,
			     h + edge_x,
			     v + edge_x);
	     SelectObject (PaintDC, GetStockObject (NULL_PEN));

	     if (toSet)
		tounit=SetMember (set, q);
	     else
		fromunit=SetMember (set, q);
	     unitlink=tounit->Links;
	     while (unitlink)
		   {
		   if (unitlink->From==fromunit)
		      {
		      curlink=unitlink;
		      break;
		      }
		   unitlink=unitlink->Next;
		   }
	     if (curlink)
	     {
	     if (curlink->Weight > 0.0)
                {
		x=floor (1000*(set->SquareSize -
			       set->SquareSize*curlink->Weight/gr)/2)/1000;
		SelectObject (PaintDC, hBrush3);
		}
	     else
	     if (curlink->Weight < 0.0)
                {
		x=floor (1000*(set->SquareSize -
			       set->SquareSize*curlink->Weight/sm)/2)/1000;
		SelectObject (PaintDC, hBrush2);
		}
	     else
		x=set->SquareSize/2+1;


	     if (x<edge_x/2)
	        {
		 Rectangle (PaintDC,
			     h+x+1,
			     v+x+1,
			     h+edge_x - x,
			     v+edge_x - x);
	        }
	     }
	     h += edge_x + dist1;
	     }
	   v += edge_y + dist2;
	   }
  }


void LinksToSetWindow::Paint(HDC PaintDC, PAINTSTRUCT&)
{
  PaintLinksWindow (1, PaintDC, HWindow);
}

void LinksFromSetWindow::Paint(HDC PaintDC, PAINTSTRUCT&)
{
  PaintLinksWindow (0, PaintDC, HWindow);
}


void UpdateLinksWindow (int toSet, int w)
  {
  int nr_col, nr_lin, dist1, dist2, x, index, i, y_val, x_val, setlength;
  long j,k,l,q,h,v, edge_x, edge_y, lgth;
  float o, parvalue, gr, sm;
  HDC ContextHandle;
  HWND HWindow;
  LinkPtr curlink, unitlink;
  UnitPtr fromunit, tounit;
  SetPtr fromset, toset, set;

  if (toSet)
  {
  HWindow= LinksToSetWinds[w];
  toset=LinksToSetWindsSet[w];
  fromunit=LinksToSetWindsUnit[w];

  lgth=toset->Length;
  nr_col=toset->ScreenMtrx [0];
  nr_lin=toset->ScreenMtrx [1];

  gr =  MaxWeightFromUnitToSet (fromunit, toset);
  sm =  MinWeightFromUnitToSet (fromunit, toset); 

  edge_x=toset->SquareSize;
  edge_y=toset->SquareSize;
  set=toset;
  }
  else
  {
  HWindow= LinksFromSetWinds[w];
  fromset=LinksFromSetWindsSet[w];
  tounit=LinksFromSetWindsUnit[w];

  lgth=fromset->Length;
  nr_col=fromset->ScreenMtrx [0];
  nr_lin=fromset->ScreenMtrx [1];

  gr =  MaxWeightFromSetToUnit (tounit, fromset);
  sm =  MinWeightFromSetToUnit (tounit, fromset); 

  edge_x=fromset->SquareSize;
  edge_y=fromset->SquareSize;
  set=fromset;
  }
  v=5; q=0;
  dist1=dist2=-1;

  ContextHandle = GetDC (HWindow);

  SelectObject (ContextHandle, hBrush4);
  SelectObject (ContextHandle, GetStockObject (NULL_PEN));
  for (j=0; j<nr_lin; j++)
	{
	h=5;
	for (k=0; k<nr_col && q<lgth; k++, q++)
	 {

	     SelectObject (ContextHandle, hBrush1);
	     Rectangle (ContextHandle,
			     h+1,
			     v+1,
			     h + edge_x,
			     v + edge_x);
	     if (toSet)
		tounit=SetMember (set, q);
	     else
		fromunit=SetMember (set, q);
	     unitlink=tounit->Links;
	     while (unitlink)
		   {
		   if (unitlink->From==fromunit)
		      {
		      curlink=unitlink;
		      break;
		      }
		   unitlink=unitlink->Next;
		   }
	     if (curlink)
	     {
	     if (curlink->Weight > 0.0)
                {
		x=floor (1000*(set->SquareSize -
			       set->SquareSize*curlink->Weight/gr)/2)/1000;
	     	SelectObject (ContextHandle, hBrush3);
		}
	     else
	     if (curlink->Weight < 0.0)
                {
		x=floor (1000*(set->SquareSize -
			       set->SquareSize*curlink->Weight/sm)/2)/1000;
		SelectObject (ContextHandle, hBrush2);
		}
	     else
		x=set->SquareSize/2+1;


	     if (x<edge_x/2)
	        {
	         Rectangle (ContextHandle,
			     h+x+1,
			     v+x+1,
			     h+edge_x - x,
			     v+edge_x - x);
	        }
	     }
	     h += edge_x + dist1;
	     }
	   v += edge_y + dist2;
	   }
	  ReleaseDC (HWindow, ContextHandle);
  }



void UpdateLinksToSetWindow(int i)
{
  UpdateLinksWindow (1, i);
}

void UpdateLinksFromSetWindow(int i)
{
  UpdateLinksWindow (0, i);
}


void LinksToSetWindow::WMMouseMoveNC (RTMessage Msg)
  {
    if(Msg.LP.Lo) 
      {
       u_index=-1000;
       if (U_Wind){DestroyWindow (U_Wind); U_Wind=NULL;}
      }
  } 

void LinksToSetWindow::WMLButtonDown (RTMessage Msg)
  {
   char *setname, strin [20];
   UnitPtr fromunit, tounit;
   LinkPtr unitlink, link;
   SetPtr toset;
   int unit_index, cursor_column, cursor_row, edge_x, edge_y, i,
       Idx, l, dist1, dist2, nr_col,nr_lin;
   long DBLCLKTime2=0;
   PTWindow LinkWind;

   i=0;
   while (LinksToSetWinds[i])
       {
       if (LinksToSetWinds[i]==HWindow)
	   break;
       i++;
       }

   toset=LinksToSetWindsSet[i];
   fromunit=LinksToSetWindsUnit[i];

   nr_col=toset->ScreenMtrx [0];
   edge_x=toset->SquareSize;
   edge_y=toset->SquareSize;

   cursor_column=(Msg.LP.Lo - 5)/(edge_x-1);
   cursor_row=(Msg.LP.Hi - 5)/(edge_y-1);

   unit_index=nr_col*cursor_row + cursor_column;
   tounit=SetMember (toset, unit_index);

   unitlink=tounit->Links;
   while (unitlink)
   {
     if (unitlink->From==fromunit)
      {
      link=unitlink;
      break;
      }
     unitlink=unitlink->Next;
   }
   if (link)
   {
   DBLCLKTime2=GetMessageTime();
   if ((DBLCLKTime2 - DBLCLKTime)<500)
      {
      if (!linkcontrolwindow_open)
      {
      GetApplication()->MakeWindow (new LinkWindow (this, "Link control"));
      sprintf (strin, "%s %d", link->From->Set->Name, link->From->Index);
      FromEdit->SetText (strin);
      sprintf (strin, "%s %d", link->To->Set->Name, link->To->Index);
      ToEdit->SetText (strin);
      linkcontrolwindow_open=1;
      }
      else
       MessageBox (HWindow, "You can have only one 'Link control' window open at any one time. Close the open 'Link control' window first if you want to open a new one!","Error", MB_OK);
      }
   DBLCLKTime=DBLCLKTime2;
   }
   }



void LinksToSetWindow::WMMouseMove (RTMessage Msg)
  {
   char *setname, strin [20];
   UnitPtr fromunit, tounit;
   LinkPtr unitlink, link=NULL;
   SetPtr toset;
   int unit_index, cursor_column, cursor_row, edge_x, edge_y, i=0,
       Idx, l, dist1, dist2, nr_col,nr_lin;
   PTWindow LinkWind;

   if (Msg.WParam==MK_LBUTTON)
   {
   while (LinksToSetWinds[i])
       {
       if (LinksToSetWinds[i]==HWindow)
	   break;
       i++;
       }

   toset=LinksToSetWindsSet[i];
   fromunit=LinksToSetWindsUnit[i];

   nr_col=toset->ScreenMtrx [0];
   nr_lin=toset->ScreenMtrx [1];

   edge_x=toset->SquareSize;
   edge_y=toset->SquareSize;
   if ((Msg.LP.Lo <= 5)||
       (Msg.LP.Lo >= (5+nr_col*(edge_x-1)))||
       (Msg.LP.Hi <= 5)||
       (Msg.LP.Hi >= (5+nr_lin*(edge_x-1))))
      {
      u_index=-1000;
      if (U_Wind){DestroyWindow (U_Wind); U_Wind=NULL;}
      }
   else
   {
   cursor_column=(Msg.LP.Lo - 5)/(edge_x-1);
   cursor_row=(Msg.LP.Hi - 5)/(edge_y-1);

   unit_index=nr_col*cursor_row + cursor_column;
   tounit=SetMember (toset, unit_index);

   unitlink=tounit->Links;
   while (unitlink)
   {
     if (unitlink->From==fromunit)
      {
      link=unitlink;
      break;
      }
     unitlink=unitlink->Next;
   }
   if (link && unit_index < toset->Length && unit_index >=0 && unit_index!=u_index)
      {
      LinkWind=new LinkWindow2 (this, "Link");
      LinkWind->Attr.X=Msg.LP.Lo + this -> Attr.X + edge_x + 10;
      LinkWind->Attr.Y=Msg.LP.Hi + this -> Attr.Y - LinkWind->Attr.H - 10;
      if (LinkWind->Attr.Y < 0)
	  LinkWind->Attr.Y=Msg.LP.Hi + this -> Attr.Y + edge_y + 10;

      GetApplication()->MakeWindow (LinkWind);
      if (U_Wind) DestroyWindow (U_Wind);
      U_Wind=LinkWind->HWindow;
      sprintf (strin, "%10.4f", link->Weight);
      WeightTStatic->SetText (strin);
      sprintf (strin, "%10.4f", link->Free1);
      LinkFree1TStatic->SetText (strin);
      sprintf (strin, "%10.4f", link->Free2);
      LinkFree2TStatic->SetText (strin);
      sprintf (strin, "%10.4f", link->Free3);
      LinkFree3TStatic->SetText (strin);
      sprintf (strin, "%s %d", fromunit->Set->Name, fromunit->Index);
      FromTStatic->SetText (strin);
      sprintf (strin, "%s %d", tounit->Set->Name, tounit->Index);
      ToTStatic->SetText (strin);
      u_index=unit_index;
      }
   }
   }
   }


void LinksFromSetWindow::WMMouseMoveNC (RTMessage Msg)
  {
    if(Msg.LP.Lo) 
      {
       u_index=-1000;
       if (U_Wind){DestroyWindow (U_Wind); U_Wind=NULL;}
      }
  } 

void LinksFromSetWindow::WMLButtonDown (RTMessage Msg)
  {
   char *setname, strin [20];
   UnitPtr fromunit, tounit;
   LinkPtr unitlink, link;
   SetPtr toset,fromset;
   int unit_index, cursor_column, cursor_row, edge_x, edge_y, i,
       Idx, l, dist1, dist2, nr_col,nr_lin;
   long DBLCLKTime2=0;
   PTWindow LinkWind;

   i=0;
   while (LinksFromSetWinds[i])
       {
       if (LinksFromSetWinds[i]==HWindow)
	   break;
       i++;
       }

   fromset=LinksFromSetWindsSet[i];
   tounit=LinksFromSetWindsUnit[i];

   nr_col=fromset->ScreenMtrx [0];
   edge_x=fromset->SquareSize;
   edge_y=fromset->SquareSize;

   cursor_column=(Msg.LP.Lo - 5)/(edge_x-1);
   cursor_row=(Msg.LP.Hi - 5)/(edge_y-1);

   unit_index=nr_col*cursor_row + cursor_column;
   fromunit=SetMember (fromset, unit_index);

   unitlink=tounit->Links;
   while (unitlink)
    {
     if (unitlink->From==fromunit)
     {
     link=unitlink;
     break;
     }
     unitlink=unitlink->Next;
    }

   if (link)
   {
   DBLCLKTime2=GetMessageTime();
   if ((DBLCLKTime2 - DBLCLKTime)<500)
      {
      if (!linkcontrolwindow_open)
      {
      GetApplication()->MakeWindow (new LinkWindow (this, "Link control"));
      sprintf (strin, "%s %d", link->From->Set->Name, link->From->Index);
      FromEdit->SetText (strin);
      sprintf (strin, "%s %d", link->To->Set->Name, link->To->Index);
      ToEdit->SetText (strin);
      linkcontrolwindow_open=1;
      }
      else
       MessageBox (HWindow, "You can have only one 'Link control' window open at any one time. Close the open 'Link control' window first if you want to open a new one!","Error", MB_OK);
      }
   DBLCLKTime=DBLCLKTime2;
   }
   }



void LinksFromSetWindow::WMMouseMove (RTMessage Msg)
  {
   char *setname, strin [20];
   UnitPtr fromunit, tounit;
   LinkPtr unitlink, link=NULL;
   SetPtr fromset, toset;
   int unit_index, cursor_column, cursor_row, edge_x, edge_y, i=0,
       Idx, l, dist1, dist2, nr_col,nr_lin;
   PTWindow LinkWind;

   if (Msg.WParam==MK_LBUTTON)
   {
   while (LinksFromSetWinds[i])
       {
       if (LinksFromSetWinds[i]==HWindow)
	   break;
       i++;
       }
   fromset=LinksFromSetWindsSet[i];
   tounit=LinksFromSetWindsUnit[i];

   nr_col=fromset->ScreenMtrx [0];
   nr_lin=fromset->ScreenMtrx [1];

   edge_x=fromset->SquareSize;
   edge_y=fromset->SquareSize;

   if ((Msg.LP.Lo <= 5)||
       (Msg.LP.Lo >= (5+nr_col*(edge_x-1)))||
       (Msg.LP.Hi <= 5)||
       (Msg.LP.Hi >= (5+nr_lin*(edge_x-1))))
      {
      u_index=-1000;
      if (U_Wind){DestroyWindow (U_Wind); U_Wind=NULL;}
      }
   else
   {
   cursor_column=(Msg.LP.Lo - 5)/(edge_x-1);
   cursor_row=(Msg.LP.Hi - 5)/(edge_y-1);

   unit_index=nr_col*cursor_row + cursor_column;
   fromunit=SetMember (fromset, unit_index);

   unitlink=tounit->Links;
   while (unitlink)
   {
     if (unitlink->From==fromunit)
      {
      link=unitlink;
      break;
      }
     unitlink=unitlink->Next;
   }
   if (link && unit_index < fromset->Length && unit_index >=0 && unit_index!=u_index)
      {
      LinkWind=new LinkWindow2 (this, "Link");
      LinkWind->Attr.X=Msg.LP.Lo + this -> Attr.X + edge_x + 10;
      LinkWind->Attr.Y=Msg.LP.Hi + this -> Attr.Y - LinkWind->Attr.H - 10;
      if (LinkWind->Attr.Y < 0)
	  LinkWind->Attr.Y=Msg.LP.Hi + this -> Attr.Y + edge_y + 10;

      GetApplication()->MakeWindow (LinkWind);
      if (U_Wind) DestroyWindow (U_Wind);
      U_Wind=LinkWind->HWindow;
      sprintf (strin, "%10.4f", link->Weight);
      WeightTStatic->SetText (strin);
      sprintf (strin, "%10.4f", link->Free1);
      LinkFree1TStatic->SetText (strin);
      sprintf (strin, "%10.4f", link->Free2);
      LinkFree2TStatic->SetText (strin);
      sprintf (strin, "%10.4f", link->Free3);
      LinkFree3TStatic->SetText (strin);
      sprintf (strin, "%s %d", fromunit->Set->Name, fromunit->Index);
      FromTStatic->SetText (strin);
      sprintf (strin, "%s %d", tounit->Set->Name, tounit->Index);
      ToTStatic->SetText (strin);
      u_index=unit_index;
      }
   }
   }
   }




/************************  Set window stuff ***************************/


void SetWindow::WMDestroy(RTMessage)
  {
   int i;
   for (i=0; i<currentset; i++)
    if (SetWinds[i]==HWindow)
     {
      SetArray[i]->SetHD=NULL;
      SetWinds[i]=NULL;
      break;
     }
   }

void ShowUnits(SetPtr set, HDC ContextHandle, HBRUSH hBrush1,
					      HBRUSH hBrush2, HBRUSH hBrush3)
  {
  int dist1, dist2, x;
  int j,k,q,h,v, edge_x, edge_y, lgth;

  float o;

  edge_x=set->SquareSize;
  edge_y=set->SquareSize;

  v=5; q=0;

  dist1=dist2=-1;

  lgth=set->Length;
  for (j=0; j<set->ScreenMtrx[1]; j++)
	{
	h=5;
	for (k=0; k<set->ScreenMtrx[0] && q<lgth; k++, q++)
	 {

	  SelectObject (ContextHandle, hBrush1);
          SelectObject (ContextHandle, GetStockObject (BLACK_PEN));
	  Rectangle (ContextHandle,
			     h,
			     v,
			     h + edge_x,
			     v + edge_x);
	  SelectObject (ContextHandle, GetStockObject (NULL_PEN));
	  o=set->Members[q]->Output;
	  if (o < 0.0)
	     {
	     if (o < -1.0)
		 o=1.0;
	     SelectObject (ContextHandle, hBrush2);
	     }
	  else
	     {  
	     SelectObject (ContextHandle, hBrush3);
	     if (o > 1.0)
		{
		 o=1.0;
		}
	     }
	  x=floor(1000.0*(edge_x - edge_x*fabs(o))/2.0)/1000;
	  if (x<edge_x/2)
	     {
	      Rectangle (ContextHandle,
			     h+x+1,
			     v+x+1,
			     h+edge_x - x,
			     v+edge_x - x);
	     }
	  h += edge_x + dist1;
	  }
	v += edge_y + dist2;
	}
}


void ShowUnitsOutputSq(SetPtr set)
 {
  int dist1, dist2, x;
  int j,k,q,h,v, edge_x, edge_y, lgth;
  
  HDC ContextHandle;
  HWND SetHWND;
  float o;

  if (set->SetHD != NULL)
  {
  SetHWND = set->SetHD;
  ContextHandle = GetDC (SetHWND);

//  SelectObject (ContextHandle, hBrush4);
  SelectObject (ContextHandle, GetStockObject (NULL_PEN));

  ShowUnits (set, ContextHandle, hBrush1, hBrush2, hBrush3);
  ReleaseDC (SetHWND, ContextHandle);
  }
}


void SetWindow::Paint(HDC PaintDC, PAINTSTRUCT&)
  {
    int Idx=0, dist1, dist2, x;
    int j,k,l,q,h,v, edge_x, edge_y, lgth;
    SetPtr set;
    HDC ContextHandle;
    float o;

    for (l=0; l<currentset; l++)
       if (SetArray[l]->SetHD==HWindow)
	   {
           Idx = l;
           break;
	   }

    set=SetArray[Idx];
    if (set->SetHD != NULL)
    {
    ContextHandle = PaintDC;
    SelectObject (PaintDC, hBrush1);
    Rectangle (ContextHandle,
    		0,
		0,
		set->ScreenMtrx[0]*set->SquareSize+300,
		set->ScreenMtrx[1]*set->SquareSize+100);

    ShowUnits (set, ContextHandle, hBrush1, hBrush2, hBrush3);
    }
}

SetPtr DetermineSet (HWND HWindow)
 {
 int l;
 for (l=0; l<currentset; l++)
    if (SetWinds[l]==HWindow)
     {
      return (SetArray[l]);
     }
 return NULL;
 }

int OutsideSetSquare (SetPtr set, RTMessage Msg)
   {
   if ((Msg.LP.Lo <= 5)||
       (Msg.LP.Lo >= (5+set->ScreenMtrx [0]*(set->SquareSize-1)))||
       (Msg.LP.Hi <= 5)||
       (Msg.LP.Hi >= (5+set->ScreenMtrx [1]*(set->SquareSize-1))))
      return 1;
   else
      return 0;
   }

void SetWindow::WMMouseMoveNC (RTMessage Msg)
  {
    if(Msg.LP.Lo) 
      {
      u_index=-1000;
      if (U_Wind){DestroyWindow (U_Wind); U_Wind=NULL;}
      }      
  }


void SetWindow::WMLButtonDown (RTMessage Msg)
  {
   char name [20];
   UnitPtr unit;
   SetPtr set;
   int unit_index, cursor_column, cursor_row;
   long DBLCLKTime2=0;

   set=DetermineSet(HWindow);
   if (OutsideSetSquare (set, Msg)) return;
   cursor_column=(Msg.LP.Lo - 5)/(set->SquareSize-1);
   cursor_row=(Msg.LP.Hi - 5)/(set->SquareSize-1);

   unit_index=set->ScreenMtrx [0]*cursor_row + cursor_column;
   unit=SetMember (set, unit_index);

   if (Msg.WParam==MK_LBUTTON + MK_SHIFT)
   {
    if (unit->Output>0.5)
       unit->Output=0.0;
    else if (unit->Output<0.5)
       unit->Output=1.0;
    ShowUnitsOutputSq (set);
    }
   else
   {
   DBLCLKTime2=GetMessageTime();
   if ((DBLCLKTime2 - DBLCLKTime)<500)
      {
      if (!unitcontrolwindow_open)
      {
      GetApplication()->MakeWindow (new UnitWindow (this, "Unit control"));
      sprintf (name, "%s %d", set->Name, unit->Index);
      NameEdit->SetText (name);
      sprintf (name, "Name:  %s", unit->Name);
      TStaticName->SetText (name);
      unitcontrolwindow_open=1;
      }
      else
       MessageBox (HWindow, "You can have only one 'Unit control' window open at any one time. Close the open 'Unit control' window first if you want to open a new one!","Error", MB_OK);
      }
   DBLCLKTime=DBLCLKTime2;
   }
   }


void SetWindow::WMRButtonDown (RTMessage Msg)
  {
   char name [20];
   UnitPtr unit;
   SetPtr set;
   int unit_index, cursor_column, cursor_row;
   long DBLCLKTime2=0;

   set=DetermineSet(HWindow);
   if (OutsideSetSquare (set, Msg)) return;
   cursor_column=(Msg.LP.Lo - 5)/(set->SquareSize-1);
   cursor_row=(Msg.LP.Hi - 5)/(set->SquareSize-1);

   unit_index=set->ScreenMtrx [0]*cursor_row + cursor_column;
   unit=SetMember (set, unit_index);

   if (Msg.WParam==MK_RBUTTON + MK_SHIFT)
    {
    if (unit->Output<-0.5)
       unit->Output=0.0;
    else if (unit->Output>-0.5)
       unit->Output=-1.0;
    ShowUnitsOutputSq (set);
    }
   else
   {
   DBLCLKTime2=GetMessageTime();
   if ((DBLCLKTime2 - DBLCLKTime)<500)
      {
      if (!setcontrolwindow_open)
      {
      GetApplication()->MakeWindow (new SetControlWindow (this, "Set control"));
      sprintf (name, "%s", set->Name);
      SetNameEdit->SetText (name);
      setcontrolwindow_open=1;
      }
      else
       MessageBox (HWindow, "You can have only one 'Set control' window open at any one time. Close the open 'Set control' window first if you want to open a new one!","Error", MB_OK);
      }
   DBLCLKTime=DBLCLKTime2;
   }
   }


void SetWindow::WMMouseMove (RTMessage Msg)
  {
   char strin [20];
   UnitPtr unit;
   SetPtr set;
   int unit_index, cursor_column, cursor_row;

   set=DetermineSet(HWindow);
   if (OutsideSetSquare (set, Msg))
      {
      u_index=-1000;
      if (U_Wind){DestroyWindow (U_Wind); U_Wind=NULL;}
      return;
      }
   cursor_column=(Msg.LP.Lo - 5)/(set->SquareSize-1);
   cursor_row=(Msg.LP.Hi - 5)/(set->SquareSize-1);

   unit_index=set->ScreenMtrx [0]*cursor_row + cursor_column;
   unit=SetMember (set, unit_index);

   if (Msg.WParam==MK_LBUTTON + MK_SHIFT)
   {
   if (unit_index < set->Length && unit_index >=0 && unit_index!=u_index)
      {
      if (unit->Output>0.5)
         unit->Output=0.0;
      else if (unit->Output<0.5)
         unit->Output=1.0;
      ShowUnitsOutputSq (set);
      u_index=unit_index;
      }
    }
   else if (Msg.WParam==MK_RBUTTON + MK_SHIFT)
   {
   if (unit_index < set->Length && unit_index >=0 && unit_index!=u_index)
      {
      if (unit->Output<-0.5)
         unit->Output=0.0;
      else if (unit->Output>-0.5)
	 unit->Output=-1.0;
      ShowUnitsOutputSq (set);
      u_index=unit_index;
      }
    }
   else
   if (Msg.WParam==MK_LBUTTON)
   {
   if (unit_index < set->Length && unit_index >=0 && unit_index!=u_index)
      {
      UnitWind=new UnitWindow2 (this, "Unit");
      UnitWind->Attr.X=Msg.LP.Lo + this -> Attr.X + set->SquareSize + 10;
      UnitWind->Attr.Y=Msg.LP.Hi + this -> Attr.Y - UnitWind->Attr.H - 10;
      if (UnitWind->Attr.Y < 0)
	 UnitWind->Attr.Y=Msg.LP.Hi + this -> Attr.Y + set->SquareSize + 10;

      GetApplication()->MakeWindow (UnitWind);
      if (U_Wind) {DestroyWindow (U_Wind); U_Wind=NULL;}
      U_Wind=UnitWind->HWindow;
      UnitWindow2Unit=unit;
      sprintf (strin, "%10.4f", unit->Output);
      OutputTStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Netinput);
      NetinputTStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Free1);
      Free1TStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Free2);
      Free2TStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Free3);
      Free3TStatic->SetText (strin);
      sprintf (strin, "%d", unit->Index);
      IndexTStatic->SetText (strin);
      sprintf (strin, "%s", unit->Name);
      NameTStatic->SetText (strin);
      u_index=unit_index;
      }
   }
   }
   


/************************  SetControl window stuff ***************************/

SetControlWindow::~SetControlWindow()
 {
 setcontrolwindow_open=0;
 }

void SetControlWindow::PrintPatternToFile()
  {
  int i,j;
  char setname[20], setname2[20];
  SetPtr set;
  FILE *f;
  char filename[50];

  if (filewindow_open) 
  {
  SetNameEdit->GetText (setname, 19);
  set=FindSet (setname);
  EditFiles->GetText (filename, 49);
  if (strlen (filename)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return;
   }
  else
  if (FindFile (filename)<10)
  {
  f=file_array [FindFile(filename)];
  for (i=0; i<set->Length; i++)
      fprintf (f,"%7.5f ",set->Members[i]->Output);
  fprintf (f,"\n");
  }
  else
   {
    MessageBox (HWindow, "File is not open!","Error", MB_OK);
    return;
    }
  }
  else
   {
    MessageBox (HWindow, "No filename specified. Push the button 'Files'!","Error", MB_OK);
    return;
    }
  }

void SetControlWindow::ReadPatternFromFile ()
  {
  int i,j,s;
  float nr;
  char setname[20], setname2[20];
  SetPtr set;
  FILE *f;
  char filename[50];
  int ch;

  if (filewindow_open) 
  {
  SetNameEdit->GetText (setname, 19);
  set=FindSet (setname);
  EditFiles->GetText (filename, 49);
  if (strlen (filename)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return;
   }
  else
  if (FindFile (filename)<10)
  {
  f=file_array [FindFile(filename)];
  for (s=0; s<set->Length; s++)
      {
      fscanf (f, "%f ", &nr);
      PutUnitParam (SetMember (set, s), OUTPUT, nr);
      }
  ch=getc(f);
  if (ch == EOF)
     fseek (f, 0L, 0L);
  else
  if (ch != '\n')
     ungetc(ch, f);
  if (set->SetHD != NULL)
     ShowUnitsOutputSq (set) ;
  }
  else
   {
    MessageBox (HWindow, "File is not open!","Error", MB_OK);
    return;
    }
  }
  else
   {
    MessageBox (HWindow, "No filename specified. Push button 'Files'!","Error", MB_OK);
    return;
    }
  }

void SetControlWindow::BindFeatureToFile ()
{
char filename[55], setname [20], strin[11];
SetPtr set;
int n, file_index;
FILE *f;

if (filewindow_open)
{
EditFiles->GetText (filename, 50);
SetNameEdit->GetText (setname, 19);
set=FindSet (setname);
n = ComboSetFeatureNames->GetSelIndex();
ComboSetFeatureNames->GetText(strin, 10);
if (strlen(strin)==0)
   {
    MessageBox (HWindow, "Select a feature!","Error", MB_OK);
    return;
    }
else
if (strlen (filename)==0)
   {
    MessageBox (HWindow, "No filename specified!","Error", MB_OK);
    return;
    }
else
if (FindFile (filename)<10)
{
file_index=FindFile(filename);
// f=file_array [file_index];
if (read_file[file_index]==1)
   {
    read_file_param[file_index]=n;
    file_set_array[file_index]=set;
   }
else if (read_file[file_index]==0)
   {
    write_file_array [FindFirstEmptySlotWriteFile(filename)]
		     [FindFile(filename)]=n+1;
    file_set_array [file_index]=set;
   }
}
else
{
    MessageBox (HWindow, "File is not open!","Error", MB_OK);
    return;
}
}
else
{
    MessageBox (HWindow, "No filename specified. Push button 'Files'!","Error", MB_OK);
    return;
}
}

/*************************  Sets window stuff **********************************/


void OpenASetWindow (int i, SetPtr set, PTWindow SetWind)
 {
    int Idx, dist1, dist2;
    int j,k,q,h,v, edge_x,edge_y, lgth;
    HDC ContextHandle;
    HBRUSH hBrush;
    char ss[20];
    edge_x=set->SquareSize;
    edge_y=set->SquareSize;

    v=5; q=0;
    dist1=dist2=-1;
    SetWinds[i]=SetWind->HWindow;

    ContextHandle = GetDC (SetWind->HWindow);
    set->SetHD=SetWind->HWindow;
    SelectObject (ContextHandle, hBrush1);
    Rectangle (ContextHandle,
		0,
		0,
		set->ScreenMtrx[0]*set->SquareSize+300,
		set->ScreenMtrx[1]*set->SquareSize+100);

    lgth=set->Length;
    for (j=0; j<set->ScreenMtrx[1]; j++)
	{
	h=5;
	for (k=0; k<set->ScreenMtrx[0] && q<lgth; k++, q++)
		  {
		  Rectangle (ContextHandle,
			     h+1,
			     v+1,
			     h + edge_x,
			     v + edge_x);
		  h += edge_x + dist1;
		  }
	v += edge_y + dist2;
	}
    ReleaseDC (SetWind->HWindow, ContextHandle);
    }

void SetsWindow::OpenSetWindow (RTMessage Msg)
{
  int Idx, i;
  SetPtr set;

  if (Msg.LP.Hi == LBN_DBLCLK)
    {
    Idx = SetsListBox->GetSelIndex();
    if (Idx < currentset)
       {
       set=SetArray [Idx];
       if ((SetWinds[Idx]!=set->SetHD) || (SetWinds[Idx]==NULL && set->SetHD==NULL))
	  {
	  SetWind = new SetWindow (GetApplication()->MainWindow, set->Name);
       	  SetWind->Attr.W=set->ScreenMtrx[0]*(set->SquareSize-1)+38;
       	  SetWind->Attr.H=set->ScreenMtrx[1]*(set->SquareSize-1)+53;
	  GetApplication()->MakeWindow (SetWind);
	  OpenASetWindow (Idx, set, SetWind);
	  }
       }
    else
       for (i=0; i< currentset; i++)
           {
            set=SetArray [i];
	    if ((SetWinds[i]!=set->SetHD) || (SetWinds[i]==NULL && set->SetHD==NULL))
          	{
	    	SetWind = new SetWindow (GetApplication()->MainWindow, set->Name);
	    	SetWind->Attr.W=set->ScreenMtrx[0]*(set->SquareSize-1)+38;
	    	SetWind->Attr.H=set->ScreenMtrx[1]*(set->SquareSize-1)+53;
	    	GetApplication()->MakeWindow (SetWind);
		OpenASetWindow (i, set, SetWind);
            	}
	   }
    }
 }



/****************************  Update of windows, files during runs ************************/

void UpdateUnitWindow2()
    {
      char strin[40];
      UnitPtr unit=UnitWindow2Unit;
      if (U_Wind)
      {
      sprintf (strin, "%10.4f", unit->Netinput);
      NetinputTStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Output);
      OutputTStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Free1);
      Free1TStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Free2);
      Free2TStatic->SetText (strin);
      sprintf (strin, "%10.4f", unit->Free3);
      Free3TStatic->SetText (strin);
      }
    }

void UpdateSetWindows()
    {
     int i;
     for (i=0; i<currentset; i++)
	 if (SetArray [i]->SetHD != NULL)
            ShowUnitsOutputSq (SetArray [i]) ;
    }

void UpdateLinkWindows()
    {
     int i;
     for (i=0;i<linksfromsetwinds_index;i++)
      if (LinksFromSetWinds[i])
       {
       UpdateLinksFromSetWindow (i);
       i++;
       }
     for (i=0;i<linkstosetwinds_index;i++)
      if (LinksToSetWinds[i])
       {
       UpdateLinksToSetWindow (i);
       i++;
       }
    }

void ReadFiles()
  {
  int i=0, s=0;
  SetPtr set;
  int param;
  float nr;
  int ch;

  for (i=0; i<10; i++)
    if ((file_array[i]!=NULL) && (read_file[i]==1))
	  if (file_set_array[i]!=NULL)
		{
		set=file_set_array[i];
		param= read_file_param[i];
		for (s=0; s<set->Length; s++)
	      		{
	       		fscanf (file_array[i], "%f ", &nr);
	       		PutUnitParam (SetMember (set, s), param, nr);
	      		}
	  	ch=getc(file_array[i]);
	 	if (ch == EOF)
	     	   fseek (file_array[i], 0L, 0L);
		else
	           if (ch != '\n')
		ungetc(ch, file_array[i]);
		}
   }


void WriteFiles()
  {
  int i=0, j=0, k=0, s=0;
  SetPtr set;
  int param;
  float nr;
  int ch;

  for (i=0; i<10; i++)
    if ((file_array[i]!=NULL) && (read_file[i]==0))
       {
	  j=0;
	  while ((!file_set_array[i]) && file_parameter_pointers_array[j][i]!=0)
		{
		fprintf (file_array[i],
		   "%7.5f ",*file_parameter_pointers_array[j][i]);
		j++;
		}
	  k=0;
	  while (write_file_array[k][i]!=0)
		{
		set=file_set_array[i];
		for (s=0; s<set->Length; s++)
	      		{
			fprintf (file_array[i],
			   "%7.5f ",GetUnitParam (SetMember (set, s),
				    write_file_array[k][i]-1));
			}
		k++;
		}
	  if ((j>0)||(k>0))
	     fprintf (file_array[i], "\n");
       }
   }


/****************************  Run window ************************/


void DoRestOfRun (char *cycl, long cycle, char *strin)
    {
	int i;
	if (CyclesWind)
	{
	sprintf (cycl, "%ld", cycle);
	AStaticCycles->SetText (cycl);
	sprintf (cycl, "%ld", AllCycles);
	AStaticAllCycles->SetText (cycl);
	}        
	SetMessage (Message);
	if (ParWind)
	{
	i=0;
	while (up_installed[i])
	         {
		 sprintf (strin, "%10.3f", *up[i]);
		 parameters [i]->SetText (strin);
		 i++;
		 }
	}
        WriteFiles();
	DrawIntoPlots ();
	UpdateUnitWindow2();
	UpdateSetWindows ();
	UpdateLinkWindows ();
    }

void RunWindow::DoRun(RTMessage)
{
int i,k;
char cyc[30], cycl [30], strin[15], Mess[30];
EditRun->GetText(cyc, 20);
Cycles= atol (cyc);

for (cycle=1; cycle<=Cycles; cycle++,AllCycles++)
       {
        ReadFiles();
	Run();
	DoRestOfRun (cycl, cycle, strin);
        }
}

void RunWindow::DoRunOne(RTMessage)
	{
	int i;
	char cycl [30], strin[15];

	ReadFiles();
	Run();
	DoRestOfRun (cycl, 1, strin);
	AllCycles++;
	}


/*******************************  Main window *****************************/


void TCS::InitMainWindow()
{
  int i=0;
  hBrush1 = (HBRUSH)GetStockObject (LTGRAY_BRUSH);
  hBrush2 = CreateSolidBrush (RGB (0,0,255));
  hBrush3 = CreateSolidBrush (RGB (255,0,0));
  hBrush4 = CreateSolidBrush (RGB (255,0,255));
  hPen1 =   CreatePen (PS_SOLID, 1, RGB (255,0,0));
  MainWindow = new TcsWindow(NULL, Name);
  for (i=0; i<30; i++)
    {
    SetWinds[i]=NULL;
    LinksToSetWinds[i]=NULL;
    LinksFromSetWinds[i]=NULL;
    }
  Build();
 }


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TCS TCSMain  ("TCS", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
  TCSMain.Run();
  return TCSMain.Status;
}


