/* Author: David B. Rosen
   Copyright (C) 1993 by the author and/or University of Nevada.
   All rights reserved. */

#include "stdlib.h"

#include "const.h" /* define const if necessary */
#include "do.h"
#include "create.h"

#include "rank.h"

/* value-index type: */
typedef struct {float value; long index;} viT;

static int compare(a, b)
     const viT *a;
     const viT *b;
{
  if (a->value < b->value)
     return -1;
  else if (a->value > b->value)
    return 1;
  else
    return 0;
}

void rankF(n, array, rank)
     long n;
     const float *array;  /*  array[n]  */
     float *rank;  /* rank[n]  */
{
  viT *vi;

  /* create value-index array: */
  ncreate(&vi, n);
  do0L(i, n,
      vi[i].value = array[i];
      vi[i].index = i;
  );

  /* sort the v i array: */
  qsort(vi, n, sizeof(vi[0]), 
	(int (*)proto((const void *, const void *)))compare);

  /* write the rank: */
  { register long iFirst=0;
    while (iFirst < n) /* loop over groups of consecutive tied values */
    { register long iLast=iFirst;
      while(iLast+1 < n) /* loop over tied values in this group */
      { if (vi[iLast+1].value != vi[iFirst].value) break;
	iLast++;
      }
      { register float thisRank=.5*(iLast+iFirst+2);
	doup(i, iFirst, iLast, rank[vi[i].index] = thisRank;  );
      }
      iFirst=iLast+1;
    }

    destroy(&vi);
  }
}
