//----------------------------------------------------------------------
// Program: state.h  -  State Class Header
//
// Author : Joey Rogers
// Date   : July 30, 1993

// Purpose: This is the header for the state class.
//----------------------------------------------------------------------


#ifndef STATE
#define STATE

#include<stdio.h>
#include<iostream.h>
#include<iomanip.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include"neudl.h"
#include"bp.h"


#define MAX_SYMBOLS 50
#define NOT_FOUND -1
#define OUT_RANGE 3

#define SCALAR 0
#define ARRAY 1
#define INT 0
#define FLOAT 1
#define MAX_ENVIRONMENT_STRINGS 10

class State
	{
	private:
		struct SYMBOL_TABLE
			{
			char *name;
			int size;
			char *size_str;
			void *data;
			int type;
			int structure;
			};

		SYMBOL_TABLE *Table;
		int sym_count;
		BPNET *net;
		Data_Class *data[MAX_DATA_LISTS];
		char *Env_Str[MAX_ENVIRONMENT_STRINGS];
	public:
		State( void );
		void Declare_Variable(char name[], int type, char *size=NULL);
		void Declare_Allocate_Variable(char name[], int type,
					       double init_val, int size=-1);
		void Allocate_Variable( int var_id,int size,double init_val=0);

		char *Get_Size_Expression( int var_id ) 
			{ return Table[var_id].size_str; };
		int Set_Value(char name[], double value, int pos=0);
		int Set_Value(int var_id, double value, int pos=0);
		int Get_Value(char name[], double &value, int pos=0);
		int Get_Value(int var_id, double &value, int pos=0);
		int Get_Size( int var_id );
		int Get_Size( char name[] )
			{return Get_Size(Get_Variable_ID(name));};
		int Get_Type( int var_id ) {return Table[var_id].type;};
		int Get_Structure( int var_id ) 
		  {return Table[var_id].structure;};
		BPNET *Get_BP_Network( void ){return net;};
		Data_Class *Get_Data( int id ) 
			{ 
			if (id<0 || id>MAX_DATA_LISTS)
			    {
			    cout << "Data Id out of Range\n";
			    exit(0);
			    }
			return data[id];
			};
		void Set_Data( int id, Data_Class *d ) 
			{
			if (id<0 || id>MAX_DATA_LISTS) 
			    {
			    cout << "Data Id out of Range\n";
			    exit(0);
			    };
                        data[id]=d;
			};
		int Valid_Variable( char name[] );
		int Get_Variable_ID( char name[] );
		void Set_Environment_String( int id, char *str );
		char *Get_Environment_String( int id );
		void Dump( void );
		void *Get_Data_Ptr( int var_id );
		char *Get_Name( int var_id ) { return Table[var_id].name; };
		  
	};

#endif




