//----------------------------------------------------------------------
// Program: state.C  -  State Class
//
// Author : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: The state class maintains a program state.  
//	    Variable names can be of any length.  This class 
//	    provides get and set functions so
//          the symbol table is encapsulated.  Data lists and 
//	    the backpropagation neural network are also maintained
//	    by the state object.
//
//----------------------------------------------------------------------
 
#include"state.h"

//----------------------------------------------------------------
// This is the constructor for the state class

State::State( void )
	{
	Table=new SYMBOL_TABLE[MAX_SYMBOLS];
	net=new BPNET;
	sym_count=0;
	for (int i=0; i<MAX_DATA_LISTS; i++)
		data[i]=NULL;
	for (i=0; i<MAX_ENVIRONMENT_STRINGS; i++)
		Env_Str[i]=NULL;
	}
//----------------------------------------------------------------
// This function returns the variable id number or a variable name

int State::Get_Variable_ID( char name[] )
	{
	int i;

	for (i=0; i<sym_count; i++)
		if (strcmp(name,Table[i].name)==0)
			return i;

	return NOT_FOUND;
	}
//----------------------------------------------------------------
void State::Declare_Allocate_Variable( char name[], int type, 
				       double init_val, int size )
	{
	char buffer[80];
	
	if (size==-1)                                // Scalar Variable
		Declare_Variable(name,type,NULL);
	else
		{ 				     // Array Variable
		sprintf(buffer,"%d",size);	 
		Declare_Variable(name,type,buffer);
		}
	if (size==-1) size=1;
	Allocate_Variable(Get_Variable_ID(name),size,init_val);
	}

//----------------------------------------------------------------
// This function adds a variable to the symbol table

void State::Declare_Variable( char name[], int type, char *size )
	{
	if (sym_count<MAX_SYMBOLS)   // If fewer than maximum number of symbols
		{
		if (Get_Variable_ID(name)!=NOT_FOUND)  // and symbol is new
			{
			cout << "Variable Already Defined: " << name << "\n";
			exit(0);
			}

		Table[sym_count].name=strdup(name);    // Add to symbol table
		Table[sym_count].type=type;
		if (size==NULL)                        // Scalar Variable
			{
			Table[sym_count].structure=SCALAR;
			Table[sym_count].size_str=NULL;
			}
		else
			{			      // Array Variable
			Table[sym_count].structure=ARRAY;
			Table[sym_count].size_str=strdup(size);
			}
		
		Table[sym_count].data=NULL;
		sym_count++;
		}
	else
		{
		cout << "Too many variable declared\n";
		exit(0);
		}
	}
//--------------------------------------------------------------------------
// This function sets a variable in the symbol table to a specific value.

int State::Set_Value(char name[], double value, int pos )
	{
	return Set_Value(Get_Variable_ID(name),value,pos);
	}
//--------------------------------------------------------------------------
// This function sets a variable in the table by variable id number

int State::Set_Value( int var_id, double value, int pos )
	{
	int *tempi;
	double *tempd;

	if (var_id>=sym_count || var_id==NOT_FOUND) return 0;
	if (pos<0 || pos>=Get_Size(var_id))
		return OUT_RANGE;

	switch(Table[var_id].type)
		{
		case INT:   tempi=(int *)Table[var_id].data;
		            tempi[pos]=(int)value;
		            break;
	
		case FLOAT: tempd=(double *)Table[var_id].data;
		            tempd[pos]=value;
		            break;
		}		
	return 1;
	}
//--------------------------------------------------------------------------
// This function gets a specific variable's value from the symbol table

int State::Get_Value(char name[], double &value, int pos)
	{
	return Get_Value(Get_Variable_ID(name),value,pos);
	}
//-------------------------------------------------------------------------
// This function gets a value from the symbol table by variable id number

int State::Get_Value(int var_id, double &value, int pos )
	{
	int *tempi;
	double *tempd;

	if (var_id>=sym_count || var_id==NOT_FOUND) return 0;

	switch(Table[var_id].type)
		{
		case INT:   tempi=(int *)Table[var_id].data;
		            value=(double)tempi[pos];
		            break;
	
		case FLOAT: tempd=(double *)Table[var_id].data;
		            value=tempd[pos];
		            break;	
		}     
	return 1;
	}
//----------------------------------------------------------------
// This function determines if a variable is in the symbol table

int State::Valid_Variable( char name[] )
	{
	if (Get_Variable_ID(name)==NOT_FOUND) return 0;
	else return 1;
	}
//----------------------------------------------------------------
// This function prints the current state to the screen

void State::Dump( void )
	{
	int i,j;
	cout << "\n   Variable             Type     Structure\n";
	cout << "   --------             ----     ---------\n\n";

	for (i=0; i<sym_count; i++)
		{
		cout << setw(18) << Table[i].name;
		cout.width(10);
		cout << setw(10) << Table[i].type << "             ";
		cout << Table[i].structure << "    " << Get_Size(i) <<"\n";
//		int size=(Get_Size(i)<8)? Get_Size(i):8;
//		for (j=0; j<size; j++)   // only first ten value are printed
//			cout << setw(4) << Table[i].data[j] << " ";

		cout << "\n";
		}
	cout << "\n" << flush;
	}
//----------------------------------------------------------------
// This function return one of the environment strings

char *State::Get_Environment_String( int id )
	{
	if (id<0 && id>=MAX_ENVIRONMENT_STRINGS)
	   {
	   cout << "Index: " << id << "\n";
	   cout <<"Environment String Index is out of range\n";
	   exit(0);
	   }
	return Env_Str[id];
	};
//-----------------------------------------------------------------------------
// This function sets one of the environment strings

void State::Set_Environment_String( int id, char *str )
	{
	if (id>=0 && id<MAX_ENVIRONMENT_STRINGS)
		{
		if (Env_Str[id]!=NULL) delete Env_Str[id];
		Env_Str[id]=strdup(str);
		}
	else
	   {
	   cout << "String: " << str << "  Index: " <<
			 id << "\n";
	   cout <<"Environment String Index is out of range\n";
	   exit(0);
	   }
	};
//----------------------------------------------------------------------------
// This function allocates a variables storage

void State::Allocate_Variable( int var_id, int size, double init_val )
	{
	switch(Table[var_id].type)
		{
		case INT:   Table[var_id].data=(void *)new int[size];
		            break;

		case FLOAT: Table[var_id].data=(void *)new double[size];
		             break;
		}

	Table[var_id].size=size;
	for (int i=0; i<size; i++) Set_Value(var_id,init_val,i);
	}
//----------------------------------------------------------------------------
void *State::Get_Data_Ptr( int var_id )
	{
	if (var_id<0 || var_id>sym_count)
		{
		cout << "Used an invalid variable id in Get_Data_Pointer\n";
		exit(0);
		}
	return Table[var_id].data;
	}

//----------------------------------------------------------------------------
// This function returns the size of a variable

int State::Get_Size( int var_id ) 
  	{ 
        return Table[var_id].size; 
	};








