//----------------------------------------------------------------------
// Program: netinst.h  -  Network Class Instructions
//
// Name   : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This file contains all of the network class instrutions.  These
//	    instructions manipulate the neural network used by NeuDL.
//----------------------------------------------------------------------

#ifndef NETINST
#define NETINST

#include"baseinst.h"
#include"bp.h"
//============================================================================
// Print Network Instruction Class - Print network's weight and node values

class Print_Network_Inst : public Instruction
	{
	public:
		Print_Network_Inst(int inst_id):Instruction( inst_id ){};
		void Execute( State &s) {s.Get_BP_Network()->Print_Network();};
		void Translate( State &s) 
		     { cout << "// Print Network - ID: " << id << "\n" <<
		               "   net.Print_Network();\n"; } ;
	};
//============================================================================
// Create Network Instruction Class - This class creates a network in
// memory.  No node connection are made by this instruction.

class Create_Network_Inst : public Param_Instruction
	{
	public:
		Create_Network_Inst(int inst_id, char parameters[]):
		      Param_Instruction(inst_id, parameters, 
		      MAX_MIDDLE_LAYERS+2, FALSE) {};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression **list;   // List of Layer Sizes
	};
//============================================================================
// Fully Connect Instruction Class - This instruction fully connects a
// network.  Each node is connected to each node in each succeeding layer

class Fully_Connect_Inst : public Instruction
	{
	public:
		Fully_Connect_Inst(int inst_id):Instruction(inst_id){};
		void Execute( State &s) { BPNET *net=s.Get_BP_Network();
					  net->Fully_Connect_Network();
					  s.Set_Value("Weight_Count",
					     net->Get_Weight_Count());};
		void Translate( State &s )
			{ cout << "// Fully Connect - ID: " << id << "\n" <<
				"   net.Fully_Connect_Network();\n" <<
				"   Weight_Count=net.Get_Weight_Count();\n";};
	};
//============================================================================
// Partially Connect Instruction Class - This instruction partially connects
// a network.  Each node is connected to each node in its succeeding layer.

class Partially_Connect_Inst : public Instruction
	{
	public:
		Partially_Connect_Inst(int inst_id):Instruction(inst_id){};
		void Execute( State &s) { BPNET *net=s.Get_BP_Network();
					  net->Partially_Connect_Network();
					  s.Set_Value("Weight_Count",
					     net->Get_Weight_Count());};
		void Translate( State &s )
			{ cout << "// Partially Connect - ID: "<< id << "\n" <<
				"   net.Partially_Connect_Network();\n" <<
				"   Weight_Count=net.Get_Weight_Count();\n";};

	};
//============================================================================
// Forward Pass Instruction Class - This instruction performs a forward pass
// on the network.

class Forward_Pass_Inst : public Param_Instruction
	{
	public:
		Forward_Pass_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 2, FALSE){};
		void Execute( State &s );
		void Prepare( State &s );
		void Translate( State &s );
	private:
		int var_id[2];         
		Expression *data_id;
	}; 

//============================================================================
// BP Train Instruction Class - This instruction trains a network 

class BP_Train_Inst : public Param_Instruction
	{
	public:
		BP_Train_Inst(int inst_id, char parameters[], int tmode ):
			Param_Instruction(inst_id,parameters,3){mode=tmode;};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		int mode;
		Expression *exp[2];
		char *filename;
		int string_type;		
	};
//============================================================================
// Backward Pass Instruction Class - This instruction performs a backward pass
// on the network.

class Backward_Pass_Inst : public Param_Instruction
	{
	public:
		Backward_Pass_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;   // ID for data list
		int momentum_id;       // ID numbers of system variables
		int learning_rate_id;
	};
//===========================================================================
// Connect Weight Instruction Class - Conncects weight between two nodes

class Connect_Weight_Inst : public Param_Instruction
	{
	public:
		Connect_Weight_Inst(int inst_id, char parameters[]):
		    Param_Instruction(inst_id,parameters,4){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *list[4];   // From_Layer,From_Node,To_Layer,To_Node
	};
//===========================================================================
// Remove Weight Instruction Class - Removes weighted connection from network

class Remove_Weight_Inst : public Param_Instruction
	{
	public:
		Remove_Weight_Inst(int inst_id, char parameters[]):
		    Param_Instruction(inst_id,parameters,4){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *list[4];  // From_Layer,From_Node,To_Layer,To_Node
	};
//===========================================================================
// Get Weight Instruction Class - Gets weight value

class Get_Weight_Inst : public Param_Instruction
	{
	public:
		Get_Weight_Inst(int inst_id, char parameters[]):
		    Param_Instruction(inst_id,parameters,5){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *list[4]; // From_Layer,From_Node,To_Layer,To_Node
		int var_id;          // variable id to place value in
	};
//===========================================================================
// Get Error Instruction Class - Gets total Network Error

class Get_Error_Inst : public Param_Instruction
	{
	public:
		Get_Error_Inst(int inst_id, char parameters[]):
		    Param_Instruction(inst_id,parameters,1){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		int var_id;
	};
//===========================================================================
// Set Weight Instruction Class - Sets a Network Weight Value

class Set_Weight_Inst : public Param_Instruction
	{
	public:
		Set_Weight_Inst(int inst_id, char parameters[]):
		    Param_Instruction(inst_id,parameters,5){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *list[5]; // From_Layer,From_Node,To_Layer,To_Node,
	};			     // and new weight value
//============================================================================
// Load Network Instruction Class - Load a network from a file and creates
// network in memory

class Load_Network_Inst : public Param_Instruction
	{
	public:
		Load_Network_Inst(int inst_id, char parameters[] ):
		     Param_Instruction(inst_id, parameters,1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		char *filename;
                int string_type;
	};
//============================================================================
// Save Network Instruction Class - Save a network to a file

class Save_Network_Inst : public Param_Instruction
	{
	public:
		Save_Network_Inst(int inst_id, char parameters[] ):
		     Param_Instruction(inst_id, parameters,1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		char *filename;
                int string_type;
	};
//============================================================================
// Run Network Instruction Class - Run a Data set through a network

class Run_Network_Inst : public Param_Instruction
	{
	public:
		Run_Network_Inst(int inst_id, char parameters[] ):
		     Param_Instruction(inst_id, parameters,2,FALSE){};
		void Execute( State &s );
		void Prepare( State &s );
		void Translate( State &s );
	private:
		char *filename;		// Output file name
		Expression *data;	// data set id number
                int string_type;
	};
//============================================================================
// Reset Current Weight Instruction - Set current weight pointer to first wght

class Reset_Current_Weight_Inst : public Instruction
	{
	public:
		Reset_Current_Weight_Inst(int inst_id):Instruction(inst_id){};
		void Execute( State &s) { BPNET *net=s.Get_BP_Network();
					  net->Reset_Current_Weight(); };
		void Translate( State &s )
		    { cout << "// Reset Current Weight - ID: " << id << "\n" <<
				  "   net.Reset_Current_Weight();\n"; }
	};
//============================================================================
// Reset Error Instruction - Set accumulated network error to zero.

class Reset_Error_Inst : public Instruction
	{
	public:
		Reset_Error_Inst(int inst_id):Instruction(inst_id){};
		void Execute( State &s) { BPNET *net=s.Get_BP_Network();
					  net->Reset_Error(); };
		void Translate( State &s )
		    { cout << "// Reset Error - ID: " << id << "\n" <<
				  "   net.Reset_Error();\n"; }
	};
//============================================================================
// Next Weight Instruction - Advance current weight pointer to next weight

class Next_Weight_Inst : public Instruction
	{
	public:
		Next_Weight_Inst(int inst_id):Instruction(inst_id){};
		void Execute( State &s) { BPNET *net=s.Get_BP_Network();
					  net->Next_Weight(); };
		void Translate( State &s )
		    { cout << "// Next Weight - ID: " << id << "\n" <<
				  "   net.Next_Weight();\n"; }
	};
//============================================================================
// Get Current Weight Instruction - Get current weight information

class Get_Current_Weight_Inst : public Param_Instruction
	{
	public:
		Get_Current_Weight_Inst(int inst_id, char parameters[] ):
			Param_Instruction(inst_id,parameters,5){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		int var_id[5]; // From_Layer,From_Node,To_Layer,To_Node,value
	};
//============================================================================
// Get Network High/Low Instruction - Get high/low values from network

class Get_Network_High_Low_Inst : public Param_Instruction
	{
	public:
		Get_Network_High_Low_Inst(int inst_id, char parameters[] ):
			Param_Instruction(inst_id,parameters,4){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		int var_id[4]; // high_in,low_in,high_out,low_out
	};



#endif












