//----------------------------------------------------------------------
// Program: netinst.C  -  Network Class Instructions
//
// Name   : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This file contains all of the network classe instruction.  These
//	    instructions manipulate the neural network used by NeuDL.
//----------------------------------------------------------------------

#include"netinst.h"

//============================================================================
// This function prepare the create network instruction 

void Create_Network_Inst::Prepare( State &s )
	{
	list=new Expression*[pcount];
	for (int i=0; i<pcount; i++)
		list[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will execute the Create Network instruction

void Create_Network_Inst::Execute( State &s )
	{
	int *layer=new int[pcount];
	double temp;
	int code;

	for (int i=0; i<pcount; i++)
		{
		layer[i]=(int)list[i]->Evaluate(s,code);
		if (code!=VALID)
			{
			cout << "Parameter: " << i+1 << "\n";
			Error(id,"Unable to evaluate");
			Expression_Error(code,id,list[i]);
			exit(0);
			}
		}

	if (layer[0]<=0)  // Input layer must have more than 0 nodes
	     {
	     Error(id,"Run Time Error: Input Layer must have at least 1 node");
	     exit(0);
	     }
	else if (layer[pcount-1]<=0)  // Out layer must have more than 0 nodes
	     {
	     Error(id,
		   "Run Time Error: Output Layer must have at least 1 node");
	     exit(0);
	     }

	for (i=0; i<pcount; i++)	// Set System Variables
		s.Set_Value("Layer_Nodes",(double)layer[i],i);

	s.Set_Value("Input_Layer",0);
	s.Set_Value("Output_Layer",(double)(pcount-1));
	s.Set_Value("Layer_Count",(double)pcount);

	BPNET *net=s.Get_BP_Network();
	net->Create_Layers(pcount,layer);

	delete layer;
	}
//--------------------------------------------------------------------------
// This function translates the create network instruction

void Create_Network_Inst::Translate( State &s )
	{
	cout << "// Create Network - ID: " << id << "\n";
	for (int i=0; i<pcount; i++)
		{
		cout << "   Layer_Nodes[" << i << "]=";
		Convert_Expression(list[i]);
		cout << ";\n";
		}
	cout << "   Layer_Count=" << pcount << ";\n";
	cout << "   net.Create_Layers(Layer_Count,Layer_Nodes);\n";
	cout << "   Input_Layer=0;\n   Output_Layer=Layer_Count-1;\n";
	}

//============================================================================
// This function will execute the Forward Pass instruction

void Forward_Pass_Inst::Execute( State &s )
	{
	BPNET *net=s.Get_BP_Network();

	if (pcount==2)      // input array/output array version
		{
		int size=s.Get_Size(var_id[0]);
		int i;
		if (size<=net->Get_Input_Layer_Nodes())
			net->Load_Input_Layer(
			       (double *)s.Get_Data_Ptr(var_id[0]),size);
		else
			{
			Error(id,"Input data is larger than Input Layer");
			exit(0);
			}
		}
	else		// data set list version
		{
		int code;
		int data_num=data_id->Evaluate(s,code);
		if (code!=VALID)
			{
			Error(id,"Unable to evaluate data id");
			Expression_Error(code,id,data_id);
			exit(0);
			}		
		Data_Class *temp=s.Get_Data(data_num);
		int size=temp->Get_In_Size();
		if (size<=net->Get_Input_Layer_Nodes())
		   net->Load_Input_Layer(temp->Get_Current_Data()->in,size);
		else
			{
			Error(id,"Input data is larger than Input Layer");
			exit(0);
			}
		}

	net->Forward_Pass();

	if (pcount==2)    // return output if an output array was supplied
		{
		int size1=net->Get_Output_Layer_Nodes();
		int size2=s.Get_Size(var_id[1]);
		if (size2<size1)
			{
			Error(id,"Output Data is Greater than Array size");
			exit(0);
			}
		net->Get_Output((double *)s.Get_Data_Ptr(var_id[1]));
		}
	}
//--------------------------------------------------------------------------
// This function prepares the forward pass instruction

void Forward_Pass_Inst::Prepare( State &s )
	{
	if (pcount==0)
		{
		Error(id,"Too Few Parameters in Forward Pass");
		exit(0);
		}

	if (pcount==1) 
		data_id=new Expression(param[0]);  // data id expression
	else
		{
		var_id[0]=s.Get_Variable_ID(param[0]);  // Input and output
		var_id[1]=s.Get_Variable_ID(param[1]);  // arrays
		}
	Clear_Param(); 
	}
//--------------------------------------------------------------------------
// This function translates the forward pass instruction

void Forward_Pass_Inst::Translate( State &s )
	{
	cout << "// Forward Pass - ID: " << id << "\n" <<
		"   net.Load_Input_Layer(";
	if (pcount==2)
		{
	   	cout <<  s.Get_Name(var_id[0]) <<",(int)( ";
		Expression *temp=
			new Expression(s.Get_Size_Expression(var_id[0]));
		Convert_Expression(temp);
		delete temp;
		cout << "));";
		}
	else
		{
		cout << "   Data_List[(int)(";  
		Convert_Expression(data_id);
		cout << ")]->Get_Current_Data()->in,Data_List[(int)(";
		Convert_Expression(data_id);
		cout << ")]->Get_In_Size());\n";
		}

	cout << "   net.Forward_Pass();\n";

	if (pcount==2)
		cout << "   net.Get_Output(" << s.Get_Name(var_id[1]) <<
			");\n";
	}

//============================================================================
// This function will execute the BP_Train instruction

void BP_Train_Inst::Execute( State &s )
	{
	int code;

	int train_file=(int)exp[0]->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate training data id");
		Expression_Error(code,id,exp[0]);
		exit(0);
		}

	int test_file=(int)exp[1]->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate testing data id");
		Expression_Error(code,id,exp[1]);
		exit(0);
		}

	if (strcmp(filename,"")==0)      // Get file from user if not specified
		{
		char buffer[80];
		cout << ": ";
		cin >> buffer;
		filename=strdup(buffer);
		}

	BPNET *net=s.Get_BP_Network();
	Data_Class *t1,*t2;
	t1=s.Get_Data(train_file);
	if (t1==NULL)			// Make sure training set is present
		{
		Error(id,"No data present in training set\n");
		exit(0);
		}

	t2=s.Get_Data(test_file);    // Make sure test set is present
	if (t2==NULL)
		{
		Error(id,"No data present in testing set\n");
		exit(0);
		}

	double temp;			   // Get system variable values
	s.Get_Value("Learning_Rate",temp);
	net->Set_Learning_Rate(temp);
	s.Get_Value("Momentum",temp);
	net->Set_Momentum(temp);
	s.Get_Value("Tolerance",temp);
	net->Set_Tolerance(temp);
	s.Get_Value("Check_Test_Set",temp);
	net->Set_Check_Test_Set((int)temp);
	s.Get_Value("Min_Iterations",temp);
	net->Set_Min_Iterations((int)temp);
	s.Get_Value("Max_Iterations",temp);
	net->Set_Max_Iterations((int)temp);
	s.Get_Value("Display_Rate",temp);
	net->Set_Display_Rate((int)temp);
	net->Set_Training_Data(t1);
	net->Set_Testing_Data(t2);
	net->Set_Network_File(filename);

	net->Train(mode);
	}
//--------------------------------------------------------------------------
// This function prepares the bp_train function

void BP_Train_Inst::Prepare( State &s )
	{
	filename=strdup(param[0]);
	Convert_String(s,filename,string_type);
	exp[0]=new Expression(param[1]);
	exp[1]=new Expression(param[2]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function translates the bp_train function

void BP_Train_Inst::Translate( State &s )
	{
	cout << "// BP Train - ID: " << id << "\n";

	if (string_type==QUERY_STRING)
		cout << "   cout << \": \";\n" <<
			"   cin >> ___filename;\n";

	cout << "   net.Set_Network_File(";
	if (string_type==QUERY_STRING) cout << "___filename";
	else if (string_type==NORMAL_STRING) cout << "\"" << filename << "\"";
	else cout << "argv[" << string_type << "]";
	cout << ");\n";

	cout << "   net.Set_Learning_Rate(Learning_Rate);\n" <<
		"   net.Set_Momentum(Momentum);\n" <<
		"   net.Set_Tolerance(Tolerance);\n" <<
		"   net.Set_Check_Test_Set(Check_Test_Set);\n"<<
		"   net.Set_Min_Iterations(Min_Iterations);\n" <<
		"   net.Set_Max_Iterations(Max_Iterations);\n"<<
		"   net.Set_Display_Rate(Display_Rate);\n" <<
		"   net.Set_Training_Data(Data_List[(int)(";
	Convert_Expression(exp[0]);
	cout << ")]);\n   net.Set_Testing_Data(Data_List[(int)(";
	Convert_Expression(exp[1]);
	cout << ")]);\n   net.Train(" << mode << ");\n";
	}


//============================================================================
// This fucntion will execute the backward pass instruction

void Backward_Pass_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate data id");
		exit(0);
		}
	double l_rate, mom;
	s.Get_Value(learning_rate_id,l_rate);
	s.Get_Value(momentum_id,mom);

	s.Get_BP_Network()->Backward_Pass(
		s.Get_Data(id_num)->Get_Current_Data(),l_rate,mom);
	}
//--------------------------------------------------------------------------
// This instruction will prepare the backward pass instruction

void Backward_Pass_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	learning_rate_id=s.Get_Variable_ID("Learning_Rate");
	momentum_id=s.Get_Variable_ID("Momentum");
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This instruction will translate the backward pass instrucion

void Backward_Pass_Inst::Translate( State &s )
	{
	cout << "// Backward Pass - ID: " << id << "\n" <<
		"   net.Backward_Pass(Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Get_Current_Data(),Learning_Rate,Momentum);\n";
	}

//============================================================================
// This function will execute the Remove Weight instruction

void Remove_Weight_Inst::Execute( State &s )
	{
	int code;
	int value[4];

	for (int i=0; i<4; i++)
		{
		value[i]=(int)list[i]->Evaluate(s,code);
		if (code!=VALID)
			{
			cout << "Parameter: " << i+1 << "\n";
			Error(id,"Unable to evaluate");
			Expression_Error(code,id,list[i]);
			exit(0);
			}
		}
	BPNET *net=s.Get_BP_Network();
	net->Remove_Weight(value[0],value[1],value[2],value[3]);
	double count;
	s.Get_Value("Weight_Count",count);
	s.Set_Value("Weight_Count",count-1);
	}
//--------------------------------------------------------------------------
// This instruction will prepare the remove weight instruction

void Remove_Weight_Inst::Prepare( State &s )
	{
	for (int i=0; i<4; i++)
		list[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This instruction will translate the Remove Weight Instruction

void Remove_Weight_Inst::Translate( State &s )
	{
	cout << "// Remove Weight - ID: " << id << "\n" <<
		"   net.Remove_Weight((int)(";
	Convert_Expression(list[0]);
	cout << "), ";
	Convert_Expression(list[1]);
	cout << ", (int)( ";
	Convert_Expression(list[2]);
	cout << "),\n      (int)(";
	Convert_Expression(list[3]);
	cout << "));\n   Weight_Count--;\n";
	}
//============================================================================
// This function will execute the Set Weight instruction

void Set_Weight_Inst::Execute( State &s )
	{
	int code;
	double value[5];

	for (int i=0; i<5; i++)
		{
		value[i]=list[i]->Evaluate(s,code);
		if (code!=VALID)
			{
			cout << "Parameter: " << i+1 << "\n";
			Error(id,"Unable to evaluate");
			Expression_Error(code,id,list[i]);
			exit(0);
			}
		}
	BPNET *net=s.Get_BP_Network();
	net->Set_Weight((int)value[0],(int)value[1],(int)value[2],
			(int)value[3],value[4]);
	}
//--------------------------------------------------------------------------
// This fucntion will prepare the set weight instruction

void Set_Weight_Inst::Prepare( State &s )
	{
	for (int i=0; i<5; i++)
		list[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the set weight instruction

void Set_Weight_Inst::Translate( State &s )
	{
	cout << "// Set Weight - ID: " << id << "\n" <<
		"   net.Set_Weight((int)(";
	Convert_Expression(list[0]);
	cout << "), ";
	Convert_Expression(list[1]);
	cout << ", (int)( ";
	Convert_Expression(list[2]);
	cout << "),\n      (int)(";
	Convert_Expression(list[3]);
	cout << "),";
	Convert_Expression(list[4]);
	cout << ");\n";
	}
//============================================================================
// This function will execute the Get Weight instruction

void Get_Weight_Inst::Execute( State &s )
	{
	int code;
	int value[4];

	for (int i=0; i<4; i++)
		{
		value[i]=(int)list[i]->Evaluate(s,code);
		if (code!=VALID)
			{
			cout << "Parameter: " << i+1 << "\n";
			Error(id,"Unable to evaluate");
			Expression_Error(code,id,list[i]);
			exit(0);
			}
		}
	BPNET *net=s.Get_BP_Network();
	s.Set_Value(var_id,
		net->Get_Weight(value[0],value[1],value[2],value[3]));
	}
//--------------------------------------------------------------------------
// This instruction will prepare teh get weight instruction

void Get_Weight_Inst::Prepare( State &s )
	{
	for (int i=0; i<4; i++)
		list[i]=new Expression(param[i]);
	var_id=s.Get_Variable_ID(param[4]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the get weight instruction

void Get_Weight_Inst::Translate( State &s )
	{
	cout << "// Get Weight - ID: " << id << "\n" <<
		"   " << s.Get_Name(var_id) << "=net.Get_Weight((int)(";
	Convert_Expression(list[0]);
	cout << "), ";
	Convert_Expression(list[1]);
	cout << ", (int)( ";
	Convert_Expression(list[2]);
	cout << "),\n      (int)(";
	Convert_Expression(list[3]);
	cout << "));\n";
	}
//============================================================================
// This function will execute the Get Error instruction

void Get_Error_Inst::Execute( State &s )
	{
	s.Set_Value(var_id,s.Get_BP_Network()->Get_Error());
	}
//--------------------------------------------------------------------------
// This function will prepare the get error instruction

void Get_Error_Inst::Prepare( State &s )
	{
	var_id=s.Get_Variable_ID(param[0]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate teh Get Error instruction

void Get_Error_Inst::Translate( State &s )
	{
	cout << "// Get Error - ID: " << id << "\n" <<
		"   " << s.Get_Name(var_id) << "=net.Get_Error();\n";
	}
//============================================================================
// This function will execute the Connect Weight instruction

void Connect_Weight_Inst::Execute( State &s )
	{
	int code;
	int value[4];

	for (int i=0; i<4; i++)
		{
		value[i]=(int)list[i]->Evaluate(s,code);
		if (code!=VALID)
			{
			cout << "Parameter: " << i+1 << "\n";
			Error(id,"Unable to evaluate");
			Expression_Error(code,id,list[i]);
			exit(0);
			}
		}
	BPNET *net=s.Get_BP_Network();
	net->Connect_Weight(net->Create_Weight(),
			    value[0],value[1],value[2],value[3]);
	double count;
	s.Get_Value("Weight_Count",count);   // Update system variable
	s.Set_Value("Weight_Count",count+1);
	}
//--------------------------------------------------------------------------
// This function will prepare the connect weight instruction

void Connect_Weight_Inst::Prepare( State &s )
	{
	for (int i=0; i<4; i++)
		list[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the connect weight instruction

void Connect_Weight_Inst::Translate( State &s )
	{
	cout << "// Connect Weight - ID: " << id << "\n" <<
		"   net.Connect_Weight(net.Create_Weight(),\n      (int)(";
	Convert_Expression(list[0]);
	cout << "), ";
	Convert_Expression(list[1]);
	cout << ", (int)( ";
	Convert_Expression(list[2]);
	cout << "),\n      (int)(";
	Convert_Expression(list[3]);
	cout << "));\n   Weight_Count++;\n";
	}
//============================================================================
// This function will execute the Save network instruction

void Save_Network_Inst::Execute( State &s )
	{
	int code;
	if (strcmp(filename,"")==0)      // Get file from user if not specified
		{
		char buffer[80];
		cout << ": ";
		cin >> buffer;
		filename=strdup(buffer);
		}

	BPNET *net=s.Get_BP_Network();
	net->Save_Weights(filename);
	}
//--------------------------------------------------------------------------
// This function will prepare the load network instruction

void Save_Network_Inst::Prepare( State &s )
	{
	filename=strdup(param[0]);
	Convert_String(s,filename,string_type);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the load network instruction

void Save_Network_Inst::Translate( State &s )
	{
	cout << "// Save Network - ID: " << id << "\n";
	if (string_type==QUERY_STRING)
		cout << "   cout << \": \";\n" <<
			"   cin >> ___filename;\n";
	cout << "   net.Save_Weights(";
	if (string_type==QUERY_STRING) cout << "___filename";
	else if (string_type==NORMAL_STRING) cout << "\"" << filename << "\"";
             else cout << "argv[" << string_type << "]";
	cout << ");\n";
	
	}
//============================================================================
// This function will execute the Load network instruction

void Load_Network_Inst::Execute( State &s )
	{
	int code;
	if (strcmp(filename,"")==0)      // Get file from user if not specified
		{
		char buffer[80];
		cout << ": ";
		cin >> buffer;
		filename=strdup(buffer);
		}

	BPNET *net=s.Get_BP_Network();
	net->Load_Network(filename);

	int layer_count=net->Get_Layer_Count();   // Update system variables
	int *layers=new int[layer_count];
	net->Get_Layer_Nodes(layers);
	s.Set_Value("Layer_Count",layer_count);
	s.Set_Value("Weight_Count",net->Get_Weight_Count());
	for (int i=0; i<layer_count; i++)
		s.Set_Value("Layer_Nodes",layers[i],i);
	
	delete layers;
	}
//--------------------------------------------------------------------------
// This function will prepare the load network instruction

void Load_Network_Inst::Prepare( State &s )
	{
	filename=strdup(param[0]);
	Convert_String(s,filename,string_type);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the load network instruction

void Load_Network_Inst::Translate( State &s )
	{
	cout << "// Load Network - ID: " << id << "\n";
	if (string_type==QUERY_STRING)
		cout << "   cout << \": \";\n" <<
			"   cin >> ___filename;\n";
	cout << "   net.Load_Network(";
	if (string_type==QUERY_STRING) cout << "___filename";
	else if (string_type==NORMAL_STRING) cout << "\"" << filename << "\"";
             else cout << "argv[" << string_type << "]";
	cout << ");\n";
	cout << "   Layer_Count=net.Get_Layer_Count();\n" <<
		"   net.Get_Layer_Nodes(Layer_Nodes);\n" <<
		"   Input_Layer=0;\n" <<
		"   Output_Layer=net.Get_Output_Layer();\n" <<
		"   Weight_Count=net.Get_Weight_Count();\n";
	
	}
//============================================================================
// This function will execute the run network instruction

void Run_Network_Inst::Execute( State &s )
	{
	int code;
				 // Get file from user if not specified
	if (pcount>1 && strcmp(filename,"")==0)
		{
		char buffer[80];
		cout << ": ";
		cin >> buffer;
		filename=strdup(buffer);
		}

	int data_id=(int)data->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate data id");
		Expression_Error(code,id,data);
		exit(0);
		}

	BPNET *net=s.Get_BP_Network();
	net->Run_Network(s.Get_Data(data_id),filename);
	}
//----------------------------------------------------------------------------
// This function will prepare teh run network instruction

void Run_Network_Inst::Prepare( State &s )
	{
	if (pcount==0)
		{
		Error(id,"Too few Parameters for Run Network");
		exit(0);
		}
	data=new Expression(param[0]);
	if (pcount==2)
		{
		filename=strdup(param[1]);
		Convert_String(s,filename,string_type);
		}
	else filename=strdup("");
	Clear_Param();
	}
//----------------------------------------------------------------------------
// This function will translate the run network instruction

void Run_Network_Inst::Translate( State &s )
	{
	cout << "// Run Network - ID: " << id << "\n";

	if (string_type==QUERY_STRING)
		cout << "   cout << \": \";\n" <<
			"   cin >> ___filename;\n";
	cout << "   net.Run_Network(Data_List[(int)(";
	Convert_Expression(data);
	cout << ")] ";
	if (string_type==QUERY_STRING) cout << ",___filename";
	else if (string_type==NORMAL_STRING) cout << "\"" << filename << "\"";
	else  if (pcount==2) cout << ",argv[" << string_type << "]";
	cout << ");\n";
	}
//============================================================================
// This function will execute the get current weight instruction

void Get_Current_Weight_Inst::Execute( State &s )
	{
	int from_layer,from_node,to_layer,to_node;
	double value;
	BPNET *net=s.Get_BP_Network();
	net->Get_Current_Weight(from_layer,from_node,to_layer,to_node,value);
	s.Set_Value(var_id[0],(double)from_layer);
	s.Set_Value(var_id[1],(double)from_node);
	s.Set_Value(var_id[2],(double)to_layer);
	s.Set_Value(var_id[3],(double)to_node);
	s.Set_Value(var_id[4],value);
	}
//----------------------------------------------------------------------------
// This function will prepare the get current weight instruction

void Get_Current_Weight_Inst::Prepare( State &s )
	{
	for (int i=0; i<5; i++)
		var_id[i]=s.Get_Variable_ID(param[i]);
	Clear_Param();
	}
//----------------------------------------------------------------------------
// This function will translate the get current weight instruction

void Get_Current_Weight_Inst::Translate( State &s )
	{
	cout << "// Get Current Weight - ID: " << id << "\n" <<
	     "   net.Get_Current_Weight(" <<
	     "___temp1,___temp2,___temp3,___temp4," << s.Get_Name(var_id[4])
	      << ");\n";

	cout << "   " << s.Get_Name(var_id[0]) << "=(double)___temp1;\n" << 
		"   " << s.Get_Name(var_id[1]) << "=(double)___temp2;\n" << 
		"   " << s.Get_Name(var_id[2]) << "=(double)___temp3;\n" << 
		"   " << s.Get_Name(var_id[3]) << "=(double)___temp4;\n";
	}
//============================================================================
// This function will execute the get network high/low instruction

void Get_Network_High_Low_Inst::Execute( State &s )
	{
	BPNET *net=s.Get_BP_Network();
	net->Get_High_Low((double *)s.Get_Data_Ptr(var_id[0]),
			  (double *)s.Get_Data_Ptr(var_id[1]),
			  (double *)s.Get_Data_Ptr(var_id[2]),
			  (double *)s.Get_Data_Ptr(var_id[3]));
	}
//----------------------------------------------------------------------------
// This function will prepare the get network high/low instruction

void Get_Network_High_Low_Inst::Prepare( State &s )
	{
	for (int i=0; i<4; i++)
		{
		var_id[i]=s.Get_Variable_ID(param[i]);
		if (s.Get_Type(var_id[i])!=ARRAY)
			{
			cout << "Parameter " << i+1 << ": \n";
			Error(id,"Must be an array");
			exit(0);
			}
		}
	Clear_Param();
	}
//----------------------------------------------------------------------------
// This function will translate the get network high/low instruction

void Get_Network_High_Low_Inst::Translate( State &s )
	{
	cout << "// Get Network High Low- ID: " << id << "\n" <<
	     "   net.Get_High_Low(" <<
	     s.Get_Name(var_id[0]) << "," << s.Get_Name(var_id[1]) << "," <<
	     s.Get_Name(var_id[2]) << "," << s.Get_Name(var_id[3]) << ");\n";
	}









