// express.h

#ifndef EXPRESS
#define EXPRESS
#include<stdio.h>
#include<iostream.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include"state.h"

#define TT_UNKNOWN 0
#define TT_DELIM 1
#define TT_NUMBER 2
#define TT_VARIABLE 3
#define TT_SUB_VARIABLE 4

#define EMP_EXPRESS 0
#define UNDEC_VAR 1
#define SYNTAX_ERROR 2
#define MISSING_PAR 3
#define UNMATCHED_PAR 4
#define BAD_OPER 5
#define TYPE_MIS 6
#define SUB_OUT_RANGE 7
#define VALID 8
//============================================================================
class Expression
	{
	public:
		Expression( char exp[] );
		double Evaluate( State &s, int &code );
		friend void Expression_Error( int code, int id, 
					     Expression *exp );
		char *Get_Expression( void ) { return exp_string; };
	private:
		char CurrTokenText[25];
		char *sub_start;
		int sub_count;
		char *EquationPtr;
		int CurrTokenType;
		char *exp_string;
		int open_parentheses;
		int Current_Type;

		void Get_Token();
		double Relation(State &s, int &code);
		double PlusOrMinus(State &s, int &code);
		double AndOrOr(State &s, int &code);
		double MultOrDiv(State &s, int &code);
		double Unary(State &s, int &code );
		double Parenthesis(State &s, int &code);
	};

#endif
