//----------------------------------------------------------------------
// Program: datainst.h  -  Data Instruction Class Header
//
// Author : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This is the header for the Data Class Instructions.  These 
//	    instructions manimulate the data lists in NeuDL.
//----------------------------------------------------------------------

#ifndef DATAINST
#define DATAINST

#include"coreinst.h"
#include"data.h"

//============================================================================
// Load Data Instruction Class - This instruction loads a formated data file
// from disk into one of teh data list positions.

class Load_Data_Inst : public Param_Instruction
	{
	public:
		Load_Data_Inst(int inst_id, char parameters[] ):
		  Param_Instruction(inst_id,parameters,2){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;    // data list id
		char *filename;		// Filename to load
                int string_type;
	};
//============================================================================
// Find High Low Instruction Class - This instruction finds the high/low
// values in a data set.

class Find_High_Low_Inst : public Param_Instruction
	{
	public:
		Find_High_Low_Inst(int inst_id, char parameters[] ):
		  Param_Instruction(inst_id,parameters,5){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *data_id;	// data list id number
		int var_id[4];          // High/Low array to store info in
	};
//============================================================================
// Save Data Instruction Class - This instruction saves a formated data file
// to disk.

class Save_Data_Inst : public Param_Instruction
	{
	public:
		Save_Data_Inst(int inst_id, char parameters[] ):
		  Param_Instruction(inst_id,parameters,2){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;    // data list id
		char *filename;		// Filename to save
                int string_type;
	};
//============================================================================
// Normalize Data Instruction - This instruction normalizes one of the data
// lists according to the high/low values passed to it.

class Normalize_Data_Inst : public Param_Instruction
	{
	public:
		Normalize_Data_Inst(int inst_id, char parameters[] ):
		   Param_Instruction(inst_id,parameters,5){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		int var_id[4];
		Expression *data_id;
	};
//============================================================================
// Denormalize Instruction Class - This instruction reverses the effects of 
// the Normalize_Instruction instruction.

class Denormalize_Data_Inst : public Param_Instruction
	{
	public:
		Denormalize_Data_Inst(int inst_id, char parameters[] ):
		   Param_Instruction(inst_id,parameters,1){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *data_id;
	};
//============================================================================
// Delete Data Instruction

class Delete_Data_Inst : public Param_Instruction
	{
	public:
		Delete_Data_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;
	};
//============================================================================
// Print Data Instruction

class Print_Data_Inst : public Param_Instruction
	{
	public:
		Print_Data_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;
	};

//============================================================================
// Reset to Head Instruction Class - This instruction sets the current 
// element in a data list to its first element.

class Reset_To_Head_Inst : public Param_Instruction
	{
	public:
		Reset_To_Head_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;
	};
//============================================================================
// Reset to Tail Instruction Class - This instruction sets the current 
// element in a data list to its last element.

class Reset_To_Tail_Inst : public Param_Instruction
	{
	public:
		Reset_To_Tail_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;
	};

//============================================================================
// Next_Data Instruction Class - Sets data list pointer to next

class Next_Data_Inst : public Param_Instruction
	{
	public:
		Next_Data_Inst(int inst_id, char parameters[] ):
			Param_Instruction( inst_id, parameters, 1){};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression *data_id;    // data list id number
	};
//============================================================================
// Get Data Instruction Class - Gets data from current element in data set

class Get_Data_Inst : public Param_Instruction
	{
	public:
		Get_Data_Inst(int inst_id, char parameters[] ):
			Param_Instruction(inst_id,parameters,4){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *data_id;  // data list id number
		int var_id[3];	      // variables to store info in
	};
//============================================================================
// Create Data Instruction Class

class Create_Data_Inst : public Param_Instruction
	{
	public:
		Create_Data_Inst(int inst_id, char parameters[] ):
			Param_Instruction(inst_id,parameters,3){};
		void Execute( State &s);
		void Prepare( State &s);
		void Translate( State &s );
	private:
		Expression *exp[3];  // Array for data set id, in and out sizes
	};
//============================================================================
// Add Data After Curr Instruction Class -  This instruction adds a data
// element to data set.

#define MAX_PARAMETERS 100

class Add_Data_After_Curr_Inst : public Param_Instruction
	{
	public:
		Add_Data_After_Curr_Inst(int inst_id, char parameters[]):
		   Param_Instruction(inst_id,parameters,100,FALSE)
		      {array_id1=-1; array_id2=-1;};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression **list;  
		int array_id1, array_id2;
	};

//============================================================================
// Add Data After Curr Instruction Class -  This instruction adds a data
// element to data set.

#define MAX_PARAMETERS 100

class Add_Data_Before_Curr_Inst : public Param_Instruction
	{
	public:
		Add_Data_Before_Curr_Inst(int inst_id, char parameters[]):
		   Param_Instruction(inst_id,parameters,100,FALSE)
		      {array_id1=-1; array_id2=-1;};
		void Execute( State &s);
		void Prepare( State &s);
                void Translate( State &s );
	private:
		Expression **list;  
		int array_id1, array_id2;
	};


#endif

