//----------------------------------------------------------------------
// Program: datainst.C  -  Data Class Instructions
//
// Name   : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This file contains all of the data class instrutions.  These
//	    instructions manipulate the data list used by NeuDL.
//----------------------------------------------------------------------

#include"datainst.h"

//============================================================================
// This function will execute the Load Data instruction

void Load_Data_Inst::Execute( State &s)
	{
	int code;
	int id=data_id->Evaluate(s,code);

	if (strcmp(filename,"")==0)      // Get file from user if not specified
		{
		char buffer[80];
		cout << ": ";
		cin >> buffer;
		filename=strdup(buffer);
		}

	Data_Class *temp=new Data_Class;
	int count,in,out;
	temp->Load_Data(filename,count,in,out);

	s.Set_Data(id,temp);                 // Update System variables
	s.Set_Value("Data_Count",count,id);
	s.Set_Value("Data_Inputs",in,id);
	s.Set_Value("Data_Outputs",out,id);
	}
//--------------------------------------------------------------------------
// This function will prepare the load data instruction

void Load_Data_Inst::Prepare( State &s)
	{
	data_id=new Expression(param[0]);
	filename=strdup(param[1]);
	Convert_String(s,filename,string_type);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the load data instruction

void Load_Data_Inst::Translate( State &s)
	{
	cout << "// Load Data - ID: " << id << "\n";
	if (string_type==QUERY_STRING)
		cout << "   cout << \": \";\n" <<
			"   cin >> ___filename;\n";
	cout << "   if (Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]!=NULL)\n      delete Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")];\n   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]=new Data_Class;\n   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Load_Data(";
	if (string_type==QUERY_STRING) cout << "___filename";
	else if (string_type==NORMAL_STRING) cout << "\"" << filename << "\"";
	else cout << "argv[" << string_type << "]";
	cout << ",\n      Data_Count[(int)(";
	Convert_Expression(data_id);
	cout << ")],\n      Data_Inputs[(int)(";
	Convert_Expression(data_id);
	cout << ")],\n      Data_Outputs[(int)(";
	Convert_Expression(data_id);
	cout <<	")]);\n";
	}

//============================================================================
// This function will execute the Save Data instruction

void Save_Data_Inst::Execute( State &s)
	{
	int code;
	int id=data_id->Evaluate(s,code);

	if (strcmp(filename,"")==0)      // Get file from user if not specified
		{
		char buffer[80];
		cout << ": ";
		cin >> buffer;
		filename=strdup(buffer);
		}

	Data_Class *temp=s.Get_Data(id);
	temp->Save_Data(filename);

	}
//--------------------------------------------------------------------------
// This function will prepare the Save data instruction

void Save_Data_Inst::Prepare( State &s)
	{
	data_id=new Expression(param[0]);
	filename=strdup(param[1]);
	Convert_String(s,filename,string_type);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the load data instruction

void Save_Data_Inst::Translate( State &s)
	{
	cout << "// Save Data - ID: " << id << "\n";
	if (string_type==QUERY_STRING)
		cout << "   cout << \": \";\n" <<
			"   cin >> ___filename;\n";
	cout << "   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Save_Data(";
	if (string_type==QUERY_STRING) cout << "___filename";
	else if (string_type==NORMAL_STRING) cout << "\"" << filename << "\"";
	else cout << "argv[" << string_type << "]";
	cout << ");\n";
	}
//============================================================================
// This function will execute the Find High Low instruction

void Find_High_Low_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate data id");
		Expression_Error(code,id,data_id);
		exit(0);
		}

	Data_Class *temp=s.Get_Data(id_num);

	int in_size=temp->Get_In_Size();
	int out_size=temp->Get_Out_Size();
	double *h_i=new double[in_size];
	double *l_i=new double[in_size];
	double *h_o=new double[out_size];
	double *l_o=new double[out_size];

	temp->Find_High_Low(h_i,l_i,h_o,l_o);

	for (int i=0; i<in_size; i++)
		{
		s.Set_Value(var_id[0],h_i[i],i);
		s.Set_Value(var_id[1],l_i[i],i);
		}
	delete h_i;  delete l_i;

	for (i=0; i<out_size; i++)
		{
		s.Set_Value(var_id[2],h_o[i],i);
		s.Set_Value(var_id[3],l_o[i],i);
		}
	delete h_o;  delete l_o;
	}
//--------------------------------------------------------------------------
// This function will prepare the find high low instruction

void Find_High_Low_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	for (int i=0; i<4; i++) 
		{
		var_id[i]=s.Get_Variable_ID(param[i+1]);
		if (s.Get_Structure(var_id[i])!=ARRAY ||
		    s.Get_Type(var_id[i])!=FLOAT)
			{
			cout << "Parameter " << i+1 << ": \n";
			Error(id,"Must be an float array");
			exit(0);
			}
		}
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the find high low instruction

void Find_High_Low_Inst::Translate( State &s )
	{
	cout << "// Find High Low - ID: " << id << "\n"<<"   Data_List[(int)(";
	Convert_Expression(data_id);
	cout <<	")]->Find_High_Low("<< s.Get_Name(var_id[0]) <<", " <<
		s.Get_Name(var_id[1]) << ", " << s.Get_Name(var_id[2])<<
		", " <<s.Get_Name(var_id[3]) << ");\n";
	}
//============================================================================
// This function will execute the normalize data instruction

void Normalize_Data_Inst::Execute( State &s )
	{
	int code;

	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate data id");
		Expression_Error(code,id,data_id);
		exit(0);
		}

	s.Get_Data(id_num)->Normalize_Data(
			      (double *)s.Get_Data_Ptr(var_id[0]), 
			      (double *)s.Get_Data_Ptr(var_id[1]),
			      (double *)s.Get_Data_Ptr(var_id[2]),
			      (double *)s.Get_Data_Ptr(var_id[3]));
	}
//--------------------------------------------------------------------------
// This function will prepare the normalize data instruction

void Normalize_Data_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	for (int i=1; i<5; i++) 
		{
		var_id[i-1]=s.Get_Variable_ID(param[i]);
		if (i>1 && (s.Get_Structure(var_id[i-1])!=ARRAY ||
			    s.Get_Type(var_id[i-1])!=FLOAT))
			{
			cout << "Parameter " << i+1 << ": \n";
			Error(id,"Must be an float array");
			exit(0);
			}
		}
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the normalize data instruction

void Normalize_Data_Inst::Translate( State &s )
	{
	cout << "// Normalize Data - ID: " << id << "\n" <<
		"   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Normalize_Data(\n   ",
	cout << s.Get_Name(var_id[0]) << ", " <<
		s.Get_Name(var_id[1]) << ", " <<s.Get_Name(var_id[2]) <<
		", " << s.Get_Name(var_id[3]) << ");\n";
	}
//============================================================================
// This function will execute the denormalize instruction

void Denormalize_Data_Inst::Execute( State &s )
	{
	int code;

	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate data id");
		Expression_Error(code,id,data_id);
		exit(0);
		}

	s.Get_Data(id_num)->Denormalize_Data();
	}
//--------------------------------------------------------------------------
// This function will prepare the denormalize instruction

void Denormalize_Data_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	}
//--------------------------------------------------------------------------
// This function will translate the denormalize instruction

void Denormalize_Data_Inst::Translate( State &s )
	{
	cout << "// Denormalize Data - ID: " << id << "\n" <<
		"   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Denormalize_Data();\n";
	}
//============================================================================
// This function will execute the Reset instruction

void Reset_To_Tail_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate expression for Reset");
		exit(0);
		}
	s.Get_Data(id_num)->Reset_to_Tail();
	}
//--------------------------------------------------------------------------
// This function will prepare the reset instruction

void Reset_To_Tail_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the reset instruction

void Reset_To_Tail_Inst::Translate( State &s )
	{
	cout <<"// Reset to Tail- ID: " << id << "\n" << "   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Reset_to_Tail();\n";
	}
//============================================================================
// This function will execute the Reset instruction

void Delete_Data_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate expression for Reset");
		exit(0);
		}
	s.Get_Data(id_num)->Delete_Curr_Data();
	}
//--------------------------------------------------------------------------
// This function will prepare the Print Data instruction

void Print_Data_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the reset instruction

void Print_Data_Inst::Translate( State &s )
	{
	cout <<"// Print Data- ID: " << id << "\n" << "   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Print_Data();\n";
	}
//============================================================================
// This function will execute the Print Data instruction

void Print_Data_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate expression for Reset");
		exit(0);
		}
	s.Get_Data(id_num)->Print_Data();
	}
//--------------------------------------------------------------------------
// This function will prepare the reset instruction

void Delete_Data_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the reset instruction

void Delete_Data_Inst::Translate( State &s )
	{
	cout <<"// Delete Data- ID: " << id << "\n" << "   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Delete_Curr_Data();\n";
	}
//============================================================================
// This function will execute the Reset instruction

void Reset_To_Head_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate expression for Reset");
		exit(0);
		}
	s.Get_Data(id_num)->Reset_to_Head();
	}
//--------------------------------------------------------------------------
// This function will prepare the reset instruction

void Reset_To_Head_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the reset instruction

void Reset_To_Head_Inst::Translate( State &s )
	{
	cout <<"// Reset to Head- ID: " << id << "\n" << "   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Reset_to_Head();\n";
	}
//============================================================================
// This instruction will execute the Next Data Instruction

void Next_Data_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);
	if (code!=VALID)
		{
		Error(id,"Unable to evaluate expression for Reset");
		exit(0);
		}
	s.Get_Data(id_num)->Next_Data();
	}
//--------------------------------------------------------------------------
// This function will prepare the next data instruction

void Next_Data_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the next data instruction

void Next_Data_Inst::Translate( State &s )
	{
	cout << "// Next_Data - ID: " << id << "\n" << "   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Next_Data();\n";
	}
//============================================================================
// This function will execute the Get Data instruction

void Get_Data_Inst::Execute( State &s )
	{
	int code;
	int id_num=data_id->Evaluate(s,code);

	Data_Class *temp=s.Get_Data(id_num);
	int in_size=temp->Get_In_Size();
	int out_size=temp->Get_Out_Size();
	int data_id;
	double *in=new double[in_size];
	double *out=new double[out_size];
	temp->Get_Current_Data(data_id,in,out);

	s.Set_Value(var_id[0],data_id);
	for (int i=0; i<in_size; i++)
		s.Set_Value(var_id[1],in[i],i);
	for (i=0; i<out_size; i++)
		s.Set_Value(var_id[2],out[i],i);
	}
//--------------------------------------------------------------------------
// This function will prepare the get data instruction

void Get_Data_Inst::Prepare( State &s )
	{
	data_id=new Expression(param[0]);
	for (int i=0; i<3; i++)
		{
		var_id[i]=s.Get_Variable_ID(param[i+1]);
		if (i>0 && (s.Get_Structure(var_id[i])!=ARRAY ||
			    s.Get_Type(var_id[i])!=FLOAT))
			{
			cout << "Parameter " << i+1 << ": \n";
			Error(id,"Must be a float array");
			exit(0);
			}
		}
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will translate the get data instruction

void Get_Data_Inst::Translate( State &s )
	{
	cout << "// Get Data - ID: " << id << "\n";
	cout << "   ___lcv=(int)" << s.Get_Name(var_id[0]) << ";\n"; 
	
	cout  <<"   Data_List[(int)(";
	Convert_Expression(data_id);
	cout << ")]->Get_Current_Data(___lcv, " <<
		s.Get_Name(var_id[1]) << ", " << s.Get_Name(var_id[2]) <<
		");\n";
	cout << "   " << s.Get_Name(var_id[0]) << "=(double)___lcv;\n";
	}
//============================================================================
// This function will execute the Create Data instruction

void Create_Data_Inst::Execute( State &s )
	{
	int code;
	int value[3];

	for (int i=0; i<3; i++)
		{
		value[i]=exp[i]->Evaluate(s,code);
		if (code!=VALID)
			{
			cout << "Parameter " << i+1 << ":\n";
			Error(id,"Unable to evaluate Expression");
			Expression_Error(code,id,exp[i]);
			exit(0);
			}
		}
				// Update system variables
	Data_Class *data=new Data_Class(value[1],value[2]);
	s.Set_Data(value[0],data);
	s.Set_Value("Data_Inputs",value[1],value[0]);
	s.Set_Value("Data_Outputs",value[2],value[0]);
	s.Set_Value("Data_Count",0,value[0]);
	}
//--------------------------------------------------------------------------
// This function will prepare the Create Data instruction

void Create_Data_Inst::Prepare( State &s )
	{
	for (int i=0; i<3; i++)
		exp[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This instruction will translate the Create Data Instruction

void Create_Data_Inst::Translate( State &s )
	{
	cout << "// Create Data - ID: " << id << "\n" <<
		"   if (Data_List[(int)(";
	Convert_Expression(exp[0]);
	cout << ")]!=NULL)\n" <<
		"      delete Data_List[(int)(";
	Convert_Expression(exp[0]);
	cout  << ")];\n   Data_List[(int)(";
	Convert_Expression(exp[0]);
	cout << ")]=new Data_Class(";
	Convert_Expression(exp[1]);
	cout << ", ";
	Convert_Expression(exp[2]);
	cout  << ");\n" << "   Data_Count[(int)(";
	Convert_Expression(exp[0]);
	cout << ")]=0;\n   Data_Inputs[(int)(";
	Convert_Expression(exp[0]);
	cout << ")]=";
	Convert_Expression(exp[1]);
	cout <<  ";\n   Data_Outputs[(int)(";
	Convert_Expression(exp[0]);
	cout  << ")]=";
	Convert_Expression(exp[2]);
	cout << ";\n";
	}
//============================================================================
// This instruction will prepare the add data instruction

void Add_Data_After_Curr_Inst::Prepare( State &s )
	{
	if (pcount==4 &&
	    s.Valid_Variable(param[2]) && 
	    s.Get_Type(s.Get_Variable_ID(param[2]))==ARRAY &&
	    s.Valid_Variable(param[3]) &&
	    s.Get_Type(s.Get_Variable_ID(param[3]))==ARRAY)
		{
		array_id1=s.Get_Variable_ID(param[2]);
		array_id2=s.Get_Variable_ID(param[3]);
		}
	list=new Expression *[pcount];
	for (int i=0; i<pcount; i++)
		list[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will execute the add data instruction

void Add_Data_After_Curr_Inst::Execute( State &s )
	{
	int code;
	int data_id=(int)list[0]->Evaluate(s,code);
	if (code!=VALID)
		{
		cout << "Parameter 1: \n";
		Error(id,"Unable to Evaluate");
		Expression_Error(code,id,list[0]);
		exit(0);
		}
	int id_num=(int)list[1]->Evaluate(s,code);
	if (code!=VALID)
		{
		cout << "Parameter 2:\n ";
		Error(id,"Unable to Evaluate");
		Expression_Error(code,id,list[1]);
		exit(0);
		}

	Data_Class *data=s.Get_Data(data_id);

	int in_size=data->Get_In_Size();
	int out_size=data->Get_Out_Size();

	double *in_array, *out_array;

	if (array_id1!=-1)         // Array Pointers are used
		{
		in_array=(double *)s.Get_Data_Ptr(array_id1);
		out_array=(double *)s.Get_Data_Ptr(array_id2);
		}
	else
		{				// Values are used
		in_array=new double[in_size];
	        out_array=new double[out_size];

		double value;
		for (int i=0; i<in_size; i++)
			{
			 
			if (i+2>=pcount)
				{
				Error(id,"Too many data items (input)");
				exit(0);
				}
			value=list[i+2]->Evaluate(s,code);
			if (code!=VALID)
				{
				cout << "Parameter: " << i+2 << "\n";
				Error(id,"Unable to evaluate");
				Expression_Error(code,id,list[i+2]);
				exit(0);
				}
			in_array[i]=value;
			
			}

		for (i=0; i<out_size; i++)
			{
			if (i+in_size+2>=pcount)
				{
				cout << "i+in_size+2: " << i+in_size+2 << 
				  "   pcount: " << pcount << "\n" << flush;
				Error(id,"Too many data items (output)");
				exit(0);
				}
			value=list[i+in_size+2]->Evaluate(s,code);
			if (code!=VALID)
				{
				cout << "Parameter: " << i+2 << "\n";
				Error(id,"Unable to evaluate");
				Expression_Error(code,id,list[i+in_size+2]);
				exit(0);
				}
			out_array[i]=value;
			
			}
		}

	data->Add_Data_After_Curr(id_num,in_array,out_array);   
	s.Set_Value("Data_Count",data->Get_Count(),data_id); // Update sys var
	}
//--------------------------------------------------------------------------
// This function will translate the add data instruction

void Add_Data_After_Curr_Inst::Translate( State &s )
	{
	cout << "// Add Data After Curr- ID: " << id << "\n";

	if (array_id1!=-1)
		{
		cout << "   Data_List[(int)(";
		Convert_Expression(list[0]);
		cout << ")]->Add_Data_After_Curr(";
		Convert_Expression(list[1]);
	        cout << ",\n      " << s.Get_Name(array_id1) << ", " 
			  << s.Get_Name(array_id2) << ");\n";
		}
	else
		{
		cout << "   ___temp_array=new double[" << pcount-2 << "];\n";
		for (int i=2; i<pcount; i++)
			cout << "   ___temp_array[" << i-2 << "]=" <<
				list[i]->Get_Expression() << ";\n";

		cout << "   Data_List[(int)(";
		Convert_Expression(list[0]);
		cout << ")]->Add_Data_After_Curr(";
		Convert_Expression(list[1]);
		cout << 
		   ",\n      ___temp_array, &___temp_array[Data_Inputs[(int)(";
		Convert_Expression(list[0]);
		cout << ")]]);\n   delete ___temp_array;\n";
		cout << "   Data_Count[(int)(";
		Convert_Expression(list[0]);
		cout << ")]++;\n";
		}
	}
//============================================================================
// This instruction will prepare the add data instruction

void Add_Data_Before_Curr_Inst::Prepare( State &s )
	{
	if (pcount==4 &&
	    s.Valid_Variable(param[2]) && 
	    s.Get_Type(s.Get_Variable_ID(param[2]))==ARRAY &&
	    s.Valid_Variable(param[3]) &&
	    s.Get_Type(s.Get_Variable_ID(param[3]))==ARRAY)
		{
		array_id1=s.Get_Variable_ID(param[2]);
		array_id2=s.Get_Variable_ID(param[3]);
		}
	list=new Expression *[pcount];
	for (int i=0; i<pcount; i++)
		list[i]=new Expression(param[i]);
	Clear_Param();
	}
//--------------------------------------------------------------------------
// This function will execute the add data instruction

void Add_Data_Before_Curr_Inst::Execute( State &s )
	{
	int code;
	int data_id=(int)list[0]->Evaluate(s,code);
	if (code!=VALID)
		{
		cout << "Parameter 1: \n";
		Error(id,"Unable to Evaluate");
		Expression_Error(code,id,list[0]);
		exit(0);
		}
	int id_num=(int)list[1]->Evaluate(s,code);
	if (code!=VALID)
		{
		cout << "Parameter 2:\n ";
		Error(id,"Unable to Evaluate");
		Expression_Error(code,id,list[1]);
		exit(0);
		}

	Data_Class *data=s.Get_Data(data_id);

	int in_size=data->Get_In_Size();
	int out_size=data->Get_Out_Size();

	double *in_array, *out_array;

	if (array_id1!=-1)         // Array Pointers are used
		{
		in_array=(double *)s.Get_Data_Ptr(array_id1);
		out_array=(double *)s.Get_Data_Ptr(array_id2);
		}
	else
		{				// Values are used
		in_array=new double[in_size];
	        out_array=new double[out_size];

		double value;
		for (int i=0; i<in_size; i++)
			{
			if (i+2>=pcount)
				{
				Error(id,"Too many data items (input)");
				exit(0);
				}
			value=list[i+2]->Evaluate(s,code);
			if (code!=VALID)
				{
				cout << "Parameter: " << i+2 << "\n";
				Error(id,"Unable to evaluate");
				Expression_Error(code,id,list[i+2]);
				exit(0);
				}
			in_array[i]=value;
			}

		for (i=0; i<out_size; i++)
			{
			if (i+in_size+2>=pcount)
				{
				cout << "i+in_size+2: " << i+in_size+2 << 
				  "   pcount: " << pcount << "\n" << flush;
				Error(id,"Too many data items (output)");
				exit(0);
				}
			value=list[i+in_size+2]->Evaluate(s,code);
			if (code!=VALID)
				{
				cout << "Parameter: " << i+2 << "\n";
				Error(id,"Unable to evaluate");
				Expression_Error(code,id,list[i+in_size+2]);
				exit(0);
				}
			out_array[i]=value;
			}
		}

	data->Add_Data_Before_Curr(id_num,in_array,out_array);   
	s.Set_Value("Data_Count",data->Get_Count(),data_id); // Update sys var
	}
//--------------------------------------------------------------------------
// This function will translate the add data instruction

void Add_Data_Before_Curr_Inst::Translate( State &s )
	{
	cout << "// Add Data After Curr- ID: " << id << "\n";

	if (array_id1!=-1)
		{
		cout << "   Data_List[(int)(";
		Convert_Expression(list[0]);
		cout << ")]->Add_Data_Before_Curr(";
		Convert_Expression(list[1]);
	        cout << ",\n      " << s.Get_Name(array_id1) << ", " 
			  << s.Get_Name(array_id2) << ");\n";
		}
	else
		{
		cout << "   ___temp_array=new double[" << pcount-2 << "];\n";
		for (int i=2; i<pcount; i++)
			cout << "   ___temp_array[" << i-2 << "]=" <<
				list[i]->Get_Expression() << ";\n";

		cout << "   Data_List[(int)(";
		Convert_Expression(list[0]);
		cout << ")]->Add_Data_Before_Curr(";
		Convert_Expression(list[1]);
		cout << 
		   ",\n      ___temp_array, &___temp_array[Data_Inputs[(int)(";
		Convert_Expression(list[0]);
		cout << ")]]);\n   delete ___temp_array;\n";
		cout << "   Data_Count[(int)(";
		Convert_Expression(list[0]);
		cout << ")]++;\n";
		}
	}





