//----------------------------------------------------------------------
// Program: data.h  -  Data Class Header
//
// Author : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: The is the header file for the data class.
//
//----------------------------------------------------------------------

#ifndef DATA_CLASS
#define DATA_CLASS
#define MAX_COLUMNS 500

#include<stdio.h>
#include<stdlib.h>
#include<iostream.h>
 
struct DATA  			// The training/testing set nodes 
       {
       int id;			// Id Number                         
       double *in;		// Pointer to array of input values  
       double *out;		// Pointer to array of output values
       DATA *next;		// Pointer to next data item         
       };

class Data_Class
	{
	public:
		Data_Class( void );
		Data_Class( int input_size, int output_size );
		~Data_Class( void );
		DATA *Convert_to_DATA( int id, double in[], double out[]);
		void Add_Data_After_Curr( DATA *data );
		void Add_Data_Before_Curr( DATA *data );
		void Add_Data_After_Curr( int id, double in[], double out[]);
		void Add_Data_Before_Curr( int id, double in[], double out[]);
		void Delete_Curr_Data( void ); 
		void Load_Data( char filename[],
				int &data_count, int &in, int &out );
		void Save_Data( char filename[]);
		void Find_High_Low( double high_in[], double low_in[],
				    double high_out[], double low_out[] );
		void Get_High_Low( double high_in[], double low_in[], 
				   double high_out[], double low_out[]);
		void Normalize_Data( double high_in[], double low_in[],
				     double high_out[], double low_out[] );
		void Denormalize_Data( void );
		int Get_Count( void ) { return count; };
		int Get_In_Size( void ) { return in_size; };
		int Get_Out_Size( void ) { return out_size; };
		void Reset_to_Head( void ) { prev=NULL; curr=head; };
		void Reset_to_Tail( void ) { while (curr!=tail) Next_Data();};
		void Get_Current_Data( int &id, double in[], double out[] );
		DATA *Get_Current_Data( void ) { return curr; };
		void Next_Data( void ) { prev=curr; curr=curr->next; 
			if (curr==NULL) {prev=NULL; curr=head;} };
		DATA *Get_Data_Head( void ) { return head; };
		void Print_Data( void );
	private:

		DATA *head,*tail,*curr,*prev;    // List pointers
		int count;                 // Number of items in list
		int in_size;               // Number of input components
		int out_size;		   // Number of output components
		double *high_in,*low_in,*high_out,*low_out;  // High/Low info

		DATA *Create_Data( void );

	};

#endif









