//----------------------------------------------------------------------------
// Program: bp.h  - Header Neural Network and 
//		    Backpropagation Neural Network Classes
//
// Author : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This is the header for the generic forward pass neural network 
//	    class, NET, and a derived backpropagation neural network class,
//	    BPNET.
//
//----------------------------------------------------------------------------

#ifndef BP
#define BP

#include<stdio.h>
#include<math.h>
#include<string.h>
#include<stdlib.h>
#include<iomanip.h>
#include<iostream.h>
#include"data.h"
//-----------------------------------------------------------------------------
#define MAX_LAYERS 500
#define MAX_PER_LAYER 500
#define SIG_THRESHOLD 500
#define SIG_GAIN 1
#define MIN_VALUE -32000
#define MAX_VALUE 32000
//-----------------------------------------------------------------------------

	    struct WEIGHT;  // Forward Declaration
	    struct NODE	    // Node definition for nodes in each layer 
		 {
		 int id;
		 double value;		// Computed value of node   
		 double error;		// Error attributed to node 
		 double work;		// Used to compute error 
		 WEIGHT *first_weight;	// Pointer to first weight 
		 double bias;           // Bias term for this node  
	         int node_type;         // Node type 
	 	 };			// associated with node 

	    struct LAYER	// The layers are maintained by these nodes 
		 {
		 NODE *node;
		 int node_count;
		 };

	    struct WEIGHT		// Weight connecting two nodes 
		 {
		 int layer,node;	// Node connected to  
	 	 NODE *input_node;	// Node the weight is connected to 
		 WEIGHT *next;	        // Pointer to node's next weight 
		 double value;		// Weight value 
		 double prev_delta;	// Previous change in weight 
		 };

class NET
	{
	private:
	    int node_counter;
	    void Next_Node( int &lay, int &node );

	protected:
	    LAYER *layer;		// Pointer to network
	    int layer_count;		// Number of network layers
	    int out;			// Output Layer Index        
	    int in_count;		// Number of input layer nodes
 	    int mid_count;		// Number of middle layers
	    int out_count;		// Number of output layer nodes
	    double *high_in,*high_out,*low_in,*low_out;
	    inline double Random( void );
	    inline double Transfer_Function( double );
	    NODE *Create_Nodes( int number );
	    double *Create_Array( int size, double init_value );
	    WEIGHT *curr_weight;
	    int curr_weight_layer, curr_weight_node;
	    int weight_count;

	public:
	    NET( void );
	    WEIGHT *Create_Weight( void );
	    void Set_Node_Type( int layer, int node, int type );
	    void Get_High_Low( double h_i[], double l_i[], 
	    		       double h_o[], double l_o[] );
	    void Set_High_Low( double h_i[], double l_i[], 
	    		       double h_o[], double l_o[] );
	    void Load_Network( char filename[] );
	    void Create_Layers( int layers, int layer_nodes[] );
	    void Print_Network( void );
	    void Fully_Connect_Network( void );
	    void Partially_Connect_Network( void );
	    void Forward_Pass( void );
	    void Run_Network( Data_Class *data, char filename[]="");
	    void Get_Output( double output[] );
	    void Connect_Weight( WEIGHT *wgt, int from_layer, int from_node,
				 int to_layer, int to_node);
	    void Save_Weights( char filename[] );
	    int Get_Layer_Count( void ) { return layer_count; };
	    int Get_Input_Layer_Nodes( void ){ return layer[0].node_count;};
	    int Get_Output_Layer_Nodes( void ){return layer[out].node_count;};
	    void Get_Layer_Nodes( int nodes[] ) 
              {for (int i=0;i<layer_count;i++) nodes[i]=layer[i].node_count;};
	    int Get_Output_Layer( void ) { return out; };
	    void Load_Input_Layer( double data[], int size );	    
	    double Get_Weight( int from_layer, int from_node,
	    		       int to_layer, int to_node);
	    void Set_Weight( int from_layer, int from_node,
			     int to_layer, int to_node, double value );
	    void Remove_Weight( int from_layer, int from_node,
				int to_layer, int to_node );
	    int Valid_Node( int node_layer, int node_pos );
	    void Reset_Current_Weight( void );
	    int Get_Current_Weight( int &from_layer, int &from_node, 
				     int &to_layer, int &to_node, 
				     double &value );
	    void Next_Weight( void );
	    int Get_Weight_Count( void ) { return weight_count; };
	};


class BPNET: public NET
        {
	private:
	    double alpha;		// Momentum                     
	    double beta;		// Learning Rate                
	    double tolerance;		// Training Tolerance           
	    double test_error;		// Total error for test set  
	    double low_test_error;
	    double network_error;
	    long int iteration;		// Current Training Iteration
	    int display_rate;		// iteration between err disp
	    long int max_iterations;    // Max number of iterations to perform
	    long int min_iterations;    // Min number of iterations to perform
	    char *network_file;         // File to store network weights
	    int check_test_set;         // How ofter to test the test set
	    Data_Class *train_data;     // Training set data
	    Data_Class *test_data;      // Testing set data
	    inline int Finished( int test_correct );

       public:
            BPNET( void ) { train_data=NULL; test_data=NULL; }
	    void Test_Testing_Set( int &good_cnt );
	    void Test_Testing_Set1( int &good_cnt );
	    void Test_Testing_Set2( int &good_cnt );
	    void Backward_Pass(DATA *data, double learning_rate,
	    		double momentum );
	    void Set_Learning_Rate( double v ) { alpha=v; };
	    void Set_Momentum( double v ) { beta=v; };
	    void Set_Tolerance( double v ) { tolerance=v; };
	    void Set_Check_Test_Set( int i ) { check_test_set=i; };
	    void Set_Min_Iterations( int i ) { min_iterations=i;};
	    void Set_Max_Iterations( int i ) { max_iterations=i;};
	    void Set_Display_Rate( int i ) { display_rate=i;};
	    void Set_Testing_Data( Data_Class *d ) { test_data=d; };
	    void Set_Training_Data( Data_Class *d ) { train_data=d; };
	    void Set_Network_File( char file[]) { network_file=strdup(file);};
	    void Train( int mode );
	    long int Get_Iteration( void ) { return iteration; };
	    double Get_Error( void ) { return network_error; };
	    void Reset_Error( void ) { network_error=0.0; };
	    double Get_Low_Error( void ) { return low_test_error; };
	    };


#endif














