//----------------------------------------------------------------------
// Program: baseinst.h  -  Base Instruction Class Header
//
// Author : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This is the header for the Base Instruction Classes.
//----------------------------------------------------------------------

#ifndef BASEINST
#define BASEINST

#include<stdio.h>
#include<iostream.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
#include"state.h"
#include"express.h"

#define EMPTY 0
#define EXPRESSION_TYPE 1
#define STRING_TYPE 2

#define TRUE 1
#define FALSE 0

#define QUERY_STRING -1
#define NORMAL_STRING -2
//============================================================================
// Base class for all instructions

class Instruction	
	{
	public:
	        Instruction( int id_num ) { id=id_num; };
		virtual void Execute( State &s ) {};
		virtual void Prepare( State &s ) {};
		virtual void Translate( State &s ) {};
		void Inst_ID( void );
		friend void Get_Parameter_Token( int id, char *&ptr, 
			char token[], int &token_type);
		friend void Error( int id, char s1[], char s2[]=NULL );
		friend void Convert_String( State &s, char *&str, int &type );
		friend void Convert_Expression( Expression *exp );
	protected:
		int id;         // Instruction id number (line number)
	};
//============================================================================
// Basic Parameterized Instruction

class Param_Instruction: public Instruction
	{
	public:
		Param_Instruction(int inst_id, char parameters[], 
			  int num_parameters=1, int enforce_minimum=TRUE );
		void Parse( char parameters[] );
		void Clear_Param( void );
	protected:
		char **param;       // List of parameters
		char *param_type;   // List of parameters type (string,express)
		int num_param;	    // Maximum number of parameters
		int enforce_min;    // Enforce min number of parameters (0,1)
		int pcount;	    // Number of parameters received
	};

#endif














