//----------------------------------------------------------------------
// Program: baseinst.C  -  Base Instruction Classes
//
// Name   : Joey Rogers
// Date   : July 30, 1993
//
// Purpose: This file contains the base instruction classes from which
// 	    all other instrution classes are derived.
//----------------------------------------------------------------------

#include"baseinst.h"

//---------------------------------------------------------------------------
// This function prints an instruction id number (used mainly for debugging)

void Instruction::Inst_ID( void )
	{
	cout << "<" << id << ">" << flush;
	}
//--------------------------------------------------------------------------
// This is a friend fucntion that will print error messages

void Error( int id, char s1[], char s2[] )
	{
	cout << "Error - Line " << id << "\n";
	cout << s1 << s2 << "\n";
	};
//============================================================================
// Constructor for Param_Instruction class - This function will prepare 
// parameter information for use later on

Param_Instruction::Param_Instruction(int inst_id, char parameters[],
	int num_parameters, int enforce_minimum ):Instruction( inst_id )
	{
	pcount=0;                            // Set parameter count to zero
	enforce_min=enforce_minimum;
	num_param=num_parameters;
	param=new char*[num_param];
	param_type=new char[num_param];
	Parse(parameters);		    // Parse Parameters
	}
//--------------------------------------------------------------------------
// This function parses parameters

void Param_Instruction::Parse( char parameters[] )
	{
	char token[80];
	char *ptr=parameters;
	int type;

	Get_Parameter_Token(id,ptr,token,type);
	while (type!=EMPTY)
		{
		if (pcount==num_param)
			{
			Error(id,
			   "Number of parameters has exceeded number allowed");
			exit(0);
			}
		param[pcount]=strdup(token);
		param_type[pcount]=type;
		pcount++;
		Get_Parameter_Token(id,ptr,token,type);
		}

	if (enforce_min && pcount!=num_param)
		{
		Error(id,"Too few parameters");
		exit(0);
		}
	}

//--------------------------------------------------------------------------
// This function frees memory that holds parameter information

void Param_Instruction::Clear_Param( void )
	{
	for (int i=0; i<pcount; i++)
		delete param[i];
	delete param;
	}
//============================================================================
// This is a friend function to get the next parameter token

void Get_Parameter_Token( int id, char *&ptr, char token[], int &token_type)
	{
	char *token_ptr=token;

	while (isspace(*ptr)) ptr++;
	if (*ptr=='"')
		{
		ptr++;
		token_type=STRING_TYPE;
		while (*ptr!='\0' && *ptr!='"')
			{
			*token_ptr=*ptr;
			token_ptr++;
			ptr++;
			}
		if (*ptr!='"')
			{
			Error(id,"No Closing Quote on String");
			exit(0);
			}
		ptr++;
		}
	else if (*ptr!='\0')
		{
		token_type=EXPRESSION_TYPE;
		while (*ptr!=',' && *ptr!='\0')
			{
			*token_ptr=*ptr;
			token_ptr++;
			ptr++;
			}
		}
	else token_type=EMPTY;
	*token_ptr='\0';
	if (*ptr==',') ptr++;
	}
//============================================================================
// This is a friend function to converts a string to command line argument
// if a command line argument is requested

void Convert_String( State &s, char *&str, int &type )
	{
	char buffer[15];

	type=NORMAL_STRING;
	if (strcmp(str,"")==0) type=QUERY_STRING;
	else
		for (int i=0; i<MAX_ENVIRONMENT_STRINGS; i++)
			{
			sprintf(buffer,"Argument %d",i);
			if (strcmp(str,buffer)==0)
				{
				delete str;
				str=strdup(s.Get_Environment_String(i));
				type=i;
				}
			}

	}
//============================================================================
// This is a friend function to convert an expression into a C++ format

void Convert_Expression( Expression *exp )
	{
	char *buffer=exp->Get_Expression();
	char *ptr=buffer;
	while (*ptr!='\0')
		{
		if (*ptr=='[')
			cout << "[(int)(";
		else if (*ptr==']')
			cout << ")]";
		else cout << *ptr;
		ptr++;
		}
	}

