/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       tokens.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef TOKENS_H
#define TOKENS_H

#define GETTOKEN(a)    RCGetToken(RCBuffer, &RCBufferPos, &(a))
#define READINPUTLINE(a)  RCReadALine(a,&RCBuffer,&RCBufferLen,&RCLineNo)
#define GETTOKENLC(a)  {GETTOKEN(a); StringToLower(a);}
#define GETINTLISTTOKEN(a,b) RCGetIntListToken(RCBuffer, &(RCBufferPos), a, b)
#define GETSTRLISTTOKEN(a,b) RCGetStrListToken(RCBuffer, &(RCBufferPos), a, b)
#define GETDOUBLELISTTOKEN(a,b) RCGetDoubleListToken(RCBuffer,&(RCBufferPos),a,b)
#define GETFLOATLISTTOKEN(a,b) RCGetFloatListToken(RCBuffer,&(RCBufferPos),a,b)
#define GETDOUBLETOKEN(a, b) \
    {if(!RCGetDoubleToken(RCBuffer, &RCBufferPos, &(b)))\
		RCERROR3("Error while reading double: ", (a), RCBuffer);}
#define GETFLOATTOKEN(a, b) \
    {if(!RCGetFloatToken(RCBuffer, &RCBufferPos, &(b)))\
		RCERROR3("Error while reading float: ", (a), RCBuffer);}
#define GETINTTOKEN(x, a) \
    {if (!RCGetIntToken(RCBuffer, &RCBufferPos, &(a)))\
		RCERROR3("Error while reading int: ", (x), RCBuffer);}
#define GETCHARTOKEN(x, a) \
    {if (!RCGetCharToken(RCBuffer, &RCBufferPos, &(a)))\
		RCERROR3("Error while reading char: ", (x), RCBuffer);}
#define GETNAMETOKEN   GETTOKEN(p->Name)


/* tokens */
#define  NAMETOKEN         "name"
#define  OFFSETTOKEN       "offset"
#define  SEEDTOKEN         "seed"
#define  RANGETOKEN        "range"
#define  ORDERTOKEN        "order"
#define  LAYERSTOKEN       "layers"
#define  CONVTOKEN         "conv"
#define  ETATOKEN          "eta"
#define  ALPHATOKEN        "alpha"
#define  PERTTOKEN         "pert"
#define  MARGINTOKEN       "margin"
#define  GAINTOKEN         "gain"
#define  OFREQTOKEN        "ofreq"
#define  PRECISIONTOKEN    "precision"
#define  ITERTOKEN         "iter"
#define  DATATOKEN         "data"
#define  DEPTHTOKEN        "depth"
#define  WFILETOKEN        "wfile"
#define  LOGFILETOKEN      "logfile"
#define  RESFILETOKEN      "rfile"
#define  BIASTOKEN         "bias"
#define  NFUNTOKEN         "nfun"
#define  ENDTOKEN          "end"

/* operation tokens */

#define  WLISTTOKEN        "weightlist"
#define  PLISTTOKEN        "proplist"
#define  WMODETOKEN        "weightmode"
#define  TASKTOKEN         "task"

/* noise/data specific tokens */

#define  NITOKEN           "ni"
#define  ASCTOKEN          "asc"
#define  TIMITTOKEN        "timit"

/* connection/mapping tokens */
#define  MAPTOKEN          "map"
#define  IFACETOKEN        "iface"

/* wz specific tokens */
/* if they are WZ specific they should go in WZ.h!!!!! MAJ */
#define  MATRIXTOKEN       "internal"              
#define  PTHRESHTOKEN      "pthresh"
#define  YINITTOKEN        "yinit"
#define  BESTTOKEN         "best"
#define  STRACETOKEN       "strace"
#define  LRSCALETOKEN      "lrscale"

/* connectiion matrix specific tokens */

#define  NOTCONNTOKEN      "0"
#define  FIXTOKEN          "f"
#define  UNFIXTOKEN        "x"
#define  UNFIXPOSTOKEN     "p"
#define  UNFIXNEGTOKEN     "n"

#endif /* TOKENS_H */
