/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       nnf.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef NNF_H
#define NNF_H

extern double tanh();

typedef struct {
    char  *Name;
    double (*F)();
    double (*Fp)();
    void (*setup)();
} nnf_t;

static double linear(x)
double x;
{
    return (double) (x);
}

static double linearp(x)
double x;
{
    return (double) 1.0;
}

static double sigm(x)
double x;
{
    return ((double)(1.0/(1 + exp(-(x)))));
}
static double sigmp(x)
double x;
{
    double d;

    d = 1.0/(1.0 + exp(-(x)));
    return ((double)((1.0 - d) * d));
}
static double tanhp(x)
double x;
{
    double d;

    d = cosh(x);
    return (double) (1/(d*d));
}

#ifdef LOOKUPTABLES
 double tanh_LU();
 double sigm_LU();
 double tanhp_LU();
 double sigmp_LU();
 void tanh_LU_setup();
 void sigm_LU_setup();
#endif

#ifdef LOOKUPTABLES
#define NEURON_FUNCTIONS {     { "tanh" ,  tanh, tanhp, NULL}, \
				   { "sigm",  sigm, sigmp, NULL}, \
				   { "linear", linear, linearp, NULL}, \
				   { "tanh_LU" , tanh_LU, tanhp_LU, tanh_LU_setup}, \
				   { "sigm_LU",  sigm_LU, sigmp_LU, sigm_LU_setup} \
			       }
#else
#define NEURON_FUNCTIONS {     { "tanh" , tanh, tanhp, NULL}, \
				   { "sigm",  sigm, sigmp, NULL}, \
				   { "linear", linear, linearp, NULL}\
			   }
#endif

#define TANH             0
#define SIGM             1
#define LINEAR           2
#define TANH_LU          3
#define SIGM_LU          4

static nnf_t  NeuronFunctions[] = NEURON_FUNCTIONS;


typedef struct nfun_rec {
    struct nfun_rec *r_next;
    char  *Name;
    nnf_t *Func;
    int   N;
    int   *Neurons;
} nfun_t;


#endif /* NNF_H */

