/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       nnclass.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef NNCLASS_H
#define NNCLASS_H

#define MMRelax(net)          (((net)->proc->Relax)((net)))
#define MMAccXtraIn(net)      (((net)->proc->AccXtraIn)((net)))
#define MMResetXtraIn(net)    (((net)->proc->ResetXtraIn)((net)))
#define MMResetErrors(net)    (((net)->proc->ResetErrors)((net)))
#define MMComputeMSE(net)     (((net)->proc->ComputeMSE)((net)))
#define MMPropErrors(net)     (((net)->proc->PropErrors)((net)))
#define MMGetXtraErrors(net)  (((net)->proc->GetXtraErrors)((net)))
#define MMAccDw(net)          (((net)->proc->AccDw)((net)))
#define MMResetDw(net)        (((net)->proc->ResetDw)((net)))
#define MMUpdateWeights(net)  (((net)->proc->UpdateWeights)((net)))
#define MMSaveState(net)      (((net)->proc->SaveState)((net)))
#define MMReadState(net)      (((net)->proc->ReadState)((net)))

typedef struct {
    char *Name;			/* name of class */
    void (*RCRead)();		/* config read proc */
    void (*PrintRec)();         /* config print proc */
    void (*Organise)();		/* allocate memory .... */
    void (*InitState)();	/* init weights proc */
    void (*ReadState)();	/* read weights, ... proc */
    void (*SaveState)();	/* write weights, ... proc */
    void (*Relax)();		/* relax (propagate) */
    void (*PropErrors)();	/* propagate errors (usually backward) */
    void (*AccDw)();    	/* compute weight update */
    void (*UpdateWeights)();	/* update the weights */
    void (*ResetDw)();		/* zero the DWs */
    void (*ComputeMSE)();	/* compute MSE */
    void (*ResetErrors)();	/* reset of ErrIn */
    void (*ResetXtraIn)();	/* reset xtra inputs */
    void (*AccXtraIn)();	/* acumulate XtraIn */
    void (*GetXtraErrors)();	/* accumulate xtra errors */
    void (*Die)();		/* proc for doing things when killed */
} nn_class_t;


#endif /* NNCLASS_H */
