/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       net.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef NET_H
#define NET_H

#include "nnf.h"
#include "iface.h"
#include "nnclass.h"

/* general, class independent net structure */

typedef struct nn_rec {
    struct nn_rec *r_next;
    char *Name;               /* network name */
    int   type;               /* type of net: mlp, ... */
    char  *sys;               /* pointer to system to which it belongs */
    double *XtraIn;            /* Extra neuron inputs */
    double *In;                /* neurons input */
    double *Out;               /* neurons output */
    double *ErrIn;             /* neuron  error feeding in */
    double *ErrOut;            /* neuron  error coming out */
    double MSE;		      /* mean squared error */

    int   non;                /* number of neurons in net */
    int   noi;                /* number of i/p neurons */
    int   noo;                /* number of o/p neurons */

    iface_t *Ifaces;          /* list of interfaces */

    struct nnp_rec {
	struct nnp_rec *r_next, *r_prev;
	struct nn_rec   *nptr;
	char *Name;
    } *MapsIn, *MapsOut;       /* nets representing FEEDING and 
				      reeciving maps */

    char *Wfile;               /* weight file name */
    char *Lfile;               /* log file name */
    FILE *lfp;
    char *Resfile;             /* results file */
    FILE *rfp;

    nfun_t *Nfun;              /* neuron transfer fun. def */
    FFunction *F;
    FFunction *Fp;

    double Bias;	       /* bias value */
    int   Iter;                /* Maximum number of iterations for training */
    int   Ofreq;               /* logging frequency */
    int   DoingWhat;           /* mode of network: TRAINING, OPERATE, 
				 TESTING, FOLLOWUP */

    double Eta;                /* neuron learning rate */
    double Conv;               /* Convergence for learning */
    long  Seed;                /* Seed for Random number */
    int   SeedSet;             /* flag set if user supplied seed */
    double InitWRange;         /* Initial Weight range */
    double Margin;             /* Margin of output error */
    double Alpha;              /* neuron learning momentum */
    char *Private;	       /* pointer to private class specific 
				  structure */
    nn_class_t *proc;	       /* Network Services Functions */
} nn_t;

typedef struct nnp_rec nnp_t;

#endif /* NET_H */
