/*
**      jiggle.h - jiggle include file
**
**      Copyright (C) 1991 by SEDAL, Sydney University Electrical Engineering
**      The material in this file is subject to copyright and may be used as
**      long this copyright banner is retained.
**
**      jiggle.h: version 1.1
**              delta date 92/09/17 07:43:36
**              obtained 92/09/28 23:41:25
*/

#ifdef	sparc
#define	J_DEVICE	"/dev/sbus1"
#else
#define	J_DEVICE	"/dev/vme32d32"
#endif

#define	J_VMESADDR	0x02000000	/* VME start address */
#define	J_PAGESHIFT	16
#define	J_PAGESIZE	(1 << J_PAGESHIFT)
#define	J_PINS		64	/* actually we have 40 analogue & 64 digital */
#define	J_DACBITS	12	/* DAC resolution */
#define	J_ADCBITS	12	/* ADC resolution */
#define	J_ADCMASK	((1 << J_ADCBITS) - 1)

/* addresses decoded for jiggle vme interface */
#define	J_DACADDR	(0x0000/4)
#define	J_ADCADDR	(0x0100/4)
#define	J_RCONFADDR	(0x0200/4)
#define	J_DIOWADDR	(0x0300/4)
#define	J_DIORADDR	(0x0400/4)
#define	J_GETSMPADDR	(0x0500/4)
#define	J_PCONFADDR	(0x0600/4)

/* each pin can be configured as one of the following */
#define	J_INCONFIG	0x00
#define	J_OUTCONFIG	0x01

/* these macros do all the device io stuff */
#define	_j_analogueconf(rly)	(vmeaddr[J_RCONFADDR] = (rly)[0], \
				vmeaddr[J_RCONFADDR + 1] = (rly)[1])
#define	_j_digitalconf(pin)	(vmeaddr[J_PCONFADDR] = (pin)[0], \
				vmeaddr[J_PCONFADDR + 1] = (pin)[1])
#define	_j_dwrite(dreg)		(vmeaddr[J_DIOWADDR] = (dreg)[0], \
				vmeaddr[J_DIOWADDR + 1] = ((dreg)[1]))
#define	_j_dread(aoff)		(vmeaddr[J_DIORADDR + (aoff)])
#define	_j_awrite(x, n)		(vmeaddr[J_DACADDR + (n)] = (n) & 1 ? \
							((x) << 16) : (x))
#define	_j_aread(n)		(((n) & 1 ? (vmeaddr[J_ADCADDR + (n)] >> 16) : \
					vmeaddr[J_ADCADDR + (n)]) & J_ADCMASK)
#define	_j_getsmph()		(vmeaddr[J_GETSMPADDR+1] = 0)
#define	_j_getsmpl()		(vmeaddr[J_GETSMPADDR] = 0)

#define	j_adc2v(d)		(((d) / (double)(1 << J_ADCBITS)) * 10.0 - 5.0)
#define	j_v2dac(d)		((int)((d) * (1 << J_ADCBITS)) / 5)

/* library calls */
extern void	j_pinarrayconf();
extern int	j_dread();
extern void	j_dwrite();
extern unsigned	j_aread();
extern void	j_awrite();
extern int	j_statuscheck();
extern int	j_getsmp();
extern int	j_init();

/* BT stuff */
#define	BT_RRAM		0x1000000
#define	BT_NODE		0x0200000

/* loc_cmd */
#define	CLEAR_ERR	0x80
#define	SWAP_BYTE	0x40
#define	SWAP_WORD	0x20
/* loc_status */
#define	ERR_PARITY	0x80
#define	ERR_BERR	0x40
#define	ERR_TIMEOUT	0x04
#define	NO_POWER	0x01
#define	ERROR_MASK	(ERR_PARITY | ERR_BERR | ERR_TIMEOUT)
/* Remote node command register 2 (read/write) */
#define	PAGE_SIZE_64KB	0x0
#define	PAGE_SIZE_128KB	0x1
#define	PAGE_SIZE_256KB	0x3
#define	PAGE_SIZE_512KB	0x7
#define	PAGE_SIZE_1MB	0xf
#define PAGE_SZ_REG     0
/* Remote node command register 1 (write) */
#define	RESET_REM	0x80
#define	CLR_LOC_INT	0x40
#define	SEND_REM_INT	0x20
#define	LOCK_REM	0x10
#define	EN_PAGE_ADR	0x08
#define	REM_INT_ACK_A3	0x04
#define	REM_INT_ACK_A2	0x02
#define	REM_INT_ACK_A1	0x01
/* Remote node status register (read) */
#define	REM_INT_PENDING	0x20
#define	REM_NOT_LOCKED	0x10
#define	LOC_INTPENDING	0x02
/* Address modifier rem_amod */
#define	AM_32ESPA	0x0E	/* A32 Extended Supervisory Program Access */
#define	AM_32ESDA	0x0D	/* A32 Extended Supervisory Data Access */
#define	AM_32ENPA	0x0A	/* A32 Extended Non-privileged Program Access */
#define	AM_32ENDA	0x09	/* A32 Extended Non-privileged Data Access */
#define	AM_24SSPA	0x3E	/* A24 Standard Supervisory Program Access */
#define	AM_24SSDA	0x3D	/* A24 Standard Supervisory Data Access */
#define	AM_24SNPA	0x3A	/* A24 Standard Non-privileged Program Access */
#define	AM_24SNDA	0x39	/* A24 Standard Non-privileged Data Access */
#define	AM_24HSDA	0x2D	/* A24 Short Supervisory Data Access */
#define	AM_24HNDA	0x29	/* A24 Short Non-privileged Data Access */

typedef	struct
{
	unsigned char	loc_cmd;
	unsigned char	nused1;
	unsigned char	loc_status;
	unsigned char	nused2;
	unsigned char	loc_intctl;
	unsigned char	nused3, nused4, nused5;
	unsigned char	rem_cmd2;
	unsigned char	rem_cmd1_stat;
	unsigned short	rem_page;
	unsigned char	rem_amod;
	unsigned char	nused6;
	unsigned short	rem_iack;
} vmereg_t;


