/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       WZP.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef WZP_H
#define WZP_H

#define CONNTOKEN         "conn"
#define NONTOKEN          "non"
#define SPRIMETOKEN       "derivative_threshold"
#define OUTSTATEEXT       ".ops"

#define CONN(i,j)         (P->Cm[(i)][(j)] != '0')
#define CONN_POS(i,j)     (P->Cm[(i)][(j)] == 'p')
#define CONN_NEG(i,j)     (P->Cm[(i)][(j)] == 'n')
#define PRESERVE_SIGN     if (CONN_POS(i,j)) { \
			     if (P->W[i][j] < 0) P->W[i][j] = 0.0;\
			  } else {\
		              if (CONN_NEG(i,j) && (P->W[i][j] > 0))\
				  P->W[i][j] = 0.0;\
			  }


typedef struct {
    double *val;
} WZptype;

typedef struct wz_rec {
    double *SPrime;              /* derivative w/r to net input to a neuron */
    double *Z;                   /* net input to a neuron */
    double *Yn;		        /* new out */
    char  **Cm;                 /* connection matrix */
    double **W;                  /* weights */
    double **Dw;                  /* weight updates */
    WZptype ***Pe;	        /* Time stepped relaxation matrix */
    WZptype ***Pen;	        /* New time stepped relaxation matrix*/
    int   PatternValid;		/* flag for pattern validity */
    char *OutStateFile;		/* file to store our and p's states */
    char *conn;			/* connectivity matrix as in config file */
    double SPrimeThreshold;	/* threshold for considering derivative */
} wz_t;


#endif /* WZP_H */
