/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       Utils.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef UTILS_H
#define UTILS_H

#ifdef ultrix
#define NO_STRDUP
#endif

#ifdef sequent
#define NO_STRDUP
#define NO_STRSTR
#endif

#ifdef NO_STRDUP
extern char *strdup();
#endif

#ifdef NO_STRSTR
extern char *strstr();
#endif

extern int bit();

#define MINDOUBLE (-1.0 * pow((double) 2.0, (double)(8* sizeof(double))))
#define MAXDOUBLE (pow((double) 2.0, (double)((8* sizeof(double)) - 1)))

extern double RandUniform();
extern void RandReset();
extern double RandNormal();
extern float **matrix();
extern float ***cube();
extern int **imatrix();
extern char **cmatrix();
extern double **dmatrix();
extern double StandardDev();
extern double Norm();
extern int CopyFile();
extern xgraph();
extern char *FileNameOnly();
extern char *MakeFileExt();
extern void StringToLower();
extern void StringToUpper();
extern int AnswerIsYes();
extern int GetInputLine();
extern double cputime();
extern char *FullPathName();
extern int ReadInputLine();
extern int SkipLine();
extern int SkipToNext();
extern int GetDouble();
extern int GetFloat();
extern int GetKey();
extern int GetString();
extern int GetInt();
extern int GetIntList();
extern int GetDoubleList();
extern int GetFloatList();
extern char	*xrealloc();
extern char	*xmalloc();
extern char	*xcalloc();
extern FILE	*xfopen();
extern void	xfatal();

#endif /* UTILS_H */
