/*---------------------------------------------------------------------------- |
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       RBPTTP.h (%M%): version %I%            
|       Author(s): Ming Zhao
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef RBPTTP_H
#define RBPTTP_H

#define RBPTTRelax(net,steps)      (((net)->proc->Relax)((net),(steps)))

#define CONNTOKEN         "conn"
#define NONTOKEN          "non"
#define NOITOKEN          "noi"
#define NOOTOKEN          "noo"
#define SPRIMETOKEN       "derivative_threshold"
#define EPOCHTOKEN        "epochwise"
#define DEPTHTOKEN        "depth"
#define DEPTHPRIMETOKEN   "depthprime"
#define STARTFROMZEROTOKEN   "startfromzero"
#define OUTSTATEEXT       ".ops"

#define SIZEOFDATSET	30  /* default number of steps allowed */

#define CONN(i,j)         (P->Cm[(i)][(j)] != '0')
#define CONN_POS(i,j)     (P->Cm[(i)][(j)] == 'p')
#define CONN_NEG(i,j)     (P->Cm[(i)][(j)] == 'n')
#define PRESERVE_SIGN     if (CONN_POS(i,j)) { \
			     if (P->W[i][j] < 0) P->W[i][j] = 0.0;\
			  } else {\
		              if (CONN_NEG(i,j) && (P->W[i][j] > 0))\
				  P->W[i][j] = 0.0;\
			  }

#define CBP (P->cbufptr)
#define INCCBUFPTR()    if (++CBP > P->cbufmax) CBP = 0
#define DECLCBUFPTR()	if (--lcbufptr < 0) lcbufptr = P->cbufmax

typedef struct rbptt_rec {
    double *SPrime;             /* derivative w/r to net input to a neuron */
    double **S;                 /* sum input to a neuron */
    double **X;                 /* net input to a neuron */
    double **W;                 /* weights */
    double **E;			/* error vecot buffer */
    double **DE;		/* delta error vecot buffer */
    char  **Cm;                 /* connection matrix */
    double **Dw;                /* weight updates */
    int   PatternValid;		/* flag for pattern validity */
    char *OutStateFile;		/* file to store our and p's states */
    char *conn;			/* connectivity matrix as in config file */
    double SPrimeThreshold;	/* threshold for considering derivative */
    int epochwise;		/* a flag for epochwise RBPTT  */
    int startfromzero;		/* a flag for start from zero  */
    int newEpoch;		/* a flag for new epoch  */
    int depth;			/* Depth of BP thru time */
    int depthPrime;		/* Window of advancement thru data */
    int cbufptr;		/* Pointer for circular time buffers */
    int cbufmax;		/* Maximum size of circular time buffers */
} rbptt_t;

#endif /* RBPTTP_H */
