/* $Id: LPUTIL.h,v 1.1 1992/12/07 04:59:22 mume Exp $ */
/***************************************************************************

         Authors: Marwan Jabri

Copyright 1992 by Marwan Jabri and the Systems Engineering and Design
Automation Laboratory, the University of Sydney.

The material in this file is subject to copyright. It may not
be used, copied or transferred by any means without the prior written
approval of the Systems Engineering and Design Automation Laboratory at
Sydney University Electrical Engineering, NSW 2006, Australia. 
It is provided under a license and under the terms and the 
conditions described in an agreement (see the LICENSE file). 

SYDNEY UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL SYDNEY UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
****************************************************************************/
#ifndef LPUTIL_H
#define LPUTIL_H


extern void InitLPState();
extern void ReadLPState();
extern void SaveLPState();
extern void ComputeLPDw();
extern void ComputeLPMSE();
extern void PrintLPRec();
extern void PropLPErr();
extern void LP_Scale();
extern double LP_Quantise();
extern double LP_MWP();
extern double LP_RSA();
extern double LP_SimulatedAnealing();
extern void LP_CSA();
extern void LP_SimmulatedAnealing();

#define GAINEXT ".gan"
#define TEMPERATUREEXT ".tpr"

#define DOSATOKEN          "dosa"
#define NUMBITSTOKEN       "numbits"
#define NUMMWPTOKEN        "nummwp"
#define NUMRSATOKEN        "numrsa"
#define DOGAINTOKEN        "dogain"
#define INITGAINTOKEN      "initgain"
#define GAINFILETOKEN      "gainfile"
#define MAXOUTTOKEN        "maxout"
#define INITTEMPERATURETOKEN    "init_temperature"
#define DELTATEMPERATURETOKEN   "delta_temperature"

#define MMRSA(net)      ((((limited_precision_t *)((net)->Private))->RSA)(net))
#define MMMWP(net,wc)      ((((limited_precision_t *)((net)->Private))->MWP)(net,wc))
#define MMCSA(net)      ((((limited_precision_t *)((net)->Private))->CSA)(net))
#define MMQuantise(net,w,mw)      ((((limited_precision_t *)((net)->Private))->Quantise)(w,mw))
#define MMScale(net,l)      ((((limited_precision_t *)((net)->Private))->Scale)(net,l))

typedef struct limited_precision_rec {
    double **W;                 /* weights */
    int   Nlayers;              /* number of layers */
    int   *Layers;              /* number of neurons in layers */
    int   *Idl;                 /* index of 1st neuron in layers */
    double Pert;                /* Perturbation value for WP */
    int   UseMargin;            /* flag whether to use margin during MSE comp. */
    int   NumBits;              /* number of bits */
    int   NumRSA;               /* number of RSA iterations */
    int   NumMWP;               /* number of MWP iterations */
    int   NeuronMaxInt;         /* maximum int value for a neuron */
    int   WeightMaxInt;         /* maximum int value for a weight */
    int   AccMaxInt;            /* maximum int value for an accumulator */
    int   DoNeuronGains;        /* flag on whether to do neuron gains */
    double InitGain;            /* initialisation value for gain */
    double *Gain;               /* neuron gain. overwrites InitGain*/
    char *GainFile;             /* gain file */
    int    DoSA;		/* do simulated anealing */
    double InitTemperature;	/* initial temperature */
    double DeltaTemperature;	/* temperature change */
    double Temperature;		/* current temperature */
    double MaxOut;		/* maximum output */
    double MaxError;		/* maximum error */
    char *TemperatureFile;	/* file to store temperature */

    /* Limited Precision Routines */
    double (*RSA)();           /* random search algorithm*/
    double (*MWP)();           /* modified weight perturbation*/ 
    void (*CSA)();            /* combined search */
    double (*Quantise)();      /* weight quantization*/
    void (*Scale)();          /* gain scaling */

    /* IMPORTANT */
    char *Private;            /* class specific stuff like lmw_t, kakadu_t ... */

} limited_precision_t;


#endif /* LPUTIL_H */



