/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       KAKADUP.h (%M%): version %I%            
|       Author(s): Marwan Jabri
|       delta date %E% %U%  
|       obtained %D% %T%    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef KAKADUP_H
#define KAKADUP_H

#define INITTEMPERATURETOKEN    "init_temperature"
#define DELTATEMPERATURETOKEN   "delta_temperature"
#define VBIASTOKEN              "vbias"

#define TEMPERATUREEXT ".tpr"

#define CHIPMODETOKEN           "chip_mode"

#define	DFLT_BITS	6
#define	DFLT_VBIAS	0.7

/* equation for a diode connected fet - ibias is related to vbias by this */
#define	K		0.478702
#define	I0		2.00179e-15
#define	idiode(v)	(-I0 * exp(-K * v / 0.025) * (1.0 - exp(v / 0.025)))


typedef struct kakadu_rec {
    double VBias;		/* voltage bias */
    double IBias;               /* corresponding current. (save computation) */
    int    ChipMode;		/* true if in chip mode. dflt numerical mode */
} kakadu_t;


#define	VMC		2.0		/* common negative input to GM */
#define	K_VDD		3.0
#define	K_VMAX		(K_VDD+0.4)
#define	K_VMIN		0.1

#define	NN_L1		10		/* input layer size */
#define	NN_L2		6		/* hidden layer size */
#define	NN_L3		4		/* output layer size */

/*
**	NB. pin numbering has been rearranged so that IM0 is at the top of the
**	shift register. This will cause any simulations to differ from the
**	chip. However, since I was not able to spice simulate anyway, I don't
**	think it will be a problem.
**	Pin number and channel number differ by 1
*/
#define	P_HM5		0
#define	P_OM0		13	/* these are reversed from the cct */
#define	P_OP0		12	/* so that they correspond to lisc */
#define	P_OM1		6
#define	P_OP1		5
#define	P_OM2		4
#define	P_OP2		3
#define	P_OM3		11
#define	P_OP3		10
#define	P_VDD		9
#define	P_PHI1		10
#define	P_PHI2		11
#define	P_RESET		12
#define	P_S0		13
#define	P_S1		14
#define	P_WE		15
#define	P_IIN		16
#define	P_VIN0		17
#define	P_VIN1		18
#define	P_VIN2		19
#define	P_VIN3		20
#define	P_VIN4		21
#define	P_VIN5		22
#define	P_VIN6		23
#define	P_VIN7		24
#define	P_VIN8		25
#define	P_VIN9		26
#define	P_HP0		27
#define	P_HM0		28
#define	P_GND		29
#define	P_VINM		30
#define	P_HP1		31
#define	P_HM1		32
#define	P_HP2		33
#define	P_HM2		34
#define	P_HP3		35
#define	P_HM3		36
#define	P_HP4		37
#define	P_HM4		38
#define	P_HP5		39

#define	DS_COL0		0
#define	DS_COL1		0
#define	DS_ROW0		1
#define	DS_ROW1		0
#define	DS_SR0		0
#define	DS_SR1		1

#define	t_demux(b1, b0)	(j_dwrite((b0), P_S0), j_dwrite((b1), P_S1))
#define	t_clock()	(j_dwrite(1, P_PHI1), \
			j_dwrite(0, P_PHI1), \
			j_dwrite(1, P_PHI2), \
			j_dwrite(0, P_PHI2))
#define	t_rowclk()	(t_demux(DS_ROW1, DS_ROW0), t_clock())
#define	t_colclk()	(t_demux(DS_COL1, DS_COL0), t_clock())
#define	t_rowreset()	(t_demux(DS_ROW1, DS_ROW0), \
			 j_dwrite(1, P_RESET), t_clock(), \
			 j_dwrite(0, P_RESET)) 
#define	t_colreset()	(t_demux(DS_COL1, DS_COL0), \
			 j_dwrite(1, P_RESET), t_clock(), \
			 j_dwrite(0, P_RESET))
#define	t_reset()	(t_rowreset(), t_colreset())
#define	t_dshift(d)	(j_dwrite(d, P_RESET), t_clock())

#endif /* KAKADUP_H */
