/*----------------------------------------------------------------------------
|	
|	Copyright (C) 1992 by SEDAL, 
|	Sydney University Electrical Engineering
|	The material in this file is subject to copyright and may not
|       be used or copied without the prior approval of Sydney University
|       Electrical Engineering
|
|       ENVP.h (ENVP.h): version 1.20            
|       Author(s): Marwan Jabri
|       delta date 92/08/23 19:53:46  
|       obtained 92/08/23 19:54:12    
|	Synopsis: 
|                 
|___________________________________________________________________________*/
#ifndef ENVP_H
#define ENVP_H

#include "obs.h"

#define NSOURCESTOKEN "nsources"
#define NFEEDBACKTOKEN "nfeedback"
#define USEMARGINTOKEN "usemargin"

#define DONORMTOKEN "donorm"
#define NORMTOKEN "norm"
#define SCALETOKEN "scale"
#define NORMTYPETOKEN "normtype"
#define MXOFNORMTYPE 0      /*scale by max and add offset*/
#define MNMXNORMTYPE 1      /*scale between min and max value*/
#define COOFNORMTYPE 2      /*scale by constant and add offset*/
#define MAXFEATURES 20      /*maximum number of features*/

typedef struct feature_rec{
    int f_start, f_end;
    double *Norm;
} feature_t;

typedef struct cp_stack_rec {
    struct cp_stack_rec *r_next;
    pdata_t *cp_ptr;		/* pattern pointer */
    obs_t   *cd_ptr;		/* data set pointer */
} cp_stack_t;

typedef struct env_rec {
    obs_t *Data;		/* Data list */
    pdata_t *CurrentPattern;	/* current pattern being applied used */
    obs_t *CurrentData;		/* current data being used */
    cp_stack_t *Stack;		/* stack for current data pattern pointer */
    int    UseMargin;		/* flag to use margin in error computation */
    int DoNorm;                 /* perform normalization */
    int NormType;               /* type of normalization */
    int NoFeatures;             /* number of features*/
    feature_t Features[MAXFEATURES];  /* feature ranges */
    double Scale;                /* scaling factor, 0=no scale*/
    int **conf;                 /*confusion matrix table*/
    
} env_t;



#endif /* ENVP_H */
