datatype token =
        LPAR | RPAR | QUOTE | DOT | EOF
      | SYM of string
      | BOOL of bool
      | CHAR of int
      | NUM of int 
      | STR of string 

type lexresult = token
type pos = int

val pos = ref 0
fun eof () = EOF

exception LexError of int * string   (* line number, message *)

fun error (e,l) = raise LexError (l,e)

fun mkint (s : string) =
	revfold (fn (a,r) => ord(a)-ord("0")+10*r) (explode s) 0;

fun downcase (s : string) : string =
    let fun downchar ch =
	if (ord "A") <= (ord ch) andalso (ord ch) <= (ord "Z") then
	    chr (ord ch + 32)
	else 
	    ch
    in
	implode (map downchar (explode s))
    end

(* strip removes the first and last character of a string, which
 are assumed to be quotation marks, and replaces "\\\\" with "\\" and
 "\\\"" with "\"" .*)

fun strip (s : string) =
    let fun loop [] = []
	  | loop [c] = []
	  | loop ("\\"::"\\"::t) = "\\"::(loop t)
	  | loop ("\\"::"\""::t) = "\""::(loop t)
	  | loop (h::t) = h::(loop t)
    in
		  implode (loop (tl (explode s)))
    end


		  %%
%structure SexpLex

letter=[A-Za-z];
digit=[0-9] ;
special_initial=[!$%&*/:<=>?~_^];
special_subsequent=[.+-];
peculiar_identifier=[+-];
character_name= (space | newline | SPACE | NEWLINE) ;
whitespace=[\ \t\n] ;
string_element= ([^"\\] | \\\" | \\\\);
comment=\;.*\n ;
number={digit}+ ;
initial=({letter} | {special_initial});
subsequent=({initial} | {digit} | {special_subsequent});
identifier=(({initial}{subsequent}*) | {peculiar_identifier});
character=(#\\{character_name} | #\\.);
string=\"{string_element}*\" ;
delimiter=({whitespace} | [()";]);
%%
\n				=> (inc pos; lex());
[\t\ ]				=> (lex());
{comment}			=> (inc pos; lex());
\(				=> (LPAR);
\)				=> (RPAR);
#t | #T				=> (BOOL(true));
#f | #F				=> (BOOL(false));
'				=> (QUOTE);
" . " 			 	=> (DOT);
{identifier} 			=> (SYM(downcase yytext));
#\\space | #\\SPACE		=> (CHAR(32));
#\\newline | #\\NEWLINE 	=> (CHAR(10));
#\\.			        => (CHAR(ord(hd (tl (tl (explode yytext))))));
{number} 			=> (NUM(mkint yytext));
{string}			=> (STR(strip yytext));
    . 				=> (error ("bad character: " ^yytext, !pos));
    



