
(* This structure takes advantage of the extension in SML of NJ for 
higher-order modules, to package all of the signatures, functors and
structures of the qwertz toolbox in a single structure. 

author: Tom Gordon
date last changed: 24 Mar 94 *)

structure Qwertz =
struct
    signature DATUM = DATUM
    and       EQ = EQ
    and       LEX = LEX
    and       PQUEUE = PQUEUE
    and       PRETTY = PRETTY
    and       RMS = RMS
    and       SET = SET
    and       SPACE = SPACE
    and       SYMBOL = SYMBOL
    and       COMPARE = COMPARE
    and       ELEMENT = ELEMENT
    and       PARSER = PARSER
    and       QUEUE = QUEUE
    and       SEARCH = SEARCH
    and       SEXP = SEXP
    and       STREAM = STREAM
    and       SYMBOL_TABLE = SYMBOL_TABLE
    and       TABLE = TABLE

    functor   AList = AList
    and       BurtonQueue = BurtonQueue
    and       ListSet = ListSet
    and       Search = Search
    and       Stream = Stream
    and       SymbolTable = SymbolTable
    and       TreeSet = TreeSet
    and       Atms = Atms
    and       HashTable = HashTable
    and       ListQueue = ListQueue
    and       ListStream = ListStream
    and       PQueue = PQueue
    and       Sexp = Sexp
    and       Symbol = Symbol
    and       TreeSet = TreeSet
    and       TreeSetTable = TreeSetTable

    structure Pretty = Pretty
    and       Lex    = Lex
    and       Parser = Parser
end
