

signature TABLE =
sig
  structure Key : EQ
  structure Value : ELEMENT

  type table
  exception Get
	  
  val table: unit -> table
  val get: table -> Key.element -> Value.element
  val put: table -> Key.element -> Value.element -> unit
  val copy : table -> table
  val reduce : ((Key.element * Value.element) -> 'a -> 'a) -> 'a 
      -> table -> 'a  
  val put_table : outstream -> table -> unit
  val format : table -> Pretty.block
end;
