	
(* The table size, hash factor and hashing function have been borrowed
from the Pascal example in /vol/sml/tools/mlyacc *)

functor SymbolTable () : SYMBOL_TABLE = 
struct
    structure Sym = Symbol ()
    structure Table =  
	HashTable(structure Key = 
		      struct
			  type element = string
			  fun eq (s1 : string) (s2 : string) = (s1 = s2)
			  fun format s1 = Pretty.string s1
			  fun put os s1 = output(os,s1)
		      end
                 and Value = 
		      struct
			  type element = Sym.symbol
			  val format = Sym.format
			  val put = Sym.put_symbol
		      end
                 and Hash =
                        struct
			    val tableSize = 211
			    val HashFactor = 5
			    fun hash s =
				fold (fn (c,v)=>(v*HashFactor+(ord c)) 
				      mod tableSize) (explode s) 0
			end)

     val counter = ref 0
     val symbols = Table.table ();
    
     open Sym
     open Table

     exception SymTabOverflow

     fun symbol (str : string) : symbol =
	 Table.get symbols str 
	 handle Table.Get => 
	     let val sym = (str,!counter)
	     in
		 Table.put symbols str sym;
		 inc counter;
		 sym
	     end handle Overflow => raise SymTabOverflow
	     
     fun string ((s,_): symbol) = s
end;


	
	

	
