

signature STREAM =  
  sig
    type 'a stream

    val empty_stream : unit -> '1a stream 
    val singleton : '1a -> '1a stream
    val stream : ('1a * '1a stream) -> '1a stream
    val delay : (unit -> '1a stream) -> '1a stream

    exception EmptyStream

    val eos : 'a stream -> bool 
    val head : 'a stream -> 'a
    val tail : 'a stream -> 'a stream
    val next : 'a stream -> ('a * 'a stream)
    val list2stream : '1a list -> '1a stream
    val stream2list : 'a stream -> 'a list
    val append : '1a stream * '1a stream -> '1a stream
    val interleave : '1a stream * '1a stream -> '1a stream
    val accumulate : ('a * 'b -> 'b) ->  'b ->  'a stream -> 'b
    val flatten : '1a stream stream -> '1a stream
    val map : ('a -> '2b) -> 'a stream -> '2b stream
    val filter : ('2a -> bool) -> '2a stream -> '2a stream
    val flatmap : ('a -> '2b stream) -> 'a stream -> '2b stream
  end;
