signature SPACE =
sig
    type state
    type label
    type node

    (* constructors *)
   
    val root : state -> node
    val node : label * node * state -> node

    (* predicates *)

    val isroot : node -> bool

    (* selectors *)

    exception Root

    val label: node -> label
    val parent: node -> node
    val state: node -> state

    (* modifiers *)

    val setParent : node -> node -> unit
    val setLabel  : node -> label -> unit

    (* Equality and Printing *)

    val eq_node  : node -> node -> bool
    val eq_state : state -> state -> bool
    val put_node : outstream -> node -> unit
    val format : node -> Pretty.block

    structure Succ : STREAM    (* for successors *)
	
    type space

    val space : (node -> node Succ.stream) -> space
    val apply : space -> node -> node Succ.stream
end


