(* This is a new implementation, using a modified version of Paulson's 
recursive descent parser generator, instead of ML Yacc *)

signature SEXP =
sig
    structure Symbols : SYMBOL_TABLE

    datatype sexp = 
	Nil
      | Bool of bool
      | Sym of Symbols.Sym.symbol 
      | Int of int    
      | Char of int
      | Str of string 
      | Cons of sexp * sexp

    val equal : sexp -> sexp -> bool

    exception Read of int * string  (* line number, message *)
    exception EOF

    val protect : string -> string
    val format : sexp -> (string -> string) -> Pretty.block

    val read : instream -> sexp
    val write : outstream -> sexp -> unit
    val display : outstream -> sexp -> unit
end;
