
signature QUEUE =  
  sig
    structure E : ELEMENT

    type queue

    exception EmptyQueue
		
    val empty_queue : queue
    val enqueue : queue -> E.element -> queue

    val empty : queue -> bool

    val dequeue : queue -> (E.element * queue)
    val front : queue -> E.element

    val format : queue -> Pretty.block
    val put : outstream -> queue -> unit
  end;

