
(* Priority Queues.  Modelled after the QUEUE signature, but there are
 some significant differences which prevent PQueue structures from
 matching the QUEUE signature.  Unlike QUEUEs, PQUEUEs are designed to
 be implemented using mutable data structures, such as heaps.  Thus,
 following qwertz convention, operations which destructively modify
 priority queues (usually) return the unit value. (dequeue is an
 exception; it returns the element dequeued.) Also, the empty_queue
 value is not a constant here, but a constructor mapping a comparison
 function to a new, empty priority queue. *)


signature PQUEUE =
    sig
	structure E : DATUM

	type queue

	exception EmptyQueue
	
	(* The empty_queue constructor requires a strict ordering relation 
	   on elements.  The enqueue operation may not terminate if it is 
	   only a partial ordering. *)

	val empty_queue : (E.element -> E.element -> bool) ->  queue
	val enqueue : queue -> E.element -> unit

	val empty : queue -> bool

	val dequeue : queue -> E.element
	val front : queue -> E.element

	val format : queue -> Pretty.block
	val put : outstream -> queue -> unit

	(* Replace the largest element with another element.  Equivalent to
	 insert followed by remove.  The new element is returned and the queue
	 left unchanged if it is larger than the largest element in the queue.
	 *)

	val replace : queue -> E.element -> E.element  

    end;
    
