

functor ListStream () : STREAM =
    struct
	type 'a stream = 'a list

	fun empty_stream () = []

	fun singleton x = [x]

	fun stream (h,t) = h::t

	(* no delayed evaluation *)

	fun delay (f : unit -> 'a stream) = f();

	exception EmptyStream

	val eos = null
	val head = hd
	val tail = tl
        fun list2stream l = l
	fun stream2list l = l

	fun next [] = raise EmptyStream
	  | next (h::t) = (h,t)

	val append = op @

	fun interleave ([], s) = s
	  | interleave ((h::t), s) = h::(interleave(s,t))

	fun accumulate f initial str =
	    if eos str then
		initial
	    else
		let val (head,tail) = next str
		in
		    f(head, accumulate f initial tail)
		end

 	val flatten = accumulate append []
	    
	val map = map

	fun filter _ [] = [] 
	  | filter pred (h::t) =
	    if pred h then
		h::(filter pred t)
	    else
		filter pred t

	fun flatmap f str = flatten (map f str)
    end
