(* author: Tom Gordon *)

functor ListQueue(E : ELEMENT): QUEUE =
struct
	structure E = E
     	type queue =  E.element list
	   
	exception EmptyQueue
	   
	val empty_queue = []

	fun empty [] = true 
      	  | empty  _ = false
	   
	fun enqueue [] x = [x]
          | enqueue q  x = q@[x]

	fun dequeue [] = raise EmptyQueue
	  | dequeue (hd::tl) = (hd,tl)

	fun front [] = raise EmptyQueue
	  | front (hd::tl) = hd

	fun put os [] = ()
          | put os (hd::tl) = (E.put os hd; put os tl)

	local open Pretty
	in
	    fun format [] = string "()"
	      | format (hd::tl) = 
		let fun f [] = [string ")"]
		      | f (h::t) = (break 1)::(E.format h)::(f t)
		in
		    block(1,(string "(")::(E.format hd)::(f tl))
		end
	end

end;
	   
	   
		
		
		
