
functor HashTable (structure Key : EQ 
                   and Value : ELEMENT
                   and Hash : sig
			         val tableSize : int
				 val hash : Key.element -> int
			      end) : TABLE =
struct
    structure Key = Key
    structure Value = Value
    structure Array = Array

    type bucket = (Key.element * Value.element) list
    abstype table =  tbl of bucket Array.array
    with

    exception Get

    fun table () : table = tbl (Array.array(Hash.tableSize, [] : bucket ))

    fun put (tbl t) (k : Key.element) (v : Value.element) =
	let val i = Hash.hash k
	in
	    Array.update (t,i,(k,v)::Array.sub(t,i))
	end

    fun get (tbl t) (k1 : Key.element) : Value.element =
	let val i = Hash.hash k1
	    fun f ((k2,v)::r) = if (Key.eq k1 k2) then v else f r 
	      | f [] = raise Get
	in
	    f (Array.sub(t,i))
	end

    fun copy (tbl t) : table =
	let val (tbl new_table) = table()
	    fun f n =  Array.update(new_table,n,Array.sub(t,0))
	    fun loop 0 = f 0
	      | loop n = (f n; loop (n-1))
	in 
	    loop (Hash.tableSize-1);
	    tbl new_table	    
	end

    fun reduce f i (tbl t) =
	let fun loopBucket i [] = i 
	      | loopBucket i (h::t) =
		    loopBucket (f h i) t

	    val limit = Hash.tableSize-1
	    fun doEachBucket n i =
		if n > limit then
		    i
		else
		    doEachBucket (n+1) (loopBucket i (Array.sub(t,n)))
	in
	    doEachBucket 0 i
	end

    fun put_table os (tbl t) : unit =
	let fun putPair (k,v) = 
	          (Key.put os k;
		   output(os,"\t");
		   Value.put os v;
		   output(os,"\n"))
	    
	    fun putBucket [] = ()
	      | putBucket (h::t) = (putPair h; putBucket t)
	    
	    fun loop 0 = ()
	      | loop n = (putBucket (Array.sub(t,n));
			  loop (n-1))
	in
	    loop (Hash.tableSize-1)
	end

    local open Pretty 
    in
	fun format (tbl t) : block =
	    let fun putPair (k,v) = 
		block (!indent, [string "(", 
				 Key.format k, 
				 string " . ",
				 Value.format v,
				 string ")"])
	    
		fun loop 0 = [string ")"]
		  | loop n = 
		    (break 1)::
		    ((map putPair (Array.sub(t,n)))@(loop (n-1)))
	    in
		block(!indent, (string "(")::(loop (Hash.tableSize-1)))
	    end
    end
    end (* abstype table *)
end;
