#include  "defns.i"
#include  "extern.i"

#define	Space(s)	(s == ' ' || s == '\t')
#define	SkipComment	while ( ( c = getchar() ) != '\n' )
#define EndLine		while ( getchar() != '\n' )


Boolean ReadType()
/*      --------  */
{
    int i;
    char Delim, c;
    TypeInfo T;
    TCInfo TC;

    Delim = ReadName(Name);
    if ( ! *Name ) return false;
    else
    if ( Delim != ':' ) Error(1, Name);

    T = (TypeInfo) pmalloc(sizeof(struct _type_rec));
    if(Name[0]=='*')
    {
        T->FixedPolarity = true;
	T->Ordered = true;
        T->Name = CopyString(Name+1);
    }
    else if(Name[0]=='#') /* Type is specified to be unordered */
    {
        T->FixedPolarity = true;
        T->Ordered = false;
        T->Name = CopyString(Name+1);
    }
    else
    {
        T->FixedPolarity = false;
	T->Name = CopyString(Name);
    }
    T->NValues = 0;
    T->Value = Nil;

    if( (c = getchar()) == '@' ) /* Continuous type - no values to read */
    {
        T->Continuous = true;
	ungetchar(c);
	Delim = ReadName(Name);

	T->FixedPolarity = true;
	T->Ordered = false; /* Never match on continuous value - hence
			       no point in checking for orders on it */
    }
    else /* Discrete type, read the values */
    {
        T->Continuous = false;
        ungetchar(c);
	do
	{
	    while ( (Delim = ReadName(Name)) == '\n' )
	        ;

	    if ( T->NValues % 100 == 0 )
	    {
		T->Value = (Const *) 
		           Resize(T->Value,(T->NValues + 100) * sizeof(Const));
	    }

	    if(Name[0]=='*') /* This is a Theory Constant */
	    {
		for(i=0;Name[i++];) Name[i-1]=Name[i];
		
		if (MaxTC % 10 == 0)
		    TheoryConst = (TCInfo *) Resize(TheoryConst, (MaxTC+10) *
						  sizeof(TCInfo));

		TC = (TCInfo) pmalloc(sizeof(struct _const_rec));
		TC->Name = CopyString(Name);
		TC->Type = MaxType + 1;
		TheoryConst[MaxTC++] = TC;
	    }
	    T->Value[ T->NValues++ ] = FindConstant(Name, false);
	}
	while ( Delim == ',' );

	/* Add missing value as possible example of this type */

	if ( T->NValues % 100 == 0 )
        {
	    T->Value = (Const *) 
		           Resize(T->Value,(T->NValues + 100) * sizeof(Const));
	}
	T->Value[T->NValues] = MISSING_DISC;
    }

    if ( Delim != '.' ) Error(2, Name, T->Name);
    EndLine;

    /* Enter Type */
    if ( MaxType % 100 == 0 )
    {
        Type = (TypeInfo *) Resize(Type, (MaxType + 101) * sizeof(TypeInfo));
    }

    Type[++MaxType] = T;
    return true;
}


    ReadTypes()
/*  ---------  */
{
    int i, j;
    TypeInfo T;

    while ( ReadType() )
	;

    ForEach(i, 1, MaxType)
    {
	T = Type[i];

	if(T->Continuous) continue; /* Skip continuous type */

	T->CollSeq = (int *) pmalloc((MaxConst+1) * sizeof(int));
	ForEach(j, 0, MaxConst)
	{
	    T->CollSeq[j] = 0;
	}

	ForEach(j, 0, T->NValues)
	{
	    T->CollSeq[T->Value[j]] = j+1;
	}
    }
}



Tuple ReadTuple(R)
/*    ---------  */
    Relation R;
{
    char c;
    int N, i;
    Tuple T;
    TupleFP TFP;

    N = R->Arity;

    if ( (c = ReadName(Name)) == '.' || c == ';' ) return Nil;

    T = (Tuple) pmalloc((N+1) * sizeof(Const));
    TFP = (TupleFP) T;

    if(R->TypeRef[1]->Continuous)
    {
        if(!strcmp(Name,"?")) /* Missing Value */
	{
	    TFP[1] = MISSING_FP;
	    MissingValueEncountered++;
	}
	else
        {
	    TFP[1] = atof(Name);
	    if(TFP[1]==MISSING_FP)
	    {
	        printf("One of the input continuous values is equal to the\n");
		printf("magic number used to designate missing values.\n");
		printf("Change the definition of MISSING_FP in defns.i\n");
		printf("and recompile\n");
		exit(1);
	    }
	}
    }
    else
        T[1] = FindConstant(Name, true);

    ForEach(i, 2, N)
    {
	c = ReadName(Name);
	if(R->TypeRef[i]->Continuous)
	{
	    if(!strcmp(Name,"?")) /* Missing Value */
	    {
	        TFP[i] = MISSING_FP;
		MissingValueEncountered++;
	    }
	    else
	    {
	        TFP[i] = atof(Name);
		if(TFP[i]==MISSING_FP)
		{
		printf("One of the input continuous values is equal to the\n");
		    printf("magic number used to designate missing values.\n");
		    printf("Change the definition of MISSING_FP in defns.i\n");
		    printf("and recompile\n");
		    exit(1);
	        }
	    }
	}
	else
	    T[i] = FindConstant(Name, true);
    }

    if ( c != ':' && c != '\n' ) ReadToEOLN;

    ForEach(i, 1, N)
    {
	if ( !R->TypeRef[i]->Continuous && !R->TypeRef[i]->CollSeq[T[i]] ) 
            Error(4, ConstName[T[i]], Type[R->Type[i]]->Name);
    }

    return T;
}


Tuple *ReadTuples(R, Plus)
/*     ----------  */
    Relation R;
    Boolean Plus;
{
    Tuple T, *TheTuples;
    int ND = 0;

    TheTuples = (Tuple *) pmalloc(100*sizeof(Tuple));
    while ( T = ReadTuple(R) )
    {
	T[0] = Plus ? PosMark : 0;
        if(ND%100==0) 
	    {
              TheTuples = (Tuple *)prealloc(TheTuples,(ND+100)*sizeof(Tuple));
	    }
	TheTuples[ND++] = T;
    }

    TheTuples[ND] = Nil;

    

    return TheTuples;
}

/****************************************************************************/
/*                                                                          */
/*      SymmetryCheck(R) - checks whether relation R is binary symmetric    */
/*                                                                          */
/*      Trivially compares positive tuples to check, not using the implicit */
/*      ordering in the tuples                                              */
/*                                                                          */
/****************************************************************************/

        SymmetryCheck(R)
/*      -------------    */
    Relation R;
{
    Tuple *TheTuples;
    Boolean *SymCheck;
    int i,j,ntuples,T1,T2 ;


    if(R->Arity!=2 || R->TypeRef[1]->Continuous || R->TypeRef[2]->Continuous)
    {
        return false;
    }

    TheTuples = R->Pos ;

    ntuples = 0 ;
    while (TheTuples[++ntuples]);

    SymCheck = (Boolean*) pmalloc(ntuples*sizeof(Boolean));
    memset(SymCheck,false,(int)ntuples*sizeof(Boolean));

    ForEach(i,0,ntuples-1)
    {
        if(SymCheck[i]) continue; 
        T1 = TheTuples[i][1];
        T2 = TheTuples[i][2];
        for (j = i; ( (j<ntuples)&&!((T1==TheTuples[j][2])
                                  &&(T2==TheTuples[j][1])) ) ; j++);
        if(j==ntuples) return false;
        SymCheck[j]=true;
    }
    free(SymCheck);
    return true;

}



Relation ReadRelation()
/*       ------------  */
{
    Relation R;
    char Delim, c;
    int Key[100], NKeys = 0, i, t;

    if ( ReadName(Name) != '(' ) return Nil;

    R = (Relation) pmalloc(sizeof(struct _rel_rec));
    if(Name[0]=='*')
    {
        R->PossibleTarget = false;
        R->Name = CopyString(Name+1);
    }
    else
    {
        R->PossibleTarget = true;
	R->Name = CopyString(Name);
    }
    R->ConstantCmp = false;

    R->Type = Nil;
    R->TypeRef = Nil;
    R->Arity = 0;

    do
    {
        R->Type = (int*) Resize(R->Type, (++R->Arity+1)*sizeof(int));
        R->TypeRef = (TypeInfo*) Resize(R->TypeRef, 
                                         (R->Arity+1)*sizeof(TypeInfo)); 
	Delim = ReadName(Name);
        t = FindType(Name);
	R->Type[R->Arity] = t; 
        R->TypeRef[R->Arity] = Type[t]; 
    }
    while ( Delim != ')' );

    /*  Read and store access keys  */
    do
    {
	do
	{
	    c = getchar();
	}
	while ( Space(c) ) ;

	if ( c != '\n' )
	{
	    Key[NKeys] = 0;
	    ForEach(i, 1, R->Arity)
	    {
		if ( c == '-' ) Key[NKeys] |= (1 << i);
		c = getchar();
	    }
	    NKeys++;
	}
    }
    while ( c == '/');


    R->NKeys = NKeys;
    if ( NKeys )
    {
	R->Key   = (int *) pmalloc(NKeys * sizeof(int));
	memcpy(R->Key, Key, NKeys * sizeof(int));
    }

    /*ReadToEOLN;*/


    R->Pos = ReadTuples(R, true);

    if ( SectionDelim == '.' )
    {
	R->Neg = R->Opt = Nil;
    }
    else
    {
	R->Neg = ReadTuples(R, false);
    }

    R->BinSym = SymmetryCheck(R);

    return R;
}

/******************************************************************/
/*                                                                */
/*  Read in all the relations by repeated calls to ReadRelation,  */ 
/*  setting up the relation structures and Reln to point to them. */
/*                                                                */
/******************************************************************/

    ReadRelations()
/*  -------------   */
{
    int i;
    Boolean ShowPosNeg;
    Relation ReadRelation();


    i = MaxRel;

    while ( Reln[i] = ReadRelation() )
      {
        printf("\nRelation %s\n", Reln[i]->Name);
        VERBOSE(1)
	{
	    if(Reln[i]->BinSym) printf("is binary symmetric\n");
            ShowPosNeg = Reln[i]->Neg != Nil;
            PrintTuples(Reln[i]->Arity, Reln[i]->Pos,
			ShowPosNeg, false, Reln[i]);
            if ( ShowPosNeg )
	       PrintTuples(Reln[i]->Arity, Reln[i]->Neg, 
			   ShowPosNeg, false, Reln[i]);
	}
        i++;
        if ( i % 100 == 0 ) 
          {
          Reln = (Relation *) prealloc(Reln, (i+100)*sizeof(Relation));
          }
      }
    MaxRel = i - 1;
}




/******************************************************************/
/*								  */
/*  Read a name into string s, returning terminating delimiter.	  */ 
/*  - Embedded spaces are permitted, but multiple spaces are	  */
/*    replaced by a single space.				  */
/*  - Any character after a \ is a valid character.		  */
/*  - The remainder of a line following '|' is ignored.		  */
/*								  */
/******************************************************************/

char ReadName(s)
/*   ---------  */
    char *s;
{
    register char *Sp = s;
    register int c;

    /*  Skip to first non-space character  */

    while ( ( c = getchar() ) == '|' || Space(c) )
	if ( c == '|' ) SkipComment;

    /*  Return period if no names to read  */

    if ( c == EOF )
    {
	return (SectionDelim = '.');
    }
    else
    if ( c == ';' || c == '.' )
    {
	getchar();
	return (SectionDelim = c);
    }

    /*  Read in characters up to the next delimiter  */

    while ( c != ',' && c != '\n' && c != '|' && c != EOF &&
	    c != '(' && c != ')'  && c != ':' && c != '.' )
    {
	if ( c == '\\' ) c = getchar();

	*Sp++ = c;
	if ( c == ' ' )
	    while ( ( c = getchar() ) == ' ' );
	else
	    c = getchar();

	if(c=='.') /* Check for embedded period in number */
	{
	    c = getchar();
	    if(isdigit(c))
	    {
	        *Sp++ = '.';
	    }
	    else
	    {
	        ungetchar(c);
		c = '.';
	    }
	}
    }

    if ( c == '|' )
    {
	SkipComment;
	c = '\n';
    }

    /*  Strip trailing spaces  */

    while ( Space(*(Sp-1)) ) Sp--;
    *Sp++ = '\0';

    return c;
}



	/*  Find a constant in the list of constants, using
	    binary chop search  */

Const FindConstant(N, MustBeThere)
/*    ------------  */
    char *N;
    Boolean MustBeThere;
{
    int i, Hi=MaxConst+1, Lo=0, Differ=1;

    if(!strcmp(N,"?")) 
    {
        MissingValueEncountered++;
    }

    while ( Lo < Hi-1 )
    {
	Differ = strcmp(N, ConstName[SortedConst[i = (Hi + Lo)/2]]);

	if ( ! Differ )		return SortedConst[i];
	else
	if ( Differ > 0 )	Lo = i;
	else			Hi = i;
    }

    if ( MustBeThere ) Error(3, N);

    /*  This is a new constant -- record it  */

    if ( MaxConst % 1000 == 0 )
    {
	ConstName = (char **) Resize(ConstName, 
                                     (MaxConst + 1001) * sizeof(char *));
	SortedConst = (Const *) Resize(SortedConst, 
                                       (MaxConst + 1001) * sizeof(int));
    }

    MaxConst++;
    Lo++;
    for ( i = MaxConst ; i > Lo ; i-- )
    {
	SortedConst[i] = SortedConst[i-1];
    }
    SortedConst[Lo] = MaxConst;
    ConstName[MaxConst] = CopyString(N);

    return MaxConst;
}


	/*  Find a type by name  */

int FindType(N)
/*  --------  */
    char *N;
{
    int i;

    ForEach(i, 1, MaxType)
    {
	if ( ! strcmp(N, Type[i]->Name) ) return i;
    }

    Error(5, N);
}


    
    PrintTuples(N, TT, ShowClass, UseVars, R)
/*  -----------  */
    int N;
    Tuples TT;
    Boolean ShowClass, UseVars;
    Relation R;

{
    int i;

    if ( ! TT ) return;

    if(UseVars)
    {
        ForEach(i,1,MaxVar) CTypes[i] = Variable[i]->Continuous;
    }
    else
    {
        ForEach(i,1,R->Arity) CTypes[i] = R->TypeRef[i]->Continuous;
    }

    while ( *TT )
    {
	printf("\t\t");

	PrintTuple(*TT, N);

	if ( ShowClass )
	{
	    printf(": %c", (Positive(*TT) ? '+' : '-') );
	}

	putchar('\n');
	TT++;
    }

}



    PrintTuple(C, N)
/*  ----------  */
    Tuple C;
    int N;

{
    int i;
    TupleFP CFP;

    CFP = (TupleFP) C;

    ForEach(i, 1, N)
    {
        if(CTypes[i]) /* This constant is of continuous type */
	    fp_print(CFP[i]);
	else
	    printf("%s", ConstName[C[i]]);
	if ( i < N ) putchar(',');
    }
}



    PrintLiteral(R, RSign, A)
/*  --------------  */
    Relation R;
    Boolean RSign;
    Vars A;
{
    int i, v;

    if ( ! RSign && ! R->ConstantCmp && ! (R==SAMEVAR) && !(R==CONTGT) ) 
        printf("~");

    if( R==SAMEVAR )
    /* Special Print Out For Equality Relation */
    {
        printf("%s%s%s", Variable[A[1]]->Name, RSign ? "=":"<>",
                         Variable[A[2]]->Name);
    }
    else if( R==CONTGT )
    /* Special Print Out for Greater Than Relation */
    {
        printf("%s%s%s", Variable[A[1]]->Name, RSign ? ">":"<=",
                         Variable[A[2]]->Name);
    }
    else
        if( R->ConstantCmp )
	{
	    if(R->ConstantCmp==1)
	    /* Special Print Out For (In/)Equality with Theory Constant */
	    {
	        printf("%s%s%s", Variable[A[1]]->Name, 
		       RSign?"=":"<>", R->Name);
	    }
	    else
	    /* Special Print Out For Threshold */
	    {
	        printf("%s%s%g", Variable[A[1]]->Name, 
		       RSign?">":"<=", R->TheConstant);
	    }

	}
        else
	{
            printf("%s", R->Name);
	    ForEach(i, 1, R->Arity)
	    {
	        v = A[i];
		printf("%c%s", (i > 1 ? ',' : '('), 
                               (v ? Variable[v]->Name : "*"));
	    }
	    printf(")");
	}
}



    PrintClause(R, C)
/*  ---------------  */
    Relation R;
    Clause C;
{
    int Lit, i, j;
    Literal L;
    char **TheoryConstNames;
    Boolean ClauseHasTheoryConst, FirstLiteralToPrint;

    TheoryConstNames = (char**) pcalloc(MAXARITY+1,sizeof(char *));

    ClauseHasTheoryConst = false;
    for ( Lit = 0 ; L = C[Lit] ; Lit++ )
    {
        if( L->Rel->ConstantCmp==1 && L->Sign && L->Args[1]>Target->Arity)
	/* This Literal is of form Variable = Theory Constant, hence setup
	   names for nonstandard printing */
	{
	    ClauseHasTheoryConst = true;
	    TheoryConstNames[L->Args[1]] = CopyString(L->Rel->Name);
	}
    }

    if (ClauseHasTheoryConst)
    /* Temporarily modify Variable names for printing, then print without
       the Theory Constant Literals, and restore Variable names */
    {
        j = 0 ;
	for( i = 0 ; i <= MAXARITY ; i++ )
	{
	    if(TheoryConstNames[i])
	    {
		Variable[i]->Name = TheoryConstNames[i];
	    }
	    else
	    {
		Variable[i]->Name = VariableName[j++];
	    }
	}
	PrintLiteral(R, true, DefVars);
	FirstLiteralToPrint = true;
	for ( Lit = 0 ; (L = C[Lit]) ; Lit++ )
	{
	    if( !( (L->Rel->ConstantCmp==1) && L->Sign 
                                       && L->Args[1]>Target->Arity) )
	    {
		if ( FirstLiteralToPrint )
		{
 		    printf(" :- ");
		    FirstLiteralToPrint = false;
		}
		else
		{
		    printf(", ");
		}
		PrintLiteral(L->Rel, L->Sign, L->Args);
	    }
	}
	for( i = 0 ; i <= MAXARITY ; i++ )
	     Variable[i]->Name = VariableName[i];
    }
    else /* Standard Case */
    {
        PrintLiteral(R, true, DefVars);

        for ( Lit = 0 ; (L = C[Lit]) ; Lit++ )
	{
	    if ( Lit == 0 )
	    {
	        printf(" :- ");
	    }
	    else
	    {
	        printf(", ");
	    }

	    PrintLiteral(L->Rel, L->Sign, L->Args);
        }
    }

    newline;
    free(TheoryConstNames);

}



    PrintDefinition(R)
/*  ---------------  */
    Relation R;
{
    int Cl;
    Clause C;

    newline;
    for ( Cl = 0 ; C=R->Def[Cl] ; Cl++ )
    {
	PrintClause(R, C);
    }
}


    Number(T)
/*  ------  */
    Tuple *T;
{
    int Count = 0;

    if ( ! T ) return 0;

    while ( *T++ )
    {
	Count++;
    }

    return Count;
}


    /*  Free up a bunch of tuples  */

    Discard(TT, TuplesToo)
/*  -------  */
    Tuples TT;
    Boolean TuplesToo;
{
    Tuple *P;

    if ( TuplesToo )
    {
	for ( P = TT ; *P ; P++ )
	{
	    free(*P);
	}
    }

    free(TT);
}


char *CopyString(s)
/*    ----------  */
    char *s;
{
    char *new;
    int l;

    l = strlen(s) + 1;
    new = pmalloc(l);
    memcpy(new, s, l);

    return new;
}



    Error(n, s1, s2)
/*  -----  */
    int n;
    char *s1, *s2;
{
    switch ( n )
    {
        case 1:	printf("Illegal delimiter after %s\n", s1);
		exit();

	case 2:	printf("Something wrong after %s in type %s\n", s1, s2);
		exit();

	case 3: printf("Undeclared constant %s\n", s1);
		exit();

	case 4: printf("Constant %s is not of type %s\n", s1, s2);
		exit();

	case 5: printf("Undeclared type %s\n", s1);
		exit();
    }
}

        
/****************************************************************************/
/*                                                                          */
/*      InitialiseVars - set up the variable records                        */
/*                                                                          */
/****************************************************************************/

    InitialiseVars()
/*  --------------  */

{
    VarInfo V;
    int i;

    Variable = (VarInfo*) pmalloc( (MAXARITY+1)*sizeof(VarInfo));
    ForEach(i,0,MAXARITY)
    {
        V = (VarInfo) pmalloc(sizeof(struct _var_rec));
        V->Name = VariableName[i];
        V->Type = 0 ;
	V->Depth = 0 ;
	V->NonDetOccurs = 0;
	V->DetDeps = 0;
	V->DetLits = (int*)pcalloc(10,sizeof(int)); 
	V->OriginalVar = 0;
        Variable[i] = V;
    }
}        


/*****************************************************************************/
/*                                                                           */
/*  SetUpRelations() - Set Up all relations, variable equality, equality with*/
/*                     a theory constant, and relations explicitly input.    */
/*                                                                           */
/*****************************************************************************/

    SetUpRelations()
/*  --------------  */

{
    Relation R;
    int i, j, t;
    char c;

    Reln = (Relation *)pmalloc(100*sizeof(Relation));

    /*  Set up equality relation in Reln[0]  */

    SAMEVAR = (Relation) pmalloc(sizeof(struct _rel_rec));

    SAMEVAR->Name = "=";
    SAMEVAR->PossibleTarget = false;
    SAMEVAR->Arity = 2;
    SAMEVAR->ConstantCmp = false;

    SAMEVAR->Type = (int*)pmalloc(3*sizeof(int));
    SAMEVAR->TypeRef = (TypeInfo*)pmalloc(3*sizeof(TypeInfo));
    ForEach(i,0,2)
      {
        SAMEVAR->Type[i] = 0;
        SAMEVAR->TypeRef[i] = Nil;
      }

    SAMEVAR->Neg = Nil;
    SAMEVAR->Pos = (Tuple *) pmalloc((MaxConst+1) * sizeof(Tuple));

    /* Equality relation excludes missing value */
    ForEach(i, 0, MaxConst - 2)
    {
        SAMEVAR->Pos[i] = (Tuple) pmalloc(3 * sizeof(int));
        SAMEVAR->Pos[i][1] = SAMEVAR->Pos[i][2] = i + 2;
    }
    SAMEVAR->Pos[MaxConst-1] = Nil;

    SAMEVAR->BinSym = true;

    /*  Set up greater than relation in Reln[1]  */

    CONTGT = (Relation) pmalloc(sizeof(struct _rel_rec));

    CONTGT->Name = ">";
    CONTGT->PossibleTarget = false;
    CONTGT->Arity = 2;
    CONTGT->ConstantCmp = false;

    CONTGT->Type = (int*)pmalloc(3*sizeof(int));
    CONTGT->TypeRef = (TypeInfo*)pmalloc(3*sizeof(TypeInfo));
    ForEach(i,0,2)
    {
        CONTGT->Type[i] = 0;
        CONTGT->TypeRef[i] = Nil;
    }

    CONTGT->Neg = Nil;
    CONTGT->Pos = Nil; /* Use direct relative ordering comparison not Join */
    CONTGT->BinSym = false;

    MaxRel = 2;

    for ( i = 0 ; i < MaxTC ; i++)
    {
        printf("\nConstant %s of Type %s Permitted in Definition \n",
                   TheoryConst[i]->Name,Type[TheoryConst[i]->Type]->Name);
        R = (Relation) pmalloc(sizeof(struct _rel_rec));
	R->Arity = 1;
	R->ConstantCmp = 1;
	R->Type = (int*) pmalloc(2*sizeof(int));
	R->Type[0] = 0;
	R->TypeRef =  (TypeInfo*) pmalloc(2*sizeof(TypeInfo));
	R->TypeRef[0] = Nil;
	R->Pos = (Tuple *) pmalloc(2 * sizeof(Tuple));
	R->Pos[0] = (Tuple) pmalloc(2 * sizeof(int));
	R->Pos[0][0] = 0;
	R->Pos[1] = Nil;
	R->Neg = Nil;
	R->BinSym = false;

	R->PossibleTarget = false;

	t = TheoryConst[i]->Type;
	R->Type[1] = t;
	R->TypeRef[1] = Type[t];
        R->Name = CopyString(TheoryConst[i]->Name);
	R->Pos[0][1] = FindConstant(TheoryConst[i]->Name,true);

	Reln[MaxRel++] = R;
        if ( MaxRel % 100 == 0 ) 
          {
          Reln = (Relation *) prealloc(Reln, (MaxRel+100)*sizeof(Relation));
          }

    }

    ReadRelations();

}

/* fp_print(X) - print X, checking if it's a missing value */

fp_print(X)

ConstFP X;

{
    if(X==MISSING_FP) printf("%s", ConstName[MISSING_DISC]);
    else printf("%g",X);
    return;
}
