#include  "defns.i"
#include  "extern.i"

int	FalsePositive,
	FalseNegative;


Literal FindLiteral()
/*      -----------  */

{
    int i;
    Literal SelectLiteral();

    NPossible = 0;
    BaseInfo = Info(Pos, Tot);
    MaxPossibleGain = Pos * BaseInfo;

    VERBOSE(1)
    {
	printf("\nTraining set (%d/%d=%.1f bits, %.1f bits available):\n",
	       Pos, Tot, MaxPossibleGain, AvailableBits);
	VERBOSE(3)
	    PrintTuples(MaxVar, TrainingSet, true, true, Nil);
	newline;
    }

    FindLitCostInfo();

    /* Thresholding on continuous variables */

    if(ContinuousVariables)
    {
        ForEach(i,1,MaxVar)
	{
	    if(Variable[i]->Continuous
	       &&Variable[i]->PossValues>1 && (BestLitGain<MaxPossibleGain))
	    {
	        Threshold(i,ThreshArgs,PossibleRelns);
	    }
	}
    }

    for ( i = 0 ; i <= MaxRel && BestLitGain < MaxPossibleGain ; i++ )
    {
	if ( PossibleArgLists[i] )
	{
	    CheckRelation(RelnOrder[i], PossibleArgLists[i], PossibleRelns);
	}
    }

    free(PossibleArgLists); /* As allocated in FindLitCostInfo() */

    if ( NDeterminate && BestLitGain < DETERMINATE * MaxPossibleGain )
    {
	return Nil;
    }
    else
    if ( NPossible )
    {
	return SelectLiteral();
    }
    else
    {
	VERBOSE(1) printf("\nNo literals\n");
	return Nil;
    }
}



Clause FindClause()
/*     ----------  */
{
    Tuple Case, *TSP;
    Literal L;
    int i, j, l, Lit;
    VarInfo V;

    /* Initialise CompactClause - the best complete clause so far */

    CompactClause = Nil;
    CompactClCover = 0;
    CompactClNLit = 0;

    /* Initialise Variables, Partial Order Info etc */

    InitialiseClauseInfo();

    /* Check for possibility of fast-forwarding to point where last clause
       intoduced a literal on the basis of gain */

    if( FASTFORWARD && AllDeterminateClause[0] )
    {
        BootClause();
    }

    /* Grow the clause from this point */

    GrowNewClause(true);

    /* Check whether clause ended with one or more (non-recursive) literals, 
       all of which had arguments that were lhs variables, and has
       literals with other variables
       - if so, regrow clause from last literal(s) as might be simpler */

    RegrowNewClause();

    /* Check whether compact clause found during development was preferable */

    if( (CompactClCover>OrigPosCov) ||
        ( (CompactClCover==OrigPosCov) && 
	  ( (CompactClNLit<NLit) || (OrigTotCov>OrigPosCov) ) ) )
    {
        VERBOSE(1)
	{
	    printf("\n\Substituting better shorter clause\n\t");
	    PrintClause(Target,CompactClause);
	}
	NewClause = CompactClause;
	OrigPosCov = OrigTotCov = CompactClCover;

	ForEach(l,1,MAXARITY)
	{
	    V = Variable[l];
	    V->OriginalVar = 0;
	}
	NLit = 0;
	while(L = NewClause[NLit++])
	{
            if(L->Rel==SAMEVAR && L->Sign) RecordEquivalence(L->Args);
	}
	NLit = CompactClNLit;
	RecoverTrainingSet(NewClause);
	CheckOriginalCaseCover();
    }

    /* Clause existence and accuracy check - prior to pruning */
    if ( ! NLit  || OrigPosCov < MINACCURACY * OrigTotCov )
    {
	if ( NLit )
	{
	    VERBOSE(1) printf("\nClause too inaccurate (%d/%d)\n", 
			                              OrigPosCov, OrigTotCov);
	}

	free(NewClause);
	return Nil;
    }

    /*  Print Out to check Determinate Literal dependency info */

    VERBOSE(3)
    {
        printf("\n Raw clause info \n");
	for ( Lit = 0 ; Lit < NLit ; Lit++ )
        {
            L = NewClause[Lit];
	    PrintLiteral(L->Rel, L->Sign, L->Args);
	    if(L->FloatingDet)printf(" is a floating determinate literal");
	    newline;
        }
        printf("\n Variable Info \n");
	ForEach(i,1,MaxVar)
        {
            printf("%s ",Variable[i]->Name);
	    if(j=Variable[i]->OriginalVar)
	        printf("Is equal to %s and ",Variable[j]->Name);
	    if(Variable[i]->DetDeps)
	    {
	        printf("Due to (then floating) determinate literals ");
		for(j = 0; j<Variable[i]->DetDeps; j++)
		    printf("%d ",Variable[i]->DetLits[j]);
	    }
	    else printf("Not due to a determinate literal");
	    newline;
	}
    }

    NewClause[NLit] = Nil;
    PruneClause(NewClause, NLit);

    FalsePositive += OrigTotCov - OrigPosCov;
    FalseNegative -= OrigPosCov;

    MaxVar = Target->Arity;

    /*  Set bits for positive covered tuples  */

    ClearBits;

    for ( TSP = TrainingSet ; Case = *TSP ; TSP++ )
    {
	if ( Positive(Case) ) SetBit(Case[0]&Mask, TrueBit);
    }

    /*  Copy all negative tuples and uncovered positive tuples  */

    Tot = Pos = 0;

    for ( TSP = CopyTrainingSet ; Case = *TSP ; TSP++ )
    {
	if ( ! Positive(Case) || ! TestBit(Case[0]&Mask, TrueBit) )
	{
	    CopyTrainingSet[Tot++] = Case;
	    if ( Positive(Case) ) Pos++;
	}
    }
    CopyTrainingSet[Tot] = Nil;

    if ( Pos )
    {
	Discard(TrainingSet, true);
	TrainingSet = CopyTrainingSet;
    }

    CheckOriginalCaseCover();

    /* Print out the recursive literal argument ordering info */

    VERBOSE(2)
    {
        if(NRecLitCl)
	{
            printf("\n\tRecursive literal argument call pattern:\n");
	    ForEach(i,1,NRecLitCl)
	    {
	        printf("\t\t");
		ForEach(j,1,Target->Arity) printf(" %c", RecLitCl[i][j]);
		printf("\n");
	    }
	}
    }


    return NewClause;
}



    FindDefinition(R)
/*  --------------  */
    Relation R;
{
    int i;

    Target = R;
    NCl = 0;

    printf("\n----------\n%s:\n", R->Name);
    InitialiseTrainingSet(R);
    CheckOriginalCaseCover();
    CopyTrainingSet = TrainingSet;

    AllDeterminateClause = (Clause*)pmalloc(100*sizeof(Clause));
    AllDeterminateClause[0] = Nil;
    ADC = 0;

    memset(ArgOrderedDef,false, MAXARITY+1);
    ForEach(i,1,MaxType) memset(TypeOrderDef,false,2);

    NRecLitDef = 0;
    RecLitDef = Nil;

    FalsePositive = 0;
    FalseNegative = Pos;

    R->Def = (Clause *) pmalloc(100 * sizeof(Clause));

    while ( Pos && (R->Def[NCl] = FindClause()) )
    { 
	R->Def[NCl++][NLit] = Nil;
        if(NCl%100==0) R->Def = (Clause *) prealloc(R->Def,
                                                 (NCl+100) * sizeof(Clause));

	ForEach(i,1,MaxType)
	{
	    TypeOrderDef[i][0] = TypeOrderCl[i][0];
	    TypeOrderDef[i][1] = TypeOrderCl[i][1];
	}

	if(RecLitDef)
	{
	    ForEach(i,0,NRecLitDef)
	        free(RecLitDef[i]);
	    free(RecLitDef);
	}
	NRecLitDef = NRecLitCl;
	RecLitDef = RecLitCl;
	    

    }

    R->Def[NCl] = Nil;

    OrderClauses();
    SiftClauses();

    if ( FalsePositive || FalseNegative )
    {
	printf("\n***  Warning: the following definition\n");

	if ( FalsePositive )
	{
	    printf("***  matches %d tuple%s not in the relation\n",
		FalsePositive, Plural(FalsePositive));
	}

	if ( FalseNegative )
	{
	    printf("***  does not cover %d tuple%s in the relation\n",
		FalseNegative, Plural(FalseNegative));
	}
    }

    PrintDefinition(R);
}

/*****************************************************************************/
/*                                                                           */
/*      ZeroVariableInfo(V) - zero assorted variable data.                   */
/*                                                                           */
/*****************************************************************************/

    ZeroVariableInfo(V)
/*  ----------------    */

VarInfo V;
{
    V->Type = 0;
    V->Depth = 0;
    V->NonDetOccurs = 0;
    V->OriginalVar = 0;
    V->DetDeps = 0;
    if(V->DetLits) free(V->DetLits);
    V->DetLits = (int*)pcalloc(10,sizeof(int)); 
}

/*****************************************************************************/
/*                                                                           */
/*      RecordEquivalence(A) - record the equivalence of the variables in A  */
/*                                                                           */
/*****************************************************************************/

    RecordEquivalence(A)
/*  -----------------    */

Vars A;
{
    if(A[1]<A[2]) /* This test is currently redundant as should be true */
    {
	Variable[A[2]]->OriginalVar = (Variable[A[1]]->OriginalVar ?
                                       Variable[A[1]]->OriginalVar : A[1]);
    }
    else
    {
        printf("\n Argument list out of order in RecordEquivalence\n");
	exit(1);
    }
}

/*****************************************************************************/
/*                                                                           */
/*       UnfloatAssocDets(L) - change the status of all floating determinate */
/*                             literals associated with the introduction of  */
/*                             the variables in L to be non-floating         */
/*                                                                           */
/*****************************************************************************/

    UnfloatAssocDets(L)
/*  ----------------   */

Literal L;

{
    int i, j, Lit;
    VarInfo V;
    Vars A;
    Boolean Duplicate;

    A = L->Args;
    ForEach(i,1,L->Rel->Arity)
    {
        V=Variable[A[i]];
	Duplicate = false;
	ForEach(j,i+1,L->Rel->Arity) Duplicate = (A[j]==A[i]);
	if(!Duplicate) V->NonDetOccurs++;
        for ( j = 0 ; j < V->DetDeps ; j++ )
	{
            Lit = V->DetLits[j];
	    NewClause[Lit]->FloatingDet = false;
	}
    }
}
/*****************************************************************************/
/*                                                                           */
/*  BootClause() - Bootstrap the new clause with the portion of the prior    */
/*                 clause which preceded the first non-determinate literal.  */
/*                                                                           */
/*****************************************************************************/

    BootClause()
/*  ----------  */

{
    int N, SubCl, SaveWeakLiterals;
    Literal L, LL;

    VERBOSE(1)
    {
	printf("\nTraining set (%d/%d=%.1f bits, %.1f bits available):\n",
	        Pos, Tot, Pos*Info(Pos,Tot), Except(Tot,Pos));
	VERBOSE(3)
	  PrintTuples(MaxVar, TrainingSet, true, true, Nil);
	newline;
	printf("\n Initialising with prior determinate literals \n");
    }

    SubCl = 0;
    while( AllDeterminateClause[SubCl] )
    {
        SaveWeakLiterals = WeakLiterals;
	OldMaxVar = MaxVar;
	NDeterminate = 0;

	while ( L = AllDeterminateClause[SubCl][NDeterminate++] )
	{
	    LL = (Literal)pmalloc(sizeof(struct _lit_rec));
	    LL->Rel  = L->Rel;
	    LL->Sign = L->Sign;
	    LL->Bits = L->Bits;

	    N = L->Rel->Arity + 1;
	    LL->Args = (Vars) pmalloc(N);
	    memcpy(LL->Args, L->Args, N);

	    LL->FloatingDet = true;

	    VERBOSE(1)
	    {
                putchar('\t');
		PrintLiteral(L->Rel, L->Sign, L->Args);
		newline;
	    }

	    NewClause[NLit++] = LL ;
	    if((NLit)%100==0) 
	    {
                NewClause=(Clause)prealloc(NewClause,
                                    (NLit+NDeterminate+100)*sizeof(Literal));
            }

	    NewSize = 0;
	    FormNewTrainingSet( LL->Rel, true, LL->Args);
	    NewVariableDependencies(LL);
	    AcceptNewTrainingSet( LL->Rel, true, LL->Args );
	}

	WeakLiterals = SaveWeakLiterals + 1;
	SubCl++;
    }
    CheckOriginalCaseCover();
    DiscoverPartialOrders();

    ADC = SubCl;

}

/*****************************************************************************/
/*                                                                           */
/* FindLitCostInfo - finds the information required to determine the coding  */
/*                   cost of literals - the number of relations with possible*/
/*                   argument lists, and the number of such possible argument*/
/*                   lists for each such relation. Uses variable and partial */
/*                   order info.                                             */
/*                                                                           */
/*****************************************************************************/

    FindLitCostInfo()
/*  ---------------  */

{
    int i;

    long clock();

    PossibleRelns = 0;
    EqualityRelnArgs = 0;
    PossibleArgLists = (int *) pcalloc((MaxRel+1),sizeof(int));

    ThreshArgs = 0;
    RelnArgPairs = 0;

    ForEach(i, 0, MaxRel)
    {
	/*  Recursive lits can't be first and require a partial order  */

	if ( RelnOrder[i] != Target || (NLit>0) && AnyPartialOrder )
	{
	    if ( PossibleArgLists[i] = NumberArgLists(1, MaxVar, true, 
                                                        RelnOrder[i], 0) )
	    {
	        /* Coding Equalities with Theory Constants as though
		   part of the Equality Relation - hence need to determine
		   number of possible argument lists for the pseudo-relation:
		   Equality with Variable or Theory Constant */
	        if(RelnOrder[i]==SAMEVAR || RelnOrder[i]->ConstantCmp)
		{
		    if(!EqualityRelnArgs)
		    {
		        PossibleRelns++;
		    }
		    EqualityRelnArgs += PossibleArgLists[i];
		}
		else
		{
		    PossibleRelns++;
		}
	    }
	}
	else
	{
	    PossibleArgLists[i] = 0;
	}
    }

    /* Aspects relating to continuous variable thresholding */

    ThreshArgs = 0;
    ContinuousVariables = 0;
    ForEach(i,1,MaxVar) 
        if(Variable[i]->Continuous)
	    ContinuousVariables++;

    if(ContinuousVariables)
    {
        PossibleRelns++; /* Encoding as though one threshold relation */

	UpdateTupleOrders(); /* Reorder on variable values */

	ForEach(i,1,MaxVar)
	    if(Variable[i]->Continuous)
	    {
	        ThreshArgs += Max(Variable[i]->PossValues-1,0);
	    }
    }

    /* Info for uniform coding */

    RelnArgPairs = ThreshArgs;

    ForEach(i,0,MaxRel) RelnArgPairs += PossibleArgLists[i];

}

/*****************************************************************************/
/*                                                                           */
/* GrowNewClause - grows NewClause from present state until stopping         */
/*                 criterion satisfied.                                      */
/*                                                                           */
/*****************************************************************************/

    GrowNewClause(AllDeterminate)
/*  -------------                */

Boolean AllDeterminate; /* Are all literals so far determinate? */

{
    Literal L;
    int i, j, N, OldNLit;
    Clause SubClause;
    Boolean Progress = true, Recover();

    while ( Progress && Pos < Tot )
    {
	NDeterminate = 0;

	L = FindLiteral();

	if ( L )
	{
	    NewClause[NLit++] = L;

	    if(L->Rel==SAMEVAR && L->Sign) RecordEquivalence(L->Args);

	    UnfloatAssocDets(L);

            if(NLit%100==0) 
	    {
              NewClause=(Clause)prealloc(NewClause,(NLit+100)*sizeof(Literal));
	    }

	    NewTrainingSet(L->Rel, L->Sign, L->Args);
	    CheckOriginalCaseCover();

	    /*  Update encoding bits  */

	    UsedSoFar += L->Bits;
	    AvailableBits = Except(CycleTot, OrigPosCov) - UsedSoFar;

            AllDeterminate = false;

	    VERBOSE(1)
	    {
		printf("\nBest literal ");
		PrintLiteral(L->Rel, L->Sign, L->Args);
		printf(" (%.1f bits; %.1f bits left)\n", 
		       L->Bits, AvailableBits);
	    }

            if(L->Rel==Target) AddOrderingsDueTo(L);

	}
	else
	if ( NDeterminate )
	{
            OldNLit = NLit;

	    ProcessDeterminateLiterals();
	    CheckOriginalCaseCover();

            NewClause[NLit] = Nil;
            if( FASTFORWARD && AllDeterminate && (OldNLit!=NLit) )
	    {
                SubClause = (Clause)pmalloc((NLit-OldNLit+1)
                                             *sizeof(Literal));
                for( i = 0 ; i < NLit - OldNLit; i++ )
		{
                    j = i + OldNLit;
                    L = (Literal)pmalloc(sizeof(struct _lit_rec));
                    L->Rel  = NewClause[j]->Rel;
                    L->Sign = NewClause[j]->Sign;
                    L->Bits = NewClause[j]->Bits;

                    N = L->Rel->Arity + 1;
                    L->Args = (Vars) pmalloc(N);
                    memcpy(L->Args, NewClause[j]->Args, N);

                    L->FloatingDet = true;

                    SubClause[i] = L;
		}
                SubClause[i] = Nil;

                AllDeterminateClause[ADC++] = SubClause;
                if(ADC%100==0)
                    AllDeterminateClause = (Clause*)prealloc(
                              AllDeterminateClause, (ADC+100)*sizeof(Clause));
	    }

	}
	else
	Progress = Recover();
	
	DiscoverPartialOrders();
    }

    AllDeterminateClause[ADC] = Nil;

}

/*****************************************************************************/
/*                                                                           */
/* InitialiseClauseInfo - initialises various global variables for the clause*/
/*                        -growing                                           */
/*                                                                           */
/*****************************************************************************/

    InitialiseClauseInfo()
/*  --------------------  */

{
    int i, N;

    NewClause = (Clause) pmalloc(100 * sizeof(Literal));
    NToBeTried = NLit = 0;

    UsedSoFar = WeakLiterals = 0;
    CyclePos = Pos;
    CycleTot = Tot;

    AvailableBits = Except(CycleTot, Pos);
    memset(PartialOrder, '#', (MAXARITY+1)*(MAXARITY+1));
    ForEach(i,1,MAXARITY) PartialOrder[i][i] = '=';
    AnyPartialOrder = false;

    ForEach(i,1,MaxType)
    {
        TypeOrderCl[i][0] = TypeOrderDef[i][0];
	TypeOrderCl[i][1] = TypeOrderDef[i][1];
    }

    NRecLitCl = NRecLitDef;
    RecLitCl = (Ordering**) 
               pmalloc((101+100*(NRecLitCl/100))*sizeof(Ordering*));
    N = Target->Arity+1;
    RecLitCl[0] = (Ordering*) pmalloc(N*sizeof(Ordering));
    ForEach(i,1,NRecLitCl)
    {
        RecLitCl[i] = (Ordering*) pmalloc(N*sizeof(Ordering));
	memcpy(RecLitCl[i],RecLitDef[i],N);
    }

    ForEach(i, 1, MAXARITY) 
    {
        if(i>Target->Arity) ZeroVariableInfo(Variable[i]);
	else Variable[i]->OriginalVar = 0;
    }
}

/*****************************************************************************/
/*                                                                           */
/*  RegrowNewClause - if last literal of NewClause contains only LHS         */
/*                    variables, and is non-recursive, the clause has ended  */
/*                    with a literal with which it could have started. Take  */
/*                    such literals from end of clause and restart clause    */
/*                    with them, then grow clause from there.                */
/*                    (Except when no new variables appear in clause, or     */
/*                     those that do only appear in determinate literals).   */
/*                                                                           */
/*****************************************************************************/

    RegrowNewClause()
/*  ---------------  */

{
    Clause OrigClause;
    Literal L;
    Boolean Regrow, AllLitVarsLHS;
    int k, l;
    Relation R;

    if(!NLit) return; /* Clause is empty */

    Regrow = true;

    L = NewClause[NLit-1];
    if(L->Rel==Target) Regrow = false; /* Wish to avoid ordering problems */
    ForEach(k,1,L->Rel->Arity)
    {
        if(L->Args[k]>Target->Arity) Regrow = false;
    }

    if(Regrow)
    {
        AllLitVarsLHS = true;
        for(k=0;k<NLit&&AllLitVarsLHS;k++)
	{
	    L = NewClause[k];
	    if(L->Sign!=2)
	    {
	        ForEach(l,1,L->Rel->Arity)
		{
		    if(L->Args[l]>Target->Arity) AllLitVarsLHS = false;
		}
	    }
	}
    }
    if(AllLitVarsLHS) Regrow = false; /* Clause is already simple */

    if(!Regrow) return; /* Retain Current NewClause */

    VERBOSE(1)printf("\nRegrowing clause:\n");

    /* Need to reinitialise certain info */

    Discard(TrainingSet, true);
    TrainingSet = CopyTrainingSet;
    Pos = CyclePos;
    Tot = CycleTot;
    BaseInfo = InitialBaseInfo;
    MaxVar = Target->Arity;
    while(NRecLitCl)
        free(RecLitCl[NRecLitCl--]);

    k = NLit-1;
    OrigClause = NewClause;
    InitialiseClauseInfo();


    /* Restart the clause from the literals at the end of previous attempt*/

    AllLitVarsLHS = true;
    while ( AllLitVarsLHS && Regrow && (k>=0) )
    {
	BaseInfo = Info(Pos, Tot);
	VERBOSE(1)
	{
	    printf("\nTraining set (%d/%d=%.1f bits, %.1f bits available):\n"
		     , Pos, Tot, Pos*BaseInfo, AvailableBits);
	    VERBOSE(3)
		PrintTuples(MaxVar, TrainingSet, true, true, Nil);
	    newline;
	}

	if(NLit%100==0)
	{
	    NewClause = (Clause)Resize(NewClause,(NLit+101)*sizeof(Literal));
	}

	L = (Literal) pmalloc(sizeof(struct _lit_rec));
	L->Rel  = OrigClause[k]->Rel;
	L->Sign = OrigClause[k]->Sign;
	L->Args = (Vars) pmalloc(L->Rel->Arity + 1);
	memcpy(L->Args, OrigClause[k]->Args, L->Rel->Arity + 1);
	L->FloatingDet = false;
	k--;

	/* Need to estimate coding cost of literal */
	
	FindLitCostInfo();

	R = L->Rel;
	ForEach(l,0,MaxRel)
	{
	    if(RelnOrder[l]==R) break;
	}

	if(UNIFORMCODING)
	{
	    L->Bits = CostOfLit(1,RelnArgPairs,NLit);
	}
	else if( R->ConstantCmp == 2 ) /* Threshold relation */
	    L->Bits = CostOfLit(PossibleRelns,ThreshArgs,NLit);
	else if( R==SAMEVAR || R->ConstantCmp)
	    L->Bits = CostOfLit(PossibleRelns,EqualityRelnArgs,NLit);
	else
	    L->Bits = CostOfLit(PossibleRelns,PossibleArgLists[l],NLit);

	free(PossibleArgLists);

	if ( L->Bits > AvailableBits )
	{
	    VERBOSE(1)
		printf("\tLiteral needs too many bits\n");
	    Regrow = false;
	}
	else
	{
	    VERBOSE(1)
	    {
	        printf("Insert literal\n");
		printf("\t");
		PrintLiteral(L->Rel,L->Sign,L->Args);
		printf(" %.1f bits\n", L->Bits);
	    }

	    NewClause[NLit++] = L;

	    if(L->Rel==SAMEVAR && L->Sign) RecordEquivalence(L->Args);

	    NewTrainingSet(L->Rel, L->Sign, L->Args);	    
	    CheckOriginalCaseCover();

	    UsedSoFar += L->Bits;
	    AvailableBits = Except(CycleTot, OrigPosCov) - UsedSoFar;

	    VERBOSE(1)
	    {
	        printf("\t%.1f bits used, %.1f bits available\n",
                                                     UsedSoFar, AvailableBits);
	    }
	}

	L = OrigClause[k];
	ForEach(l,1,L->Rel->Arity)
	{
	    if(L->Args[l]>Target->Arity) AllLitVarsLHS = false;
	}
	if(L->Rel==Target) AllLitVarsLHS = false;
    }

    /* Now Regrow NewClause from this starting point */

    GrowNewClause(false);

}
